/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core;

import com.logicaldoc.util.config.ContextProperties;
import com.logicaldoc.util.plugin.PluginRegistry;
import com.logicaldoc.util.spring.Context;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.java.plugin.registry.Extension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemInfo {
    private static final Logger log = LoggerFactory.getLogger(SystemInfo.class);
    protected static final long serialVersionUID = 1L;
    protected String productName = "LogicalDOC Community";
    protected String product = "LogicalDOC";
    protected String release = "9.2.1";
    protected String year = "2006-2026";
    protected String help = "https://docs.logicaldoc.com";
    protected String bugs = "https://bugs.logicaldoc.com";
    protected String url = "https://www.logicaldoc.com";
    protected String forum = "https://github.com/logicaldoc/community/discussions";
    protected String evaluation = "";
    protected String vendor = "LogicalDOC";
    protected String vendorAddress = "via Aldo Moro interna, 3";
    protected String vendorCap = "41012";
    protected String vendorCountry = "Italy";
    protected String vendorCity = "Carpi";
    protected String support = "support@logicaldoc.com";
    protected String installationId;
    protected String licensee;
    protected String runLevel;
    protected long tenantId = 1L;
    protected Date date = new Date();
    protected String hostName;
    protected List<String> features = new ArrayList<String>();

    protected SystemInfo() {
    }

    protected SystemInfo(long tenantId) {
        this.tenantId = tenantId;
    }

    public static SystemInfo get(long tenantId) {
        Collection<Extension> exts;
        PluginRegistry registry;
        SystemInfo info = new SystemInfo(tenantId);
        try {
            registry = PluginRegistry.getInstance();
            exts = registry.getExtensions("logicaldoc-core", "SystemInfo");
            if (!exts.isEmpty()) {
                String className = exts.iterator().next().getParameter("class").valueAsString();
                Class<?> clazz = Class.forName(className);
                Object tmp = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (!(tmp instanceof SystemInfo)) {
                    throw new ClassNotFoundException("The specified info " + className + " doesn't implement SystemInfo interface");
                }
                info = (SystemInfo)tmp;
                info.setTenantId(tenantId);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
        }
        try {
            registry = PluginRegistry.getInstance();
            exts = registry.getExtensions("logicaldoc-core", "Feature");
            for (Extension extension : exts) {
                String name = extension.getParameter("name").valueAsString();
                info.getFeatures().add(name);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        try {
            ContextProperties config = Context.get().getProperties();
            info.setRelease(config.getProperty("product.release"));
            info.setYear(config.getProperty("product.year"));
            info.setRunLevel(config.getProperty("runlevel"));
            info.setInstallationId(config.getProperty("id"));
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        try {
            info.setHostName(InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return info;
    }

    public static SystemInfo get() {
        return SystemInfo.get(1L);
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public int getMajor() {
        String[] parts = this.getRelease().split("\\.");
        if (parts.length > 0) {
            return Integer.parseInt(parts[0]);
        }
        return 0;
    }

    public int getMinor() {
        String[] parts = this.getRelease().split("\\.");
        if (parts.length > 1) {
            return Integer.parseInt(parts[1]);
        }
        return 0;
    }

    public int getMicro() {
        String[] parts = this.getRelease().split("\\.");
        if (parts.length > 2) {
            return Integer.parseInt(parts[2]);
        }
        return 0;
    }

    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public String getProduct() {
        return this.product;
    }

    public void setProduct(String product) {
        this.product = product;
    }

    public String getRelease() {
        return this.release;
    }

    public void setRelease(String release) {
        this.release = release;
    }

    public String getYear() {
        return this.year;
    }

    public void setYear(String year) {
        this.year = year;
    }

    public String getHelp() {
        return this.help;
    }

    public void setHelp(String help) {
        this.help = help;
    }

    public String getBugs() {
        return this.bugs;
    }

    public void setBugs(String bugs) {
        this.bugs = bugs;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getForum() {
        return this.forum;
    }

    public void setForum(String forum) {
        this.forum = forum;
    }

    public String getVendor() {
        return this.vendor;
    }

    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    public String getVendorAddress() {
        return this.vendorAddress;
    }

    public void setVendorAddress(String vendorAddress) {
        this.vendorAddress = vendorAddress;
    }

    public String getVendorCap() {
        return this.vendorCap;
    }

    public void setVendorCap(String vendorCap) {
        this.vendorCap = vendorCap;
    }

    public String getVendorCountry() {
        return this.vendorCountry;
    }

    public void setVendorCountry(String vendorCountry) {
        this.vendorCountry = vendorCountry;
    }

    public String getVendorCity() {
        return this.vendorCity;
    }

    public void setVendorCity(String vendorCity) {
        this.vendorCity = vendorCity;
    }

    public String getSupport() {
        return this.support;
    }

    public void setSupport(String support) {
        this.support = support;
    }

    public String getInstallationId() {
        return this.installationId;
    }

    public void setInstallationId(String installationId) {
        this.installationId = installationId;
    }

    public String getLicensee() {
        return this.licensee;
    }

    public void setLicensee(String licensee) {
        this.licensee = licensee;
    }

    public String getRunLevel() {
        return this.runLevel;
    }

    public void setRunLevel(String runLevel) {
        this.runLevel = runLevel;
    }

    public long getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(long tenantId) {
        this.tenantId = tenantId;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public List<String> getFeatures() {
        return this.features;
    }

    public void setFeatures(List<String> features) {
        this.features = features;
    }

    public String getEvaluation() {
        return this.evaluation;
    }

    public void setEvaluation(String evaluation) {
        this.evaluation = evaluation;
    }
}

