/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core;

import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import org.springframework.jdbc.InvalidResultSetAccessException;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.jdbc.support.rowset.SqlRowSetMetaData;

public class SqlRowSetWrapper
implements SqlRowSet {
    private static final long serialVersionUID = 1L;
    private SqlRowSet rowSet;

    public SqlRowSetWrapper(SqlRowSet rowSet) {
        this.rowSet = rowSet;
    }

    private SqlRowSetWrapper() {
    }

    public boolean absolute(int row) throws InvalidResultSetAccessException {
        return this.rowSet.absolute(row);
    }

    public void afterLast() throws InvalidResultSetAccessException {
        this.rowSet.afterLast();
    }

    public void beforeFirst() throws InvalidResultSetAccessException {
        this.rowSet.beforeFirst();
    }

    public int findColumn(String columnLabel) throws InvalidResultSetAccessException {
        return this.rowSet.findColumn(columnLabel);
    }

    public boolean first() throws InvalidResultSetAccessException {
        return this.rowSet.first();
    }

    public BigDecimal getBigDecimal(int arg0) throws InvalidResultSetAccessException {
        return this.rowSet.getBigDecimal(arg0);
    }

    public BigDecimal getBigDecimal(String arg0) throws InvalidResultSetAccessException {
        return this.rowSet.getBigDecimal(arg0);
    }

    public boolean getBoolean(int columnIndex) throws InvalidResultSetAccessException {
        return this.rowSet.getBoolean(columnIndex);
    }

    public boolean getBoolean(String columnLabel) throws InvalidResultSetAccessException {
        return this.rowSet.getBoolean(columnLabel);
    }

    public byte getByte(int columnIndex) throws InvalidResultSetAccessException {
        return this.rowSet.getByte(columnIndex);
    }

    public byte getByte(String columnLabel) throws InvalidResultSetAccessException {
        return this.rowSet.getByte(columnLabel);
    }

    public java.sql.Date getDate(int arg0, Calendar arg1) throws InvalidResultSetAccessException {
        return this.rowSet.getDate(arg0, arg1);
    }

    public java.sql.Date getDate(int arg0) throws InvalidResultSetAccessException {
        try {
            return this.rowSet.getDate(arg0);
        }
        catch (ClassCastException ce) {
            return this.getDate(this.rowSet.getObject(arg0));
        }
    }

    public java.sql.Date getDate(String arg0, Calendar arg1) throws InvalidResultSetAccessException {
        return this.rowSet.getDate(arg0, arg1);
    }

    public java.sql.Date getDate(String arg0) throws InvalidResultSetAccessException {
        try {
            return this.rowSet.getDate(arg0);
        }
        catch (ClassCastException ce) {
            return this.getDate(this.rowSet.getObject(arg0));
        }
    }

    private java.sql.Date getDate(Object obj) {
        if (obj instanceof java.sql.Date) {
            java.sql.Date date = (java.sql.Date)obj;
            return date;
        }
        if (obj instanceof Timestamp) {
            Timestamp timeStamp = (Timestamp)obj;
            return new java.sql.Date(Date.from(timeStamp.toLocalDateTime().atZone(ZoneId.systemDefault()).toInstant()).getTime());
        }
        if (obj instanceof Date) {
            Date utilDate = (Date)obj;
            return new java.sql.Date(utilDate.getTime());
        }
        if (obj instanceof LocalDateTime) {
            LocalDateTime localDateTime = (LocalDateTime)obj;
            return new java.sql.Date(Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant()).getTime());
        }
        return null;
    }

    public double getDouble(int columnIndex) throws InvalidResultSetAccessException {
        return this.rowSet.getDouble(columnIndex);
    }

    public double getDouble(String columnLabel) throws InvalidResultSetAccessException {
        return this.rowSet.getDouble(columnLabel);
    }

    public float getFloat(int columnIndex) throws InvalidResultSetAccessException {
        return this.rowSet.getFloat(columnIndex);
    }

    public float getFloat(String columnLabel) throws InvalidResultSetAccessException {
        return this.rowSet.getFloat(columnLabel);
    }

    public int getInt(int columnIndex) throws InvalidResultSetAccessException {
        return this.rowSet.getInt(columnIndex);
    }

    public int getInt(String columnLabel) throws InvalidResultSetAccessException {
        return this.rowSet.getInt(columnLabel);
    }

    public long getLong(int columnIndex) throws InvalidResultSetAccessException {
        return this.rowSet.getLong(columnIndex);
    }

    public long getLong(String columnLabel) throws InvalidResultSetAccessException {
        return this.rowSet.getLong(columnLabel);
    }

    public SqlRowSetMetaData getMetaData() {
        return this.rowSet.getMetaData();
    }

    public String getNString(int arg0) throws InvalidResultSetAccessException {
        return this.rowSet.getNString(arg0);
    }

    public String getNString(String arg0) throws InvalidResultSetAccessException {
        return this.rowSet.getNString(arg0);
    }

    public <T> T getObject(int arg0, Class<T> arg1) throws InvalidResultSetAccessException {
        return (T)this.rowSet.getObject(arg0, arg1);
    }

    public Object getObject(int arg0, Map<String, Class<?>> arg1) throws InvalidResultSetAccessException {
        return this.rowSet.getObject(arg0, arg1);
    }

    public Object getObject(int arg0) throws InvalidResultSetAccessException {
        return this.rowSet.getObject(arg0);
    }

    public <T> T getObject(String arg0, Class<T> arg1) throws InvalidResultSetAccessException {
        return (T)this.rowSet.getObject(arg0, arg1);
    }

    public Object getObject(String arg0, Map<String, Class<?>> arg1) throws InvalidResultSetAccessException {
        return this.rowSet.getObject(arg0, arg1);
    }

    public Object getObject(String arg0) throws InvalidResultSetAccessException {
        return this.rowSet.getObject(arg0);
    }

    public int getRow() throws InvalidResultSetAccessException {
        return this.rowSet.getRow();
    }

    public short getShort(int columnIndex) throws InvalidResultSetAccessException {
        return this.rowSet.getShort(columnIndex);
    }

    public short getShort(String columnLabel) throws InvalidResultSetAccessException {
        return this.rowSet.getShort(columnLabel);
    }

    public String getString(int arg0) throws InvalidResultSetAccessException {
        return this.rowSet.getString(arg0);
    }

    public String getString(String arg0) throws InvalidResultSetAccessException {
        return this.rowSet.getString(arg0);
    }

    public Time getTime(int arg0, Calendar arg1) throws InvalidResultSetAccessException {
        return this.rowSet.getTime(arg0, arg1);
    }

    public Time getTime(int arg0) throws InvalidResultSetAccessException {
        return this.rowSet.getTime(arg0);
    }

    public Time getTime(String arg0, Calendar arg1) throws InvalidResultSetAccessException {
        return this.rowSet.getTime(arg0, arg1);
    }

    public Time getTime(String arg0) throws InvalidResultSetAccessException {
        return this.rowSet.getTime(arg0);
    }

    public Timestamp getTimestamp(int arg0, Calendar arg1) throws InvalidResultSetAccessException {
        return this.rowSet.getTimestamp(arg0, arg1);
    }

    public Timestamp getTimestamp(int arg0) throws InvalidResultSetAccessException {
        return this.rowSet.getTimestamp(arg0);
    }

    public Timestamp getTimestamp(String arg0, Calendar arg1) throws InvalidResultSetAccessException {
        return this.rowSet.getTimestamp(arg0, arg1);
    }

    public Timestamp getTimestamp(String arg0) throws InvalidResultSetAccessException {
        return this.rowSet.getTimestamp(arg0);
    }

    public boolean isAfterLast() throws InvalidResultSetAccessException {
        return this.rowSet.isAfterLast();
    }

    public boolean isBeforeFirst() throws InvalidResultSetAccessException {
        return this.rowSet.isBeforeFirst();
    }

    public boolean isFirst() throws InvalidResultSetAccessException {
        return this.rowSet.isFirst();
    }

    public boolean isLast() throws InvalidResultSetAccessException {
        return this.rowSet.isLast();
    }

    public boolean last() throws InvalidResultSetAccessException {
        return this.rowSet.last();
    }

    public boolean next() throws InvalidResultSetAccessException {
        return this.rowSet.next();
    }

    public boolean previous() throws InvalidResultSetAccessException {
        return this.rowSet.previous();
    }

    public boolean relative(int rows) throws InvalidResultSetAccessException {
        return this.rowSet.relative(rows);
    }

    public boolean wasNull() throws InvalidResultSetAccessException {
        return this.rowSet.wasNull();
    }
}

