/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core;

import com.logicaldoc.core.exception.AspectDisabledException;
import com.logicaldoc.util.config.ContextProperties;
import com.logicaldoc.util.plugin.PluginRegistry;
import com.logicaldoc.util.spring.Context;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.java.plugin.registry.Extension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum RunLevel {
    DEFAULT("default"),
    BULKLOAD("bulkload"),
    DEVEL("devel"),
    DEMO("demo"),
    UPDATED("updated"),
    SLAVE("slave");

    private static final Logger log;
    private String level;

    static {
        log = LoggerFactory.getLogger(RunLevel.class);
    }

    private RunLevel(String level) {
        this.level = level;
    }

    public String toString() {
        return this.level;
    }

    public static RunLevel current() {
        ContextProperties config = RunLevel.getConfig();
        String runLevel = config != null ? config.getProperty("runlevel", DEFAULT.toString()) : DEFAULT.toString();
        return RunLevel.fromString(runLevel);
    }

    public static RunLevel fromString(String event) {
        if (event != null) {
            RunLevel[] runLevelArray = RunLevel.values();
            int n = runLevelArray.length;
            int n2 = 0;
            while (n2 < n) {
                RunLevel b = runLevelArray[n2];
                if (event.equalsIgnoreCase(b.level)) {
                    return b;
                }
                ++n2;
            }
        }
        return DEFAULT;
    }

    private String getAspectProperty(String aspect) {
        return "aspect." + aspect + "." + this.level;
    }

    public boolean aspectEnabled(String aspect) {
        ContextProperties config = RunLevel.getConfig();
        return config != null && config.getBoolean(this.getAspectProperty(aspect), false);
    }

    public void checkAspect(String aspect) throws AspectDisabledException {
        if (!this.aspectEnabled(aspect)) {
            throw new AspectDisabledException(aspect);
        }
    }

    public void setAspect(String aspect, boolean enabled) {
        ContextProperties config = RunLevel.getConfig();
        if (config != null) {
            config.setProperty(this.getAspectProperty(aspect), "" + enabled);
        }
    }

    private static ContextProperties getConfig() {
        ContextProperties conf = null;
        try {
            Context context = Context.get();
            if (context != null) {
                conf = context.getProperties();
            }
        }
        catch (Exception context) {
            // empty catch block
        }
        if (conf == null) {
            try {
                conf = new ContextProperties();
            }
            catch (IOException e) {
                log.error(e.getMessage(), e);
            }
        }
        return conf;
    }

    public boolean isDefault() {
        return this == DEFAULT;
    }

    public boolean isDemo() {
        return this == DEMO;
    }

    public boolean isBulkload() {
        return this == BULKLOAD;
    }

    public boolean isDevel() {
        return this == DEVEL;
    }

    public static List<String> getAspects() {
        PluginRegistry registry = PluginRegistry.getInstance();
        Collection<Extension> exts = registry.getExtensions("logicaldoc-core", "Aspect");
        ArrayList<String> aspects = new ArrayList<String>();
        for (Extension ext : exts) {
            aspects.add(ext.getParameter("code").valueAsString());
        }
        Collections.sort(aspects);
        return aspects;
    }
}

