/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.PersistentObject;
import com.logicaldoc.core.ResultSetWalker;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.jdbc.core.RowMapper;

public interface PersistentObjectDAO<T extends PersistentObject> {
    public static final String ENTITY = "_entity";

    public void store(T var1) throws PersistenceException;

    public T findById(long var1) throws PersistenceException;

    public T findById(long var1, boolean var3) throws PersistenceException;

    public List<T> findAll() throws PersistenceException;

    public List<T> findAll(long var1) throws PersistenceException;

    public List<Long> findAllIds() throws PersistenceException;

    public List<Long> findAllIds(long var1) throws PersistenceException;

    public List<T> findByWhere(String var1, String var2, Integer var3) throws PersistenceException;

    public List<T> findByWhere(String var1, Map<String, Object> var2, String var3, Integer var4) throws PersistenceException;

    public List<T> findByObjectQuery(String var1, Map<String, Object> var2, Integer var3) throws PersistenceException;

    public List<Object[]> findByQuery(String var1, Map<String, Object> var2, Integer var3) throws PersistenceException;

    public <R> List<R> findByQuery(String var1, Map<String, Object> var2, Class<R> var3, Integer var4) throws PersistenceException;

    public List<Long> findIdsByWhere(String var1, String var2, Integer var3) throws PersistenceException;

    public List<Long> findIdsByWhere(String var1, Map<String, Object> var2, String var3, Integer var4) throws PersistenceException;

    public void initialize(T var1) throws PersistenceException;

    public <P> List<P> query(String var1, RowMapper<P> var2, Integer var3) throws PersistenceException;

    public <P> List<P> query(String var1, Map<String, Object> var2, RowMapper<P> var3, Integer var4) throws PersistenceException;

    public void queryForResultSet(String var1, Map<String, Object> var2, Integer var3, ResultSetWalker var4) throws PersistenceException;

    public <R> List<R> queryForList(String var1, Map<String, Object> var2, Class<R> var3, Integer var4) throws PersistenceException;

    public <R> List<R> queryForList(String var1, Class<R> var2, Integer var3) throws PersistenceException;

    public <R> List<R> queryForList(String var1, Class<R> var2) throws PersistenceException;

    public int queryForInt(String var1) throws PersistenceException;

    public int queryForInt(String var1, Map<String, Object> var2) throws PersistenceException;

    public long queryForLong(String var1) throws PersistenceException;

    public long queryForLong(String var1, Map<String, Object> var2) throws PersistenceException;

    public double queryForDouble(String var1) throws PersistenceException;

    public double queryForDouble(String var1, Map<String, Object> var2) throws PersistenceException;

    public String queryForString(String var1) throws PersistenceException;

    public String queryForString(String var1, Map<String, Object> var2) throws PersistenceException;

    public <R> R queryForObject(String var1, Class<R> var2) throws PersistenceException;

    public <R> R queryForObject(String var1, Map<String, Object> var2, Class<R> var3) throws PersistenceException;

    public void delete(long var1) throws PersistenceException;

    public void delete(long var1, int var3) throws PersistenceException;

    public void deleteAll(Collection<T> var1) throws PersistenceException;

    public void deleteAll(Collection<T> var1, int var2) throws PersistenceException;

    public void evict(Class<? extends PersistentObject> var1, long var2);

    public void evict(long var1);

    public int bulkUpdate(String var1, Map<String, Object> var2) throws PersistenceException;

    public int jdbcUpdate(String var1) throws PersistenceException;

    public int jdbcUpdate(String var1, Map<String, Object> var2) throws PersistenceException;

    public String getDbms();

    public boolean isOracle();

    public boolean isMySQL();

    public Map<String, String> getDatabaseMetadata();
}

