/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core;

import jakarta.persistence.Column;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.Version;
import java.io.Serializable;
import java.util.Date;
import org.hibernate.annotations.SQLRestriction;

@MappedSuperclass
@SQLRestriction(value="ld_deleted=0")
public abstract class PersistentObject
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int DELETED_CODE_DEFAULT = 1;
    public static final int DELETED_CODE_STRONG = 2;
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @Column(name="ld_id")
    public long id = 0L;
    @Column(name="ld_tenantid", nullable=false)
    private long tenantId = 1L;
    @Column(name="ld_deleted", nullable=false)
    private int deleted = 0;
    @Column(name="ld_lastmodified", nullable=false, columnDefinition="DATETIME(3)")
    private Date lastModified = new Date();
    @Column(name="ld_creation", nullable=false, columnDefinition="DATETIME(3)")
    private Date creation = new Date();
    @Version
    @Column(name="ld_recordversion", nullable=false)
    private long recordVersion = 0L;

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified;
    }

    public int getDeleted() {
        return this.deleted;
    }

    public void setDeleted(int deleted) {
        this.deleted = deleted;
    }

    public String toString() {
        return Long.toString(this.getId());
    }

    public long getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(long tenantId) {
        this.tenantId = tenantId;
    }

    public long getRecordVersion() {
        return this.recordVersion;
    }

    public void setRecordVersion(long recordVersion) {
        this.recordVersion = recordVersion;
    }

    public Date getCreation() {
        return this.creation;
    }

    public void setCreation(Date creation) {
        this.creation = creation;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PersistentObject other = (PersistentObject)obj;
        return this.id == other.id;
    }
}

