/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class NamedParameterStatement
implements AutoCloseable {
    private final PreparedStatement statement;
    private final Map<String, List<Integer>> indexMap = new HashMap<String, List<Integer>>();

    public NamedParameterStatement(Connection connection, String query, Map<String, Object> parameters) throws SQLException {
        this(connection, query, parameters, null);
    }

    public NamedParameterStatement(Connection connection, String query, Map<String, Object> parameters, Integer maxRows) throws SQLException {
        HashMap<String, Object> usedParameters = new HashMap<String, Object>();
        if (parameters != null) {
            for (Map.Entry<String, Object> entry : parameters.entrySet()) {
                if (!query.contains(":" + entry.getKey())) continue;
                usedParameters.put(entry.getKey(), entry.getValue());
            }
        }
        String parsedQuery = NamedParameterStatement.parse(query, this.indexMap);
        this.statement = connection.prepareStatement(parsedQuery);
        if (!usedParameters.isEmpty()) {
            this.setParameters(usedParameters);
        }
        if (maxRows != null) {
            this.statement.setMaxRows(maxRows);
        }
    }

    private static final String parse(String query, Map<String, List<Integer>> paramMap) {
        int length = query.length();
        StringBuilder parsedQuery = new StringBuilder(length);
        boolean inSingleQuote = false;
        boolean inDoubleQuote = false;
        int index = 1;
        int i = 0;
        while (i < length) {
            int c = query.charAt(i);
            if (inSingleQuote && c == 39) {
                inSingleQuote = false;
            } else if (inDoubleQuote && c == 34) {
                inDoubleQuote = false;
            } else if (c == 39) {
                inSingleQuote = true;
            } else if (c == 34) {
                inDoubleQuote = true;
            } else if (c == 58 && i + 1 < length && Character.isJavaIdentifierStart(query.charAt(i + 1))) {
                String name = NamedParameterStatement.getParameterName(query, i);
                c = 63;
                i += name.length();
                paramMap.putIfAbsent(name, new LinkedList());
                paramMap.get(name).add(index++);
            }
            parsedQuery.append((char)c);
            ++i;
        }
        return parsedQuery.toString();
    }

    private static String getParameterName(String query, int currentPosition) {
        int j = currentPosition + 2;
        while (j < query.length() && Character.isJavaIdentifierPart(query.charAt(j))) {
            ++j;
        }
        return query.substring(currentPosition + 1, j);
    }

    private Integer[] getIndexes(String name) {
        Integer[] indexes = this.indexMap.get(name).toArray(new Integer[0]);
        if (indexes == null) {
            throw new IllegalArgumentException("Parameter not found: " + name);
        }
        return indexes;
    }

    public void setParameters(Map<String, Object> parameters) throws SQLException {
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            Object object = entry.getValue();
            if (object instanceof String) {
                String str = (String)object;
                this.setString(entry.getKey(), str);
                continue;
            }
            Object object2 = entry.getValue();
            if (object2 instanceof Integer) {
                Integer intg = (Integer)object2;
                this.setInt(entry.getKey(), intg);
                continue;
            }
            Object object3 = entry.getValue();
            if (object3 instanceof Long) {
                Long lng = (Long)object3;
                this.setLong(entry.getKey(), lng);
                continue;
            }
            Object object4 = entry.getValue();
            if (object4 instanceof Timestamp) {
                Timestamp timestamp = (Timestamp)object4;
                this.setTimestamp(entry.getKey(), timestamp);
                continue;
            }
            Object object5 = entry.getValue();
            if (object5 instanceof Date) {
                Date date = (Date)object5;
                this.setTimestamp(entry.getKey(), new Timestamp(date.getTime()));
                continue;
            }
            this.setObject(entry.getKey(), entry.getValue());
        }
    }

    public void setObject(String name, Object value) throws SQLException {
        Integer[] indexes = this.getIndexes(name);
        int i = 0;
        while (i < indexes.length) {
            this.statement.setObject(indexes[i], value);
            ++i;
        }
    }

    public void setString(String name, String value) throws SQLException {
        Integer[] indexes = this.getIndexes(name);
        int i = 0;
        while (i < indexes.length) {
            this.statement.setString(indexes[i], value);
            ++i;
        }
    }

    public void setInt(String name, int value) throws SQLException {
        Integer[] indexes = this.getIndexes(name);
        int i = 0;
        while (i < indexes.length) {
            this.statement.setInt(indexes[i], value);
            ++i;
        }
    }

    public void setLong(String name, long value) throws SQLException {
        Integer[] indexes = this.getIndexes(name);
        int i = 0;
        while (i < indexes.length) {
            this.statement.setLong(indexes[i], value);
            ++i;
        }
    }

    public void setTimestamp(String name, Timestamp value) throws SQLException {
        Integer[] indexes = this.getIndexes(name);
        int i = 0;
        while (i < indexes.length) {
            this.statement.setTimestamp(indexes[i], value);
            ++i;
        }
    }

    public PreparedStatement getStatement() {
        return this.statement;
    }

    public boolean execute() throws SQLException {
        return this.statement.execute();
    }

    public ResultSet executeQuery() throws SQLException {
        return this.statement.executeQuery();
    }

    public int executeUpdate() throws SQLException {
        return this.statement.executeUpdate();
    }

    @Override
    public void close() throws SQLException {
        this.statement.close();
    }

    public void addBatch() throws SQLException {
        this.statement.addBatch();
    }

    public int[] executeBatch() throws SQLException {
        return this.statement.executeBatch();
    }
}

