/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core;

import com.logicaldoc.core.PersistentObject;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import org.hibernate.Interceptor;
import org.hibernate.type.Type;

public class LastModifiedInterceptor
implements Interceptor {
    protected static final String LAST_MODIFIED = "lastModified";

    public boolean onFlushDirty(Object entity, Serializable id, Object[] currentState, Object[] previousState, String[] propertyNames, Type[] types) {
        return this.onSave(entity, id, currentState, propertyNames, types);
    }

    public boolean onSave(Object entity, Serializable id, Object[] currentState, String[] propertyNames, Type[] types) {
        if (entity instanceof PersistentObject) {
            return this.setValue(currentState, propertyNames, LAST_MODIFIED, new Date());
        }
        return false;
    }

    protected boolean setValue(Object[] currentState, String[] propertyNames, String propertyToSet, Object value) {
        int index = Arrays.asList(propertyNames).indexOf(propertyToSet);
        if (index >= 0) {
            currentState[index] = value;
            return true;
        }
        return false;
    }
}

