/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core;

import com.logicaldoc.core.NamedParameterStatement;
import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.PersistentObject;
import com.logicaldoc.core.PersistentObjectDAO;
import com.logicaldoc.core.ResultSetWalker;
import com.logicaldoc.core.RunLevel;
import com.logicaldoc.core.metadata.Attribute;
import com.logicaldoc.core.metadata.ExtensibleObject;
import com.logicaldoc.util.config.ContextProperties;
import com.logicaldoc.util.spring.Context;
import jakarta.annotation.Resource;
import jakarta.transaction.Transactional;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.query.MutationQuery;
import org.hibernate.query.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.RowMapper;

@Transactional
public abstract class HibernatePersistentObjectDAO<T extends PersistentObject>
implements PersistentObjectDAO<T> {
    private static final String UPDATE = "update ";
    private static final String DATA_SOURCE = "DataSource";
    private static final String AND = " and (";
    protected Logger log = LoggerFactory.getLogger(HibernatePersistentObjectDAO.class);
    protected Class<T> entityClass;
    @Resource(name="SessionFactory")
    protected SessionFactory sessionFactory;
    protected static final String ORDER_BY = " order by ";
    protected static final String ASPECT_STORING = "storing";
    protected static final String DEFAULT_WHERE_PREAMBLE = " _entity where _entity.deleted=0 ";

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    protected HibernatePersistentObjectDAO(Class<T> entityClass) {
        this.entityClass = entityClass;
    }

    @Override
    public void delete(long id, int code) throws PersistenceException {
        if (code == 0) {
            throw new IllegalArgumentException("code cannot be 0");
        }
        if (!this.checkStoringAspect()) {
            return;
        }
        T entity = this.findById(id);
        if (entity == null) {
            return;
        }
        ((PersistentObject)entity).setDeleted(code);
        this.store(entity);
    }

    @Override
    public void delete(long id) throws PersistenceException {
        this.delete(id, 1);
    }

    @Override
    public List<T> findAll() throws PersistenceException {
        return this.findByWhere("", "", null);
    }

    @Override
    public List<T> findAll(long tenantId) throws PersistenceException {
        return this.findByWhere(" _entity.tenantId=" + tenantId, "", null);
    }

    @Override
    public List<Long> findAllIds() throws PersistenceException {
        return this.findIdsByWhere("", "", null);
    }

    @Override
    public List<Long> findAllIds(long tenantId) throws PersistenceException {
        return this.findIdsByWhere(" _entity.tenantId=" + tenantId, "", null);
    }

    @Override
    public T findById(long id, boolean initialize) throws PersistenceException {
        T entity = this.findById(id);
        if (initialize) {
            this.initialize(entity);
        }
        return entity;
    }

    @Override
    public T findById(long id) throws PersistenceException {
        PersistentObject entity;
        block3: {
            entity = null;
            try {
                entity = (PersistentObject)this.getCurrentSession().get(this.entityClass, (Object)id);
                if (entity == null || entity.getDeleted() == 0) break block3;
            }
            catch (Exception e) {
                throw new PersistenceException(e);
            }
            return null;
        }
        return (T)entity;
    }

    @Override
    public List<T> findByWhere(String where, String order, Integer max) throws PersistenceException {
        return this.findByWhere(where, null, order, max);
    }

    @Override
    public List<T> findByWhere(String where, Map<String, Object> parameters, String order, Integer max) throws PersistenceException {
        List<Object> coll = new ArrayList();
        try {
            String sorting = StringUtils.isNotEmpty(order) && !order.toLowerCase().contains(ORDER_BY.trim()) ? ORDER_BY + order : order;
            String query = "from " + this.entityClass.getCanonicalName() + DEFAULT_WHERE_PREAMBLE + (String)(StringUtils.isNotEmpty(where) ? AND + where + ") " : " ") + (StringUtils.isNotEmpty(sorting) ? sorting : " ");
            coll = this.findByObjectQuery(query, parameters, max);
            return coll;
        }
        catch (Exception e) {
            throw new PersistenceException(e);
        }
    }

    @Override
    public List<T> findByObjectQuery(String query, Map<String, Object> parameters, Integer max) throws PersistenceException {
        try {
            this.logQuery(query);
            return this.prepareQuery(query, parameters, this.entityClass, max).list();
        }
        catch (Exception e) {
            throw new PersistenceException(e);
        }
    }

    protected void logQuery(String query) {
        this.log.debug("Execute query: {}", (Object)query);
    }

    @Override
    public List<Object[]> findByQuery(String query, Map<String, Object> parameters, Integer max) throws PersistenceException {
        try {
            this.logQuery(query);
            return this.prepareQuery(query, parameters, max).list();
        }
        catch (Exception e) {
            throw new PersistenceException(e);
        }
    }

    @Override
    public <R> List<R> findByQuery(String query, Map<String, Object> parameters, Class<R> requiredType, Integer max) throws PersistenceException {
        try {
            this.logQuery(query);
            return this.prepareQuery(query, parameters, requiredType, max).list();
        }
        catch (Exception e) {
            throw new PersistenceException(e);
        }
    }

    @Override
    public List<Long> findIdsByWhere(String where, String order, Integer max) throws PersistenceException {
        return this.findIdsByWhere(where, new HashMap<String, Object>(), order, max);
    }

    @Override
    public List<Long> findIdsByWhere(String where, Map<String, Object> parameters, String order, Integer max) throws PersistenceException {
        try {
            String sorting = StringUtils.isNotEmpty(order) && !order.toLowerCase().contains(ORDER_BY.trim()) ? ORDER_BY + order : order;
            String query = "select _entity.id from " + this.entityClass.getCanonicalName() + DEFAULT_WHERE_PREAMBLE + (String)(StringUtils.isNotEmpty(where) ? AND + where + ") " : " ") + (StringUtils.isNotEmpty(sorting) ? sorting : " ");
            this.logQuery(query);
            Query<Long> queryObject = this.prepareQuery(query, parameters, Long.class, max);
            return queryObject.list();
        }
        catch (Exception e) {
            throw new PersistenceException(e);
        }
    }

    protected boolean checkStoringAspect() {
        if (!RunLevel.current().aspectEnabled(ASPECT_STORING)) {
            this.log.error("Apect {} is disabled", (Object)ASPECT_STORING);
            return false;
        }
        return true;
    }

    @Override
    public void store(T entity) throws PersistenceException {
        if (!this.checkStoringAspect()) {
            return;
        }
        ((PersistentObject)entity).setLastModified(new Date());
        try {
            this.saveOrUpdate((PersistentObject)entity);
        }
        catch (Exception e) {
            throw new PersistenceException(e);
        }
    }

    protected void saveOrUpdate(PersistentObject entity) {
        Session session;
        PersistentObject obj;
        if (entity instanceof ExtensibleObject) {
            ExtensibleObject extensibleEntity = (ExtensibleObject)entity;
            try {
                for (String name : extensibleEntity.getAttributes().keySet()) {
                    Attribute att = extensibleEntity.getAttribute(name);
                    if (att.getMultiple() == 1 && att.getType() == 0) {
                        String vals = extensibleEntity.getValues(name).stream().map(Object::toString).collect(Collectors.joining(","));
                        att.setStringValues(vals);
                        continue;
                    }
                    att.setStringValues(null);
                }
            }
            catch (Exception name) {
                // empty catch block
            }
        }
        if (Objects.isNull(obj = (PersistentObject)(session = this.getCurrentSession()).find(entity.getClass(), (Object)entity.getId()))) {
            session.persist((Object)entity);
            this.flush();
        } else {
            PersistentObject persistedEntity = (PersistentObject)session.merge((Object)entity);
            this.flush();
            entity.setRecordVersion(persistedEntity.getRecordVersion());
        }
    }

    protected void flush() {
        try {
            this.getCurrentSession().flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void refresh(Object entity) {
        if (entity == null) {
            return;
        }
        try {
            if (!this.getCurrentSession().contains(entity)) {
                this.getCurrentSession().refresh(entity);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected Object merge(Object entity) {
        try {
            return this.getCurrentSession().merge(entity);
        }
        catch (Exception t) {
            this.log.error(t.getMessage(), t);
            return null;
        }
    }

    protected Query<Object[]> prepareQuery(String expression, Map<String, Object> values, Integer max) {
        Query queryObject = this.getCurrentSession().createQuery(expression, Object[].class);
        this.applyParametersAndLimit(values, max, queryObject);
        return queryObject;
    }

    protected <R> Query<R> prepareQuery(String expression, Map<String, Object> values, Class<R> requiredType, Integer max) {
        Query queryObject = this.getCurrentSession().createQuery(expression, requiredType);
        this.applyParametersAndLimit(values, max, queryObject);
        return queryObject;
    }

    private void applyParametersAndLimit(Map<String, Object> parameters, Integer max, Query<?> queryObject) {
        if (parameters != null) {
            for (Map.Entry<String, Object> entry : parameters.entrySet()) {
                queryObject.setParameter(entry.getKey(), entry.getValue());
            }
        }
        if (max != null && max > 0) {
            queryObject.setMaxResults(max.intValue());
        }
    }

    private void applyParameters(Map<String, Object> parameters, MutationQuery queryObject) {
        if (parameters != null) {
            for (Map.Entry<String, Object> entry : parameters.entrySet()) {
                queryObject.setParameter(entry.getKey(), entry.getValue());
            }
        }
    }

    @Override
    public void initialize(T entity) throws PersistenceException {
    }

    protected Session getCurrentSession() {
        return this.sessionFactory.getCurrentSession();
    }

    @Override
    public <P> List<P> query(String sql, RowMapper<P> rowMapper, Integer maxRows) throws PersistenceException {
        return this.query(sql, null, rowMapper, maxRows);
    }

    @Override
    public <P> List<P> query(String sql, Map<String, Object> parameters, RowMapper<P> rowMapper, Integer maxRows) throws PersistenceException {
        return (List)this.getCurrentSession().doReturningWork(connection -> {
            ArrayList<Object> result = new ArrayList<Object>();
            try {
                Throwable throwable = null;
                Object var8_10 = null;
                try {
                    ArrayList<Object> arrayList;
                    ResultSet rs;
                    NamedParameterStatement stmt;
                    block19: {
                        block18: {
                            stmt = new NamedParameterStatement(connection, sql, parameters, maxRows);
                            rs = stmt.executeQuery();
                            this.logStatement(sql, connection);
                            int i = 0;
                            while (rs.next()) {
                                result.add(rowMapper.mapRow(rs, i++));
                            }
                            arrayList = result;
                            if (rs == null) break block18;
                            rs.close();
                        }
                        if (stmt == null) break block19;
                        stmt.close();
                    }
                    return arrayList;
                    {
                        catch (Throwable throwable2) {
                            try {
                                if (rs != null) {
                                    rs.close();
                                }
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                if (throwable == null) {
                                    throwable = throwable3;
                                } else if (throwable != throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                if (stmt != null) {
                                    stmt.close();
                                }
                                throw throwable;
                            }
                        }
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                throw new PersistenceException(e.getMessage(), e);
            }
        });
    }

    @Override
    public <R> List<R> queryForList(String sql, Class<R> requiredType) throws PersistenceException {
        return this.queryForList(sql, requiredType, null);
    }

    @Override
    public <R> List<R> queryForList(String sql, Class<R> requiredType, Integer maxRows) throws PersistenceException {
        return this.queryForList(sql, null, requiredType, maxRows);
    }

    @Override
    public <R> List<R> queryForList(String sql, Map<String, Object> parameters, Class<R> requiredType, Integer maxRows) throws PersistenceException {
        return (List)this.getCurrentSession().doReturningWork(connection -> {
            ArrayList result = new ArrayList();
            try {
                Throwable throwable = null;
                Object var8_10 = null;
                try {
                    ArrayList arrayList;
                    ResultSet rs;
                    NamedParameterStatement stmt;
                    block19: {
                        block18: {
                            stmt = new NamedParameterStatement(connection, sql, parameters, maxRows);
                            rs = stmt.executeQuery();
                            this.logStatement(sql, connection);
                            while (rs.next()) {
                                this.processQueryForListRecord(rs, result, requiredType);
                            }
                            arrayList = result;
                            if (rs == null) break block18;
                            rs.close();
                        }
                        if (stmt == null) break block19;
                        stmt.close();
                    }
                    return arrayList;
                    {
                        catch (Throwable throwable2) {
                            try {
                                if (rs != null) {
                                    rs.close();
                                }
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                if (throwable == null) {
                                    throwable = throwable3;
                                } else if (throwable != throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                if (stmt != null) {
                                    stmt.close();
                                }
                                throw throwable;
                            }
                        }
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                throw new PersistenceException(e.getMessage(), e);
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     */
    private <R> void processQueryForListRecord(ResultSet resultSet, List<R> results, Class<R> requiredType) throws SQLException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object obj = resultSet.getObject(1);
        if (obj == null) {
            results.add(null);
            return;
        }
        if (resultSet.getObject(1).getClass().equals(requiredType)) {
            results.add(resultSet.getObject(1, requiredType));
            return;
        }
        this.log.debug("Retrieved object {} differs from attended {}", (Object)obj.getClass(), (Object)requiredType);
        if (obj instanceof Timestamp) {
            Timestamp ts = (Timestamp)obj;
            if (requiredType.equals(Date.class)) {
                results.add(requiredType.getConstructor(Long.TYPE).newInstance(ts.getTime()));
                return;
            }
        }
        results.add(resultSet.getObject(1, requiredType));
    }

    @Override
    public void queryForResultSet(String sql, Map<String, Object> parameters, Integer maxRows, ResultSetWalker walker) throws PersistenceException {
        this.getCurrentSession().doWork(connection -> {
            try {
                Throwable throwable = null;
                Object var7_9 = null;
                try {
                    NamedParameterStatement stmt = new NamedParameterStatement(connection, sql, parameters, maxRows);
                    try {
                        try (ResultSet rs = stmt.executeQuery();){
                            this.logStatement(sql, connection);
                            walker.walk(rs);
                        }
                        if (stmt == null) return;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (stmt == null) throw throwable;
                        stmt.close();
                        throw throwable;
                    }
                    stmt.close();
                    return;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    } else {
                        if (throwable == throwable3) throw throwable;
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                this.log.error(e.getMessage(), e);
                if (!(e instanceof PersistenceException)) throw new PersistenceException(e.getMessage(), e);
                PersistenceException pe = (PersistenceException)e;
                throw pe;
            }
        });
    }

    @Override
    public int queryForInt(String sql) throws PersistenceException {
        return (int)this.queryForLong(sql);
    }

    @Override
    public int queryForInt(String sql, Map<String, Object> parameters) throws PersistenceException {
        return (int)this.queryForLong(sql, parameters);
    }

    @Override
    public long queryForLong(String sql) throws PersistenceException {
        return this.queryForLong(sql, null);
    }

    @Override
    public long queryForLong(String sql, Map<String, Object> parameters) throws PersistenceException {
        try {
            Long ret = this.queryForObject(sql, parameters, Long.class);
            return ret != null ? ret : 0L;
        }
        catch (Exception e) {
            return this.queryForLongFromIntegerOrBigDecimal(sql, parameters);
        }
    }

    private long queryForLongFromIntegerOrBigDecimal(String sql, Map<String, Object> parameters) throws PersistenceException {
        try {
            Integer ret = this.queryForObject(sql, parameters, Integer.class);
            return ret != null ? ret.longValue() : 0L;
        }
        catch (Exception ex) {
            BigDecimal ret = this.queryForObject(sql, parameters, BigDecimal.class);
            return ret != null ? ret.longValue() : 0L;
        }
    }

    @Override
    public double queryForDouble(String sql) throws PersistenceException {
        return this.queryForDouble(sql, null);
    }

    @Override
    public double queryForDouble(String sql, Map<String, Object> parameters) throws PersistenceException {
        Double ret = this.queryForObject(sql, parameters, Double.class);
        return ret != null ? ret : 0.0;
    }

    @Override
    public String queryForString(String sql) throws PersistenceException {
        return this.queryForObject(sql, String.class);
    }

    @Override
    public String queryForString(String sql, Map<String, Object> parameters) throws PersistenceException {
        return this.queryForObject(sql, parameters, String.class);
    }

    @Override
    public <R> R queryForObject(String sql, Class<R> requiredType) throws PersistenceException {
        return this.queryForObject(sql, null, requiredType);
    }

    @Override
    public <R> R queryForObject(String sql, Map<String, Object> parameters, Class<R> requiredType) throws PersistenceException {
        return (R)this.getCurrentSession().doReturningWork(connection -> {
            try {
                Throwable throwable = null;
                Object var6_8 = null;
                try {
                    ResultSet rs;
                    NamedParameterStatement stmt;
                    block15: {
                        Object t;
                        block16: {
                            stmt = new NamedParameterStatement(connection, sql, parameters);
                            rs = stmt.executeQuery();
                            this.logStatement(sql, connection);
                            if (!rs.next()) break block15;
                            t = rs.getObject(1, requiredType);
                            if (rs == null) break block16;
                            rs.close();
                        }
                        if (stmt == null) return t;
                        stmt.close();
                        return t;
                    }
                    if (rs != null) {
                        rs.close();
                    }
                    if (stmt == null) return null;
                    {
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            if (stmt == null) throw throwable;
                            stmt.close();
                            throw throwable;
                        }
                    }
                    {
                        stmt.close();
                        return null;
                        catch (Throwable throwable3) {
                            if (rs == null) throw throwable3;
                            rs.close();
                            throw throwable3;
                        }
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                        throw throwable;
                    }
                    if (throwable == throwable4) throw throwable;
                    throwable.addSuppressed(throwable4);
                    throw throwable;
                }
            }
            catch (Exception e) {
                throw new PersistenceException(e.getMessage(), e);
            }
        });
    }

    @Override
    public int jdbcUpdate(String sql, Map<String, Object> parameters) throws PersistenceException {
        if (!this.checkStoringAspect()) {
            return 0;
        }
        return (Integer)this.getCurrentSession().doReturningWork(connection -> {
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (NamedParameterStatement stmt = new NamedParameterStatement(connection, sql, parameters);){
                    this.logStatement(sql, connection);
                    return stmt.executeUpdate();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                throw new PersistenceException(e.getMessage(), e);
            }
        });
    }

    @Override
    public int jdbcUpdate(String sql) throws PersistenceException {
        return this.jdbcUpdate(sql, null);
    }

    @Override
    public void deleteAll(Collection<T> entities, int code) throws PersistenceException {
        if (!this.checkStoringAspect()) {
            return;
        }
        if (entities == null || entities.isEmpty()) {
            return;
        }
        try {
            StringBuilder ids = new StringBuilder();
            for (PersistentObject t : entities) {
                if (ids.length() > 0) {
                    ids.append(",");
                }
                ids.append(Long.toString(t.getId()));
            }
            this.prepareQuery(UPDATE + this.entityClass.getCanonicalName() + " set deleted=" + code + " where id in(" + ids.toString() + ")", null, this.entityClass, null).executeUpdate();
        }
        catch (Exception e) {
            throw new PersistenceException(e);
        }
    }

    @Override
    public void deleteAll(Collection<T> entities) throws PersistenceException {
        this.deleteAll(entities, 1);
    }

    @Override
    public int bulkUpdate(String expression, Map<String, Object> parameters) throws PersistenceException {
        if (!this.checkStoringAspect()) {
            return 0;
        }
        try {
            MutationQuery mutationQuery = this.getCurrentSession().createMutationQuery(UPDATE + this.entityClass.getCanonicalName() + " " + expression);
            this.applyParameters(parameters, mutationQuery);
            return mutationQuery.executeUpdate();
        }
        catch (Exception e) {
            throw new PersistenceException(e);
        }
    }

    @Override
    public void evict(Class<? extends PersistentObject> obj, long id) {
        this.evict(this.getCurrentSession().get(obj, (Object)id));
        this.sessionFactory.getCache().evict(obj, (Object)id);
    }

    @Override
    public void evict(long id) {
        this.evict(this.entityClass, id);
    }

    protected void evict(Object entity) {
        if (entity == null) {
            return;
        }
        this.getCurrentSession().evict(entity);
    }

    protected Connection getConnection() throws PersistenceException {
        DataSource dataSource = (DataSource)Context.get(DATA_SOURCE);
        try {
            return dataSource.getConnection();
        }
        catch (Exception e) {
            throw new PersistenceException(e.getMessage(), e);
        }
    }

    @Override
    public String getDbms() {
        ContextProperties config = Context.get().getProperties();
        return config.getProperty("jdbc.dbms", "mysql").toLowerCase();
    }

    @Override
    public boolean isOracle() {
        return "oracle".equals(this.getDbms());
    }

    protected boolean isHsql() {
        return "hsqldb".equals(this.getDbms());
    }

    @Override
    public boolean isMySQL() {
        return "mysql".equals(this.getDbms()) || this.isMariaDB();
    }

    protected boolean isMariaDB() {
        return "maria".equals(this.getDbms());
    }

    protected boolean isPostgreSQL() {
        return "postgresql".equals(this.getDbms());
    }

    protected boolean isSqlServer() {
        return "mssql".equals(this.getDbms());
    }

    protected int cleanOldRecords(int ttl, String tableName, String dateColumn) throws PersistenceException {
        int updates = 0;
        if (ttl > 0) {
            Date today = new Date();
            GregorianCalendar cal = new GregorianCalendar();
            cal.add(5, -ttl);
            Date ldDate = cal.getTime();
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("today", today);
            params.put("ldDate", ldDate);
            updates = this.jdbcUpdate("UPDATE " + tableName + " SET ld_deleted = 1, ld_lastmodified = :today WHERE ld_deleted = 0 AND " + dateColumn + " < :ldDate", params);
            this.log.info("Removed {} old rows from table {}", (Object)updates, (Object)tableName);
        }
        return updates;
    }

    protected int cleanOldRecords(int ttl, String tableName) throws PersistenceException {
        return this.cleanOldRecords(ttl, tableName, "ld_date");
    }

    @Override
    public Map<String, String> getDatabaseMetadata() {
        HashMap<String, String> map = new HashMap<String, String>();
        DataSource dataSource = (DataSource)Context.get(DATA_SOURCE);
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Connection connection = dataSource.getConnection();){
                DatabaseMetaData meta = connection.getMetaData();
                map.put("db.product.name", meta.getDatabaseProductName());
                map.put("db.product.version", meta.getDatabaseProductVersion());
                map.put("db.minorversion", Integer.toString(meta.getDatabaseMinorVersion()));
                map.put("db.majorversion", Integer.toString(meta.getDatabaseMajorVersion()));
                map.put("db.driver.name", meta.getDriverName());
                map.put("db.driver.version", meta.getDriverVersion());
                map.put("db.driver.minorversion", Integer.toString(meta.getDriverMinorVersion()));
                map.put("db.driver.majorversion", Integer.toString(meta.getDriverMajorVersion()));
                map.put("db.jdbc.majorversion", Integer.toString(meta.getJDBCMajorVersion()));
                map.put("db.jdbc.minorversion", Integer.toString(meta.getJDBCMinorVersion()));
                map.put("db.catalog.term", meta.getCatalogTerm());
                map.put("db.catalog.separator", meta.getCatalogSeparator());
                map.put("db.schema.term", meta.getSchemaTerm());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            this.log.error(e.getMessage(), e);
        }
        return map;
    }

    private void logStatement(String sql, Connection connection) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Run statement {} in connection {}", (Object)sql, (Object)connection);
        }
    }
}

