/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core;

import com.logicaldoc.core.RunLevel;
import com.logicaldoc.core.dashlet.DashletContent;
import com.logicaldoc.core.util.IconSelector;
import com.logicaldoc.util.config.ContextProperties;
import com.logicaldoc.util.plugin.LogicalDOCPlugin;
import com.logicaldoc.util.plugin.PluginException;
import java.io.File;
import java.io.IOException;
import java.util.UUID;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CorePlugin
extends LogicalDOCPlugin {
    protected static final String DEFAULT = "default";
    private static final Logger log = LoggerFactory.getLogger(CorePlugin.class);

    @Override
    protected void onStart() throws PluginException {
        try {
            ContextProperties pbean = new ContextProperties();
            if (StringUtils.isEmpty(pbean.getProperty("id"))) {
                pbean.setProperty("id", UUID.randomUUID().toString());
                pbean.write();
            }
        }
        catch (IOException e) {
            log.error(e.getMessage(), e);
        }
        File dest = new File(this.getPluginPath());
        dest = dest.getParentFile().getParentFile().getParentFile();
        File[] icons = (dest = new File(dest.getAbsolutePath() + "/frontend/sc/skins/Tahoe/images/FileIcons")).listFiles((dir, name) -> name.endsWith(".svg"));
        if (icons != null) {
            File[] fileArray = icons;
            int n = icons.length;
            int n2 = 0;
            while (n2 < n) {
                File icon = fileArray[n2];
                IconSelector.getAvailableIcons().add(FilenameUtils.getBaseName(icon.getName().toLowerCase()));
                ++n2;
            }
        }
    }

    @Override
    public void install() throws PluginException {
        try {
            ContextProperties pbean = new ContextProperties();
            for (String aspect : RunLevel.getAspects()) {
                RunLevel[] runLevelArray = RunLevel.values();
                int n = runLevelArray.length;
                int n2 = 0;
                while (n2 < n) {
                    RunLevel level = runLevelArray[n2];
                    pbean.setProperty("aspect." + aspect + "." + level.toString(), "true");
                    ++n2;
                }
            }
            pbean.setProperty("threadpool.Email.type", DEFAULT);
            pbean.setProperty("threadpool.EventCollector.max", "20");
            pbean.setProperty("threadpool.EventCollector.type", DEFAULT);
            pbean.setProperty("threadpool.IndexerTask.max", "2");
            pbean.setProperty("threadpool.IndexerTask.type", DEFAULT);
            pbean.write();
        }
        catch (IOException e) {
            log.error(e.getMessage(), e);
        }
        try {
            this.addServlet("DashletContent", DashletContent.class, "/data/dashletcontent");
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
        }
        this.setRestartRequired();
    }
}

