/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.core;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.document.Document;
import com.logicaldoc.core.document.DocumentDAO;
import com.logicaldoc.core.document.DocumentHistory;
import com.logicaldoc.core.document.DocumentManager;
import com.logicaldoc.core.folder.Folder;
import com.logicaldoc.core.folder.FolderDAO;
import com.logicaldoc.core.folder.FolderHistory;
import com.logicaldoc.core.security.TenantDAO;
import com.logicaldoc.util.config.ContextProperties;
import com.logicaldoc.util.io.FileUtil;
import com.logicaldoc.util.io.ResourceUtil;
import jakarta.annotation.Resource;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;

public abstract class ContextInitializer
implements ApplicationListener<ContextRefreshedEvent> {
    private static final Logger log = LoggerFactory.getLogger(ContextInitializer.class);
    @Resource(name="ContextProperties")
    protected ContextProperties config;
    @Resource(name="documentManager")
    protected DocumentManager documentManager;
    @Resource(name="documentDAO")
    protected DocumentDAO documentDAO;
    @Resource(name="folderDAO")
    protected FolderDAO folderDAO;
    @Resource(name="tenantDAO")
    protected TenantDAO tenantDAO;

    protected abstract void initialize(long var1) throws IOException, SQLException;

    public final void onApplicationEvent(ContextRefreshedEvent event) {
        if (!this.isDbInitialized()) {
            return;
        }
        try {
            for (Long tenantId : this.tenantDAO.findAllIds()) {
                this.initialize(tenantId);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
        }
    }

    private boolean isDbInitialized() {
        try {
            return this.documentDAO.queryForLong("select count(*) from ld_user") > 0L;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected Folder prepareFolder(String path, FolderHistory transaction) throws PersistenceException {
        Folder root = this.folderDAO.findRoot(transaction.getTenantId());
        root = this.folderDAO.createPath(root, path, false, transaction);
        return root;
    }

    protected Document prepareDocument(String resourcePath, String documentPath, DocumentHistory transaction) throws PersistenceException, InterruptedException, ExecutionException, IOException {
        FolderHistory fHist = new FolderHistory();
        BeanUtils.copyProperties((Object)transaction, (Object)fHist, (String[])new String[]{"event"});
        fHist.setId(0L);
        fHist.setTenantId(transaction.getTenantId());
        Folder target = this.prepareFolder(FileUtil.getPath(documentPath), fHist);
        String fileName = FileUtil.getName(documentPath);
        Document doc = this.documentDAO.findByFileNameAndParentFolderId(target.getId(), fileName, null, transaction.getTenantId(), null).stream().findFirst().orElse(null);
        if (doc == null) {
            Throwable throwable = null;
            Object var9_10 = null;
            try (InputStream is = ResourceUtil.getInputStream(resourcePath);){
                Document trainingDoc = new Document();
                trainingDoc.setTenantId(transaction.getTenantId());
                trainingDoc.setFileName(fileName);
                trainingDoc.setFolder(target);
                trainingDoc.setLanguage("en");
                doc = (Document)this.documentManager.create(is, trainingDoc, transaction).get();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return doc;
    }
}

