/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.userinput.console;

import com.izforge.izpack.api.handler.Prompt;
import com.izforge.izpack.panels.userinput.console.ConsoleField;
import com.izforge.izpack.panels.userinput.field.Choice;
import com.izforge.izpack.panels.userinput.field.ChoiceField;
import com.izforge.izpack.util.Console;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class ConsoleChoiceField<T extends Choice>
extends ConsoleField {
    public ConsoleChoiceField(ChoiceField field, Console console, Prompt prompt) {
        super(field, console, prompt);
    }

    @Override
    public ChoiceField getField() {
        return (ChoiceField)super.getField();
    }

    @Override
    public boolean display() {
        ChoiceField field = this.getField();
        this.printDescription();
        this.printLabel();
        List<Choice> choices = field.getChoices();
        int selectedRealIndex = field.getSelectedIndex();
        MappedSelection visibleToRealMapping = this.listChoices(choices, selectedRealIndex);
        if (this.isReadonly()) {
            field.setValue(choices.get(field.getSelectedIndex() == -1 ? 0 : field.getSelectedIndex()).getKey());
            return true;
        }
        int selectedVisibleIndex = this.getConsole().prompt(this.getMessage("ConsoleInstaller.inputSelection"), 0, visibleToRealMapping.size() - 1, visibleToRealMapping.getDefaultVisibleIndex(), -1);
        if (selectedVisibleIndex == -1) {
            return false;
        }
        field.setValue(choices.get(visibleToRealMapping.getRealFromVisible(selectedVisibleIndex)).getKey());
        return true;
    }

    private MappedSelection listChoices(List<Choice> choices, int selectedRealIndex) {
        int visibleIndex = 0;
        MappedSelection visibleToRealMapping = new MappedSelection();
        for (int i = 0; i < choices.size(); ++i) {
            Choice choice = choices.get(i);
            String conditionId = choice.getConditionId();
            if (conditionId != null && !this.getField().getInstallData().getRules().isConditionTrue(conditionId)) continue;
            boolean isSelected = i == selectedRealIndex;
            this.println(visibleIndex + "  [" + (isSelected ? "x" : " ") + "] " + choice.getValue());
            visibleToRealMapping.put(visibleIndex, i);
            if (isSelected) {
                visibleToRealMapping.setDefaultVisibleIndex(visibleIndex);
            }
            ++visibleIndex;
        }
        return visibleToRealMapping;
    }

    private static class MappedSelection {
        private Map<Integer, Integer> visibleToRealIndexes = new HashMap<Integer, Integer>();
        private int defaultVisibleIndex = -1;

        private MappedSelection() {
        }

        public Integer put(Integer visibleIndex, Integer realIndex) {
            return this.visibleToRealIndexes.put(visibleIndex, realIndex);
        }

        public int size() {
            return this.visibleToRealIndexes.size();
        }

        public Integer getRealFromVisible(int visibleIndex) {
            return this.visibleToRealIndexes.get(visibleIndex);
        }

        public void setDefaultVisibleIndex(int defaultVisibleIndex) {
            this.defaultVisibleIndex = defaultVisibleIndex;
        }

        public int getDefaultVisibleIndex() {
            return this.defaultVisibleIndex;
        }
    }
}

