$(document).ready(function() {
	var restart, countEnabled;
	$.ajaxSetup ({  
	    cache: false  
	}); 

	(function worker() {
		if(restart)
			return;

		$.getJSON("rest?method=control&what=status", function (data) {
			updateState(data.response);
	    })
	    .done(function() {
	    	  setTimeout(worker, 5000);
	    });
	 })();
	
	$('body').on('click', 'a#stop', function(event) {
		callService("stop", "This will shut down logFaces engine\nJVM process and web interface will remain operational.\n\nProceed?");
	});

	$('body').on('click', 'a#start', function(event) {
		callService("start");
	});
	
	$('body').on('click', 'a#restart', function(event) {
		restart = true;
		restartServer();
	});

	$('a#drop').on('click', null, function(event) {
		callService("drop", "This will drop logFaces database and create new schema.\nAll collected data will be erased.\n\nProceed?");
	});

	$('a#dbmaintnow').on('click', null, function(event) {
		callService("maint", "This will start database maintenance procedure.\nIt could be time and resource consuming operation.\n\nProceed?");
	});
	
	$('body').on('click', 'a#resetLastErrors', function(event) {
		callService("resetErrors", "Reset last errors?");
	});

	$('body').on('click', "a#recount", function(event) {
		callService("count", !countEnabled ? "Re-counting database records could be an intense operation. Please confirm." : null);
	});

	$('a#resetStats').on('click', null, function(event) {
		callService("resetStats");
	});

	$('a#getlog').on('click', null, function(event) {
		callService("getlog");
	});
	
	$('a#getstack').on('click', null, function(event) {
		callService("getstack");
	});
	
	$('body').on('click', "a#loglevel", function(event) {
		callService("loglevel");
	});

	$('a#gc').on('click', null, function(event) {
		callService("gc");
	});

	$('a#checkversion').on('click', null, function(event) {
		callService("version");
	});

	$('a#serverdump').on('click', null, function(event) {
		$("#dumpDialog").dialog("open");
	});
	
	$('a#purgeOverflow').on('click', null, function(event) {
		callService("purgeOverflow", "This will purge overflow cache and release allocated disk space.\nIf there are cached logs they will be lost.\n\nProceed?");
	});
	
	function callService(what, question){
		if(question != null && !confirm(question))
			return;
		showProgress("Operation is in progress...");
		$.get("rest?method=control&what="+what, function(data, textStatus, xhr) {
			if(data.link != null){
				doneProgress("<a href='" + data.link + "' target='new'>click here to download</a>", true);
				return;
			}
			closeProgress();
			if(data.version != null){
				displayVersionInfo(data.version);
				return;
			}
			
			updateState(data.response);
		}, "json")
		.fail(function(xhr){
			json = jQuery.parseJSON(xhr.responseText);
			doneProgress(json != null ? json.error: "Server call failed", false);
		})
	}
	
	function updateState(json){
	   $('#heap').html("max: " + json.maxMemory + ", total:" + json.totalMemory + ", free: " + json.freeMemory);
	   $('#threads').html(json.nofThreads);
		
	   if(json.status == 'running'){
		   $('#inflowCount').closest("tr").show();
		   $('#inflowRate').closest("tr").show();
		   $('#connections').closest("tr").show();
		   
		   $('#uptime').html("<font color='green'>running  (uptime " + json.uptime + ")</font>");
		   $('#engine').empty();
		   $('#engine').html("<a id='stop' href='#'><img src='images/stop.gif' title='Stop logFaces engine'/>stop</a>&nbsp;&nbsp;<a id='restart' href='#'><img src='images/restart.gif' title='Restart logFaces JVM'/>restart</a>");
		   $('#inflowCount').html("received: " + json.totalRx + ", committed: " + json.dbTotalCommit);
		   $('#inflowRate').html("last: " + json.loadAct + ", average: " + json.loadAvg + ", maximum: " + json.loadMax);
		   $('#overflowBuffer').html(json.overflowBuffer);
		   $('#connections').html("users: " + json.nofClients + ", apps: " + json.nofAppenders);
		   $('#resetStats').show();
	   }
	   else{
		   $('#inflowCount').closest("tr").hide();
		   $('#inflowRate').closest("tr").hide();
		   $('#connections').closest("tr").hide();
		   $('#resetStats').hide();
		   $('#engine').empty();
		   
		   if(json.status == 'idle'){
			   $('#uptime').html("<font color='red'>idle</font>");
			   $('#engine').html("<a id='start' href='#'><img src='images/run.gif' title='Start logFaces engine'/>start engine</a>");
		   }
		   else if(json.status == 'starting'){
			   $('#uptime').html("<font color='red'>initializing, please wait</font>");
		   }
		   else if(json.status == 'stopping'){
			   $('#uptime').html("<font color='red'>terminating, please wait</font>");
		   }
	   }
	   
	   if(json.verbose)
		   $('#verbose').html("Verbose (<a id='loglevel' href='#'>silence to quiet</a>)");
	   else
		   $('#verbose').html("Quiet (<a id='loglevel' href='#'>enable verbose</a>)");
	   
	   if(json.nofLastErrors > 0){
		   $('#nofLastErrors').html("<span class='blinkerror'>" + json.nofLastErrors + "</span>");
		   $('#clearErrors').html("<a href='/showLastErrors'>show</a>,  <a id='resetLastErrors' href='#'>reset</a>");
	   }
	   else{
		   $('#nofLastErrors').html("none");
		   $('#clearErrors').empty();
	   }
	   
	   if(json.databaseOK){
		   countEnabled = json.countEnabled; 
		   $('#dbthroughput').closest("tr").show();
		   $('#dbcon').html("<font color='green'>yes</font>");
		   $('#dbthroughput').html("last: " + json.dbThroughputAct + ", average: " + json.dbThroughputAvg);
		   if(json.overloadAlarm)
			   $('#dbthroughput').append(", overload: <font color='red'>" + json.overload + "%" + "</font>");
		   else
			   $('#dbthroughput').append(", overload: <font color='green'>" + json.overload + "%" +"</font>");
		   if(json.overflowHit > 0){
			   $('#dbthroughput').append(", <img src='images/flag.png'/><font color='red'>" + json.overflowHit + "</font>");
		   }
		   
		   $('#dbcount').closest("tr").show();
		   $('#dbcount').html(json.dbCount + " <a id='recount' href='#'>(update)</a>");
		   $('#dbsize').closest("tr").show();
		   $('#dbsize').html(json.dbSize);
		   $('#dbmaint').closest("tr").show();
		   $('#dbmaint').html(json.dbMaint);
		   if(json.dbMaintRelevant)
			   $('#dbmaintnow').closest("tr").show();
		   else
			   $('#dbmaintnow').closest("tr").hide();
	   }
	   else{
		   $('#dbcon').html("<font color='red'>no</font>");
		   $('#dbcount').closest("tr").hide();
		   $('#dbsize').closest("tr").hide();
		   $('#dbthroughput').closest("tr").hide();
		   $('#dbmaint').closest("tr").hide();
	   }
	}
	
	function displayVersionInfo(info){
		var content = "Your server is up to date.";
		
		if(info.error){
			content = "<p>" + 
				      "Unable to check updates, error:" +
		              "<div style='color: red;'>" + info.error + "</div></p>" +
	                  "<br>Please contact <a target='new' href='https://moonlits.atlassian.net/servicedesk/customer/portals'>support desk</a> for the details.";
		}
		else if(info.available && !info.expired){
			content = "<p>" +
		              "New update <b>" + info.revision + "</b> is available for installation, size " + info.size + ".<br>" + 
		              "It is highly recommended to keep your server up to date.<br>" +
		              "Please read <a href="+ info.notesUrl +" target='new'>the release notes</a> before installation.<br><br>" +
		              "<a href='/install'>Click here to begin installation now</a>" +
		              "</p>";
		}
		else if(info.available && info.expired){
			content = "<p>" +
            "Newer update " + info.revision + " is available for installation, size " + info.size + ".<br>" + 
            "It is highly recommended to keep your server up to date.<br>" +
	        "<b><font color='red'>Annual maintenance plan for this license is expired on " + info.maintDate + "</font></b><br>"+
	        "Please <a target='new' href='https://moonlits.atlassian.net/servicedesk/customer/portals'>contact us</a> to extend your annual maintenance plan."+
            "</p>";
		}
		
	    $("#helpDialog ").dialog( "option", "height", "300");
	    $("#helpDialog ").dialog( "option", "width", "550");
	    $("#helpDialog .formNote").html(content);
	    $("#helpDialog").dialog( "option", "title", "Version update");
		$("#helpDialog" ).dialog( "open" );
	}
	
	$("#dumpDialog" ).dialog({
		autoOpen: false,
		height: 250,
		width: 500,
		modal: true,
		title: "Server dump",
		buttons: {
			"Generate server dump": function() {
				$(this).dialog().dialog( "close" );
				showProgress("Generatig server dump");
				var formData = $("#dumpForm").serialize();
				$.post("rest?method=control&what=serverdump", formData, function(data, textStatus, xhr) {
					doneProgress("Server dump is generated successfully<br><a href='" + data.link + "' target='new'>click here to download</a>", true);
				}, "json")
				.fail(function(xhr) { 
					json = jQuery.parseJSON(xhr.responseText);
					doneProgress(json.error, false); 
				})
			},
			Cancel: function() {
				$(this).dialog().dialog( "close" );
			}
		},
		close: function() {
		}
	});	
});
