$(document).ready(function() {
	var pid;
	var ptable = $('#pluginsTable').dataTable({
		"bJQueryUI": true,
		"bPaginate": false,
		"bFilter": false,
		"bLengthChange": false,
		"sScrollY": '220px',
		"bStateSave": false,
		'bAutoWidth': false,
		"aaSorting": [],
		"oLanguage": {
			"sEmptyTable": "<p align='center'>There are no plugins<br></p>"
		},
		"aoColumns": [
			{"sClass": "text-left", "sWidth": "20px", "bSortable": false},
			{"sClass": "text-left", "bSortable": false},
			{"sClass": "text-left", "bSortable": false},
			{"sClass": "text-left", "sWidth": "120px", "bSortable": false}
			]		
	});

	var vtable = $('#pivotTable').dataTable({
		"bJQueryUI": true,
		"bPaginate": false,
		"bFilter": false,
		"bLengthChange": false,
		"sScrollY": '220px',
		"bStateSave": false,
		'bAutoWidth': false,
		"aaSorting": [],
		"oLanguage": {
			"sEmptyTable": "<p align='center'>There are no nodes in this pivot chain<br></p>"
		},
		"aoColumns": [
			{"sClass": "text-left", "sWidth": "20px", "bSortable": false},
			{"sClass": "text-left", "bSortable": false},
			{"sClass": "text-left", "sWidth": "120px", "bSortable": false}
			]		
	});

	$("#tabs").tabs();
	$("#tabs").tabs({
		activate: function( event, ui ) {
			if(ui.newTab.index() == 4)
				ptable.fnAdjustColumnSizing();
			if(ui.newTab.index() == 5)
				vtable.fnAdjustColumnSizing();
		}
	});
	$("#tabs").tabs("option", "active", $("#subtab").val());	
	
	$("a#addMdc").on("click", null, function(){
		var mapping = prompt("Enter the MDC property name, or names separated by coma", "");
		if(mapping == null)
			return;
		$.post("rest?method=addMdc&mdc=" + mapping, null, function(data, textStatus, xhr) {
			window.location.href = "/contextTab?subtab=0";
		}, "json")
		.fail(function(xhr){
			alert(jQuery.parseJSON(xhr.responseText).error);
		})
	});

	$("a.removeMdc").on("click", null, function(){
		var mdc = $(event.target).parent().data("mdc");
		if(!confirm("Remove '" + name +"' from the MDC mapping?"))
			return false;
		
		$.post("rest?method=removeMdc&mdc=" + mdc, null, function(data, textStatus, xhr) {
			window.location.href = "/contextTab?subtab=0";
		}, "json")
		.fail(function(xhr){
			alert(jQuery.parseJSON(xhr.responseText).error);
		})
	});

	$('#mdcForm').on("submit", function(){
		showProgress("Updating context variables");
		var formData = $('#mdcForm').serialize();
		$.post("rest?method=updateMdc", formData, function(data, textStatus, xhr) {
			doneProgress(data.response, true);
		}, "json")
		.fail(function(xhr){
			doneProgress(jQuery.parseJSON(xhr.responseText).error, false);
		})

		return false;
	});

	$('#repoForm').on("submit", function(){
		showProgress("Updating repository settings");
		var formData = $('#repoForm').serialize();
		$.post("rest?method=updateRepo", formData, function(data, textStatus, xhr) {
			doneProgress(data.response, true);
		}, "json")
		.fail(function(xhr){
			doneProgress(jQuery.parseJSON(xhr.responseText).error, false);
		})

		return false;
	});

	$('#hostsForm').on("submit", function(){
		showProgress("Updating host names, please stand by");
		var formData = $('#hostsForm').serialize();
		$.post("rest?method=updateHosts", formData, function(data, textStatus, xhr) {
			doneProgress(data.response, true);
		}, "json")
		.fail(function(xhr){
			doneProgress(jQuery.parseJSON(xhr.responseText).error, false);
		})

		return false;
	});

	$("a.removeLevel").on("click", null, function(){
		if(!confirm("Remove this level?"))
			return false;

		showProgress("Updating levels, please stand by");
		var level = $(event.target).parent().data("level");
		$.post("rest?method=removeLevel&value="+level, null, function(data, textStatus, xhr) {
			window.location.href = "/contextTab?subtab=2";
		}, "json")
		.fail(function(xhr){
			doneProgress(jQuery.parseJSON(xhr.responseText).error, false);
		})

		return false;
	});

	$("a.editLevel").on("click", null, function(){
		var name = $(event.target).data("name");
		var level = $(event.target).data("level");
		$("#levelDialog #levelForm #name").val(name);
		$("#levelDialog #levelForm #value").val(level);
		$("#levelDialog").dialog("option", "title", "Modify level");
		$("#levelDialog").dialog("open");
	});

	$("a.addLevel").on("click", null, function(){
		$("#levelDialog #levelForm #name").val("CUSTOM");
		$("#levelDialog #levelForm #value").val(5001);
		$("#levelDialog").dialog("option", "title", "New level");
		$("#levelDialog").dialog("open");
	});

	$("#levelDialog").dialog({
		autoOpen: false,
		height: 300,
		width: 600,
		modal: true,
		buttons: {
			"Save": function() {
				var formData = $("#levelForm").serialize();
				$.post("rest?method=updateLevel", formData, function(data, textStatus, xhr) {
					$("#levelDialog").dialog("close");
					window.location.href = "/contextTab?subtab=2";
				}, "json")
				.fail(function(xhr){
					$("#progress").dialog("close");
					json = jQuery.parseJSON(xhr.responseText);
					alert(json.error); 
				})
			},
			"Cancel": function() {
				$(this).dialog( "close" );
			}
		},
		close: function() {
		}
	});   

	$("a.addPlugin").on("click", null, function(){
		$("#pluginFiles").trigger('click');
		return false;
	});

	$("input#pluginFiles").on('change', function() {
		var files = $("#pluginFiles").prop("files");
		if(!files || files.length == 0)
			return;

		var formData = new FormData();
		for(var i=0; i<files.length; i++)
			formData.append(files[i].name, files[i]);

		showProgress("Adding plugin, please stand by...");
		$.ajax({
			url : "rest?method=addPlugin",
			type: "POST",
			data : formData,
			processData: false,
			contentType: false,
			success:function(data, textStatus, jqXHR){
				window.location.href = "/contextTab?subtab=4";
			},
			error: function(jqXHR, textStatus, errorThrown){
				doneProgress(jQuery.parseJSON(jqXHR.responseText).error, false);
			}
		});
	});

	$("a.removePlugin").on("click", null, function(){
		var message = isPliginUsed($(this)) ? "This plugin is used internally by this server instance,\nremoving it will affect server functionality.\n\nAre you sure you want to remove this plugin?" : "Are you sure you want to remove this plugin?";
		if(!confirm(message))
			return false;

		getPID($(this));
		showProgress("Removing plugin, please stand by...");
		$.post("rest?method=removePlugin&pid="+pid, null, function(data, textStatus, xhr) {
			window.location.href = "/contextTab?subtab=4";
		}, "json")
		.fail(function(xhr){
			doneProgress(jQuery.parseJSON(xhr.responseText).error, false);
		})

		return false;
	});

	$("a.editPlugin").on("click", null, function(){
		if(!confirm("Upload new files for this plugin?"))
			return false;
		getPID($(this));
		$("#pluginUpdateFiles").trigger('click');
		return false;
	});

	$("input#pluginUpdateFiles").on('change', function() {
		var files = $("#pluginUpdateFiles").prop("files");
		if(!files || files.length == 0)
			return;

		var formData = new FormData();
		for(var i=0; i<files.length; i++)
			formData.append(files[i].name, files[i]);

		showProgress("Updating plugin, please stand by...");
		$.ajax({
			url : "rest?method=updatePlugin&pid="+pid,
			type: "POST",
			data : formData,
			processData: false,
			contentType: false,
			success:function(data, textStatus, jqXHR){
				window.location.href = "/contextTab?subtab=4";
			},
			error: function(jqXHR, textStatus, errorThrown){
				doneProgress(jQuery.parseJSON(jqXHR.responseText).error, false);
			}
		});
	});

	$("a.testPlugin").on("click", null, function(event){
		getPID($(this));
		$.get("rest?method=getPluginArgs&pid="+pid, function(data, textStatus, xhr) {
			var table = $("#testPluginTable");
			table.empty();
			table = $("<tbody/>").appendTo(table);
			$("#testPluginForm #note").html(data.response.length > 0 ? "" : "<br><br>no arguments");
			if(data.response.length){
				for(var i=0; i<data.response.length; i++){
					var row = $("<tr>").appendTo(table);
					$("<td>" + data.response[i] + "</td>").appendTo(row);
					$("<td><input type='text' autocomplete='on' id='" +data.response[i]+ "' name='" +data.response[i]+ "' style='width: 100%'></td>").appendTo(row);
				}
			}

			$("#testPluginDialog").dialog("option", "title", $(event.target).closest("tr").find(".pname").html());
			$("#testPluginDialog").dialog( "open" );


		}, "json")
		.fail(function(xhr){
			var response = jQuery.parseJSON(xhr.responseText);
			alert(response.error); 
		})

		return false;
	});

	$("#testPluginDialog").dialog({
		autoOpen: false,
		height: 300,
		width: 400,
		modal: true,
		buttons: {
			"Test": function() {
				var formData = $('#testPluginForm').serialize();
				$(this).dialog( "close" );

				showProgress("Testing plugin, please stand by...");
				$.post("rest?method=testPlugin&pid="+pid, formData, function(data, textStatus, xhr) {
					doneProgress(data.response, true);
				}, "json")
				.fail(function(xhr){
					doneProgress(jQuery.parseJSON(xhr.responseText).error, false);
				})
			},
			"Cancel": function() {
				$(this).dialog( "close" );
			}
		},
		close: function() {
		}
	});   

	$("a.ppAdd").on("click", null, function(){
		$.get("rest?method=listPlugins", function(data, textStatus, xhr) {
			if(data.response.length == 0){
				alert("There are no plugins, the pivot chain consists of existing plugins."); 
				return;
			}
			
			showPluginDialog(data.response);
		}, "json")
		.fail(function(xhr){
			var json = jQuery.parseJSON(xhr.responseText);
			alert(json.error); 
		})

		return false;
	});

	$("a.ppEdit").on("click", null, function(){
		var row = $(this).closest("tr").index();
		if(row == 0){
			window.location.href = "/connectivityTab?subtab=2";
			return;
		}
		if(row == 1){
			window.location.href = "/connectivityTab?subtab=3";
			return;
		}
		
		$.get("rest?method=getPivotNode&node="+row, function(data, textStatus, xhr) {
			var node = data.response;
			$.get("rest?method=listPlugins", function(data, textStatus, xhr) {
				showPluginDialog(data.response, row, node.pid);
			}, "json")
			.fail(function(xhr){
				var json = jQuery.parseJSON(xhr.responseText);
				alert(json.error);
			})
			
		}, "json")
		.fail(function(xhr){
			var json = jQuery.parseJSON(xhr.responseText);
			alert(json.error); 
		})
		
		return false;
	});
	
	$("a.ppEnable").on("click", null, function(){
		var row = $(this).closest("tr").index();
		$.post("rest?method=togglePivotNode&node="+row, null, function(data, textStatus, xhr) {
			window.location.href = "/contextTab?subtab=5";
		}, "json")
		.fail(function(xhr){
			var json = jQuery.parseJSON(xhr.responseText);
			alert(json.error); 
		})

		return false;
	});
	
	$("a.ppUp,a.ppDown").on("click", null, function(){
		var row = $(this).closest("tr").index();
		var dir = $(this).hasClass("ppUp") ? "up" : "down";
		$.post("rest?method=movePivotNode&direction="+dir+"&node="+row, null, function(data, textStatus, xhr) {
			window.location.href = "/contextTab?subtab=5";
		}, "json")
		.fail(function(xhr){
			var json = jQuery.parseJSON(xhr.responseText);
			alert(json.error); 
		})

		return false;
	});

	$("a.ppRemove").on("click", null, function(){
		if(!confirm("Remove this plugin from the pivot chain?"))
			return;
		
		var row = $(this).closest("tr").index();
		$.get("rest?method=removePivotNode&node="+row, function(data, textStatus, xhr) {
			window.location.href = "/contextTab?subtab=5";
		}, "json")
		.fail(function(xhr){
			var json = jQuery.parseJSON(xhr.responseText);
			alert(json.error); 
		})

		return false;
	});
	
	function showPluginDialog(plugins, node, pid){
		var table = $("#pluginDialog #pluginForm #options");
		$(table).empty();
		table = $("<tbody/>").appendTo(table);
		var row = $("<tr/>").appendTo(table);
		var td = $("<td>Plugin to invoke</td>").appendTo(row);
		
		td = $("<td/>").appendTo(row);
		var select = $("<select style='width: 100%;' name='plugin'/>").appendTo(td);
		$("<option value='-1'></option>").appendTo(select);
		for(var i=0;i<plugins.length; i++)
			$("<option value=" + plugins[i].id + ">" + plugins[i].name + "</option>").appendTo(select);
		
		select.val(pid);
		select.on('change', function() {
			populatePluginArgs(node, $(this).val());
		});	

		populatePluginArgs(node, pid);
		
		$("#pluginDialog").dialog("option", "title", "Pivot node");
		$("#pluginDialog").dialog("open" );
	}
	
	function populatePluginArgs(node, pid){
		$("#pluginDialog #pluginForm #node").val(node);
		$("#pluginDialog #pluginForm #pid").val(pid);

		var table = $("#pluginDialog #pluginForm #options");
		if(pid == -1){
			table.find("tr:gt(0)").remove();
			//var row = $("<tr/>").appendTo(table);
			//var td = $("<td/>").appendTo(row);
			//$("<input type='hidden' name='node' value='" + node + "' />").appendTo(td);
			//$("<input type='hidden' name='pid' value='" + pid + "' />").appendTo(td);
			return;
		}

		$.get("rest?method=getPivotNode&node="+node+"&pid="+pid, function(data, textStatus, xhr) {
			var args = data.response.args;
			table.find("tr:gt(0)").remove();
			Object.keys(args).forEach(function(arg) {
				var row = $("<tr/>").appendTo(table);
				var td = $("<td/>").appendTo(row);
				td.html(arg);

				td = $("<td/>").appendTo(row);
				var input = $("<input type='text' name='" + "arg." + arg + "' style='width: 100%'/>").appendTo(td);
				input.val(args[arg]);
			});
			
			$("#pluginDialog #pluginForm #node").val(node);
			$("#pluginDialog #pluginForm #pid").val(pid);
			
			//var row = $("<tr/>").appendTo(table);
			//var td = $("<td/>").appendTo(row);
			//$("<input type='hidden' name='node' value='" + node + "' />").appendTo(td);
			//$("<input type='hidden' name='pid' value='" + pid + "' />").appendTo(td);
			
		}, "json")
		.fail(function(xhr){
			json = jQuery.parseJSON(xhr.responseText);
			alert(json.error); 
		})
	}

	$("#pluginDialog").dialog({
		autoOpen: false,
		height: 350,
		width: 650,
		modal: true,
		buttons: {
			"Save": function() {
				var formData = $("#pluginDialog #pluginForm").serialize();
				$.post("rest?method=updatePivotNode", formData, function(data, textStatus, xhr) {
					$("#pluginDialog").dialog("close");
					window.location.href = "/contextTab?subtab=5";
				}, "json")
				.fail(function(xhr){
					json = jQuery.parseJSON(xhr.responseText);
					alert(json.error);
				})
			},
			Cancel: function() {
				$(this).dialog( "close" );
			}
		},
		close: function() {
		}
	});   

	function getPID(el){
		pid = $(el).parent().parent().find(".id").val();
	}
	
	function isPliginUsed(el){
		return $(el).parent().parent().find(".pused").html() === "yes";
	}
	
});