<%@ include file="header.jsp" %>
<%@ page import="java.util.*" %>
<script src="scripts/status.js?v=100720" type="text/javascript"></script>

<%
	Map<?,?> params = (Map<?,?>)request.getAttribute("params");
	boolean virt = (Boolean)params.get("virt");
	boolean maint = (Boolean)params.get("maint");
	boolean dbsize = (Boolean)params.get("dbsize");
	Map<String,String> dbinfo = (Map<String,String>)params.get("dbinfo");
%>

<%@ include file="menu.jsp"%>

<div id="content">		
	<div id="main">
	<table class="listing">
		<tr>
			<td>Server version</td>
			<td><%=params.get("version")%></td>
			<td><%if(!virt){%>
			       <a id='checkversion' href="#" title="check if there are new server updates available online">check for updates</a>
			     <%}%>
			</td>
		</tr>

		<tr>
			<td>Server license</td>
			<td><%=params.get("license")%></td>
			<td><b><a id='serverdump' href="#" title="collect server run time data for support">download server dump</a></b></td>
		</tr>

		<tr>
			<td><%if(virt){%>Guest operating system<%}else{%>Operating system<%}%></td>
			<td><%=params.get("os")%></td>
			<td></td>
		</tr>
	
		<tr>
			<td>Engine status</td>
			<td>
				<span id="uptime"></span>
			</td>
			<td>
				<span id="engine"></span>
			</td>
		</tr>

		<tr>
			<td>Last errors</td>
			<td>
				<span id="nofLastErrors"></span>
			</td>
			<td>
				<span id="clearErrors"></span>
			</td>
		</tr>
	
		<tr>
			<td>Internal log</td>
			<td>
				<span id='verbose'></span>
			</td>
			<td>
				<b><a id='getlog' href="#">download log file</a></b>
			</td>
		</tr>
	
		<tr>
			<td><a class='help' title='Click for explanation' id='status.heap' href='#'>JVM heap memory</a></td>
			<td>
			<span id="heap"></span>	
			</td>
			<td><a id='gc' href="#">run garbage collection</a></td>
		</tr>
	
		<tr>
			<td><a class='help' title='Click for explanation' id='status.threads' href='#'>Number of threads</a></td>
			<td>
				<span id="threads"></span>
			</td>
			<td><a id='getstack' href="#">fetch stack traces</a></td>
		</tr>

		<tr>
			<td><a class='help' title='Click for explanation' id='status.inflowCount' href='#'>Inflow count</a></td>
			<td>
				<span id="inflowCount"></span> 
			</td>
			<td>
			</td>
		</tr>

		<tr>
			<td><a class='help' title='Click for explanation' id='status.inflowRate' href='#'>Inflow rate (events/sec)</a></td>
			<td>
				<span id="inflowRate"></span> 
			</td>
			<td>
				<a id='resetStats' href="#"><img src='images/clear.gif' title='Reset statistics'/>reset stats</a>
			</td>
		</tr>

		<tr>
			<td><a class='help' title='Click for explanation' id='status.dbTrhroughput' href='#'>Database throughput (events/sec)</a></td>
			<td>
				<span id="dbthroughput"></span>
			</td>
			<td></td>
		</tr>

		<tr>
			<td><a class='help' title='Click for explanation' id='status.overflowBuffer' href='#'>Overflow buffer</a></td>
			<td>
				<span id="overflowBuffer"></span>
			</td>
			<td>
				<a id='purgeOverflow' href="#"><img src='images/trash.gif' title='Purge'/> purge</a>
			</td>
		</tr>
		
		<tr>
			<td><a class='help' title='Click for explanation' id='status.connections' href='#'>Connections</a></td>
			<td>
				<span id="connections"></span>
			</td>
			<td></td>
		</tr>

		<tr>
			<td>Connected to database</td>
			<td>
				<span id="dbcon"></span>
			</td>
			<td></td>
		</tr>
	
		<tr>
			<td><a class='help' title='Click for explanation' id='status.dbCount' href='#'>Number of records</a></td>
			<td>
				<span id="dbcount"></span>
			</td>
			<td><a id="drop" href="#"><img src='images/trash.gif' title='Drop and re-create database schema'/> re-create database</a></td>
		</tr>

		<%if(dbsize){%>
		<tr>
			<td><a class='help' title='Click for explanation' id='status.dbSize' href='#'>Database storage size</a></td>
			<td><span id="dbsize"></span></td>
			<td></td>
		</tr>
		<%}%>
	
		<%for(String key : dbinfo.keySet()){%>
         <tr>
            <td><%=key%></td>
            <td><%=dbinfo.get(key)%></td>
            <td></td>
         </tr>
         <%}%>

	    <%if(maint){%>
		<tr>
			<td><a class='help' title='Click for explanation' id='status.dbMaint' href='#'>Next database maint time</a></td>
			<td>
				<span id="dbmaint"></span>
			</td>
			<td>
				<a id='dbmaintnow' href='#'>do maintenance now</a>
			</td>
		</tr>
		<%}%>
		

	</table>

      <div id="dumpDialog">
      	  <div class="formNote">
      	  	This operation collects log files, configuration files and other run time artefacts from
      	  	your logFaces server installation into a single archive which you may want to send 
      	  	to our support team when requested.
      	  </div>
          <form id="dumpForm">
          </form>
      </div>

      <%@ include file="common-dialogs.jsp"%>

	</div> <!--end main DIV -->
</div> <!--end content DIV -->

<%@ include file="footer.jsp" %>