<%@ include file="header.jsp" %>
<%@ page import="java.util.*" %>
<%@ page import="java.net.URLEncoder" %>
<%@ page import="com.moonlit.logfaces.server.admin.models.*"%>

<%
	Map params = (Map)request.getAttribute("params");
	boolean ldapFailed = params.get("ldapFailed") != null;
	boolean authorizationEnabled = (Boolean)params.get("authorizationEnabled");
	boolean ldapEnabled = (Boolean)params.get("ldapEnabled");
	boolean ksok = (Boolean)params.get("keyStoreOK");
	int nofTrustCerts = (Integer)params.get("nofTrustCerts");
	int subtab = (Integer)params.get("subtab");
	List<GroupModel> groups = (List<GroupModel>)params.get("groups"); 
	List<OptionModel> ldapOptions = (List<OptionModel>)params.get("ldap");
%>

<script src="scripts/security.js?v=130323" type="text/javascript"></script>

<%@ include file="menu.jsp"%>

<div id="content">	
	<div id="main">
		<div id="tabs">
		    <ul>
		        <li><a href="#network"><span>Network</span></a></li>
		        <li><a href="#authentication"><span>Authentication</span></a></li>
		        <%if(ldapEnabled){%>
		        <li><a href="#authorization"><span>Authorization</span></a></li>
		        <li><a href="#test"><span>Test login</span></a></li>
		        <%}%>
		    </ul>
		
			<input id="subtab" type="hidden" value='<%=subtab%>'/>

			<div id="network">
			    <i class='fa fa-info-circle fa-lg text-side'></i>
				To secure network traffic with SSL you can either 
				 <a class="help" title="Click for explanation" id="ssl.import" href="#">import your own certificates</a> 
				or use 
				<a class="help" title="Click for explanation" id="ssl.selfsigned" href="#">self signed certificates</a> 
				generated internally.
				The certificates are stored on this server local disk in password protected files called key/trust stores.
				Once configured, you will be able to enable SSL options in various parts of the server. 
				<br><br>
				
				<i class='fa fa-key fa-lg text-side'></i>
				<b>Key store</b> holds SSL certificates for accepting <b>incoming connections</b> from clients, admins, appenders.<br>
				<%if(ksok){%>
					Key store is <b><span class='text-green'>OK</span></b>, use actions on the right to modify it.<br>
					<%}else{%>
					Key store is currently <b><span class='text-red'>empty</span></b>, use actions on the right to set it up.<br>
				<%}%>
				<div style="float: right;">
					<a id='importKeyStore' href="#" title='import certificate and private key into local key store'><i class='fa fa-plus fa-lg text-blue'></i></a>&nbsp;&nbsp;	
					<a id='generateKeyStore' href="#" title='generate self signed certificate'><i class='fa fa-bug fa-lg text-blue'></i></a>&nbsp;&nbsp;
				</div>
				
				<br><br>
				
				<i class='fa fa-certificate fa-lg text-side'></i>
				<b>Local Trust store</b> holds SSL certificates for <b>outgoing connections</b> to your databases, LDAP, etc.
				   in addition to certificates available in JVM trust store (/jre/lib/security/cacert). 
				<br>
				<%if(nofTrustCerts > 0){%>
					Local trust store currently holds <b><span class='text-green'><%=nofTrustCerts%></span></b> certificate(s), 
					use action button on the right to add more.<br>
					<%}else{%>
					Local trust store is currently <b><span class='text-red'>empty</span></b>, use action button on the right to add one.<br>
				<%}%>
				<div style="float: right;">
					<a id='importTrustStore' href="#" title='import certificate into local trust store'><i class='fa fa-plus fa-lg text-green'></i></a>&nbsp;&nbsp;
					<a id='clearTrustStore' href="#" title='remove all certificates from local trust store'><i class='fa fa-remove fa-lg text-red'></i></a>&nbsp;&nbsp;
					<input id="tsFile" type="file" name="tsFile" style="display: none;" />	
				</div>
			</div>
						
			<div id="authentication">
				Clients will be prompted to login when authentication is enabled.
				Note that this is not the same as admin access, the authentication here
				is dedicated for users accessing the log data of this server instance. 
			
				<form id="authForm">	
					<table class="listing">
						<%
							for(OptionModel option : ldapOptions){
						%>
						    <% request.setAttribute("option", option);%>
						    <% request.setAttribute("width", "50%");%>
							<jsp:include page="optrow.jsp" />
						<%}%>
					</table>			
		
					<div class="formButtonBar" align="center">
						<input type="submit" value="Apply"/>
						<input type="reset" value="Undo">
					</div>
				</form>
			</div>
	
			<%if(ldapEnabled){%>
			<div id="authorization">
				<input id="authorizationEnabled" name="authorizationEnabled" type="checkbox" <%if(authorizationEnabled){%> checked="checked" <%}%>/> Authorization enabled
				<p>			
				Authorization controls what kind of log data should be exposed to certain users.
				This process is based on user group membership. 
				Names of the groups are imported from your name server and mapped to logFaces by assigning criteria filters.
				During login, logFaces will examine user group membership and allow access to log data matching those groups criteria.
				</p>
				<div id="acontrols" <%if(!authorizationEnabled){%>style='display: none;'<%}%>>
					<div style="float: right;">
						<a id='importAll' href="#" title="Import groups from 'Group base DN'"><img src='images/import.gif'> Import groups</a>
						&nbsp;
						<a id='importFiltered' href="#" title="Import groups from 'Group base DN' using filters"><img src='images/filter.gif'> Import with filter</a>
						&nbsp;
						<a id='clearGroups' href="#" title='Remove all authorization mappings'><img src='images/clear.gif'> Clear mapping</a>
					</div>
					<br>
					
					<table id="atable">
						<thead>
							<tr>
								<th></th>
								<th>Group name</th>
								<th>Access control</th>
								<th>Actions</th>
							</tr>	
						</thead>
						
						<%for(GroupModel group : groups){%>
							<tr>
								<td>
									<span class='id' style='display: none;'><%=group.getId()%></span>
									<img title='Active' src='images/<%=group.getIcon()%>'/>
								</td>
								<td><%=group.getName()%></td>
								<td><%=group.getNote()%></td>
								<td>
									<a class='gr-edit' href="#"><img title='Modify this mapping criteria' src='images/edit.gif'/></a>&nbsp;
									<a class='gr-remove' href="#"><img title='Remove this mapping' src='images/clear.gif'/></a>
								</td>
							</tr>
						<%}%>
					</table>
				</div>
			</div>
	
			<div id="test">
				<form action="loginTest" method="post">	
					Here you can test drive your LDAP settings and check how different principals are found and what
					authorities they are granted. Actual logFaces clients, when prompted to login, will obtain the results you will see here. 
					Try to login below and see what you get:
					<table class="listing">
						<tr>
							<td>User name</td>
							<td><input name="userName" size="50" value=""></input></td>
							<td>This user name should be found under base user DN specified in authentication settings.</td>
						</tr>
						<tr>
							<td>Password</td>
							<td><input type="password" name="password" size="50" value=""></input></td>
							<td>We will try to bind to that user name using this password.</td>
						</tr>
					</table>			
				<br/>
				<div align="center">
					<input type="submit" value="Try to login"/>
				</div>
				</form>
			</div>
			<%}%>
			
	      <div id="groupsDialog">
	          <form id="groupsForm" style="width: 100%;height: 90%;">
	          </form>
	      </div>

		  <%@ include file="common-dialogs.jsp"%>		
		  <%@ include file="ssl-dialog.jsp"%>
			
		</div> <!--end tabs DIV -->
	</div> <!--end main DIV -->
</div> <!--end content DIV -->

<%@ include file="footer.jsp" %>