<%@ include file="header.jsp" %>
<%@ page import="java.util.*" %>
<%@ page import="com.moonlit.logfaces.server.admin.models.*"%>

<%
	Map params = (Map)request.getAttribute("params");
	List<OptionModel> smtp = (List<OptionModel>)params.get("smtp");
	List<ReportModel>  reports = (List<ReportModel>)params.get("reports"); 
	List<TriggerModel> triggers = (List<TriggerModel>)params.get("triggers");
	Object subtab = params.get("subtab");
%>

<script src="scripts/notifications.js?v=100720" type="text/javascript"></script>

<%@ include file="menu.jsp"%>

<div id="content">		
	<div id="main">
		<div id="tabs">
		    <ul>
		    	<li><a href="#smtp"><span>SMTP</span></a></li>
		        <li><a href="#reports"><span>Scheduled reports</span></a></li>
		        <li><a href="#triggers"><span>Real-time triggers</span></a></li>
		    </ul>
		
			<input id="subtab" type="hidden" value='<%=subtab%>'/>
	
			<div id="smtp">
				<i class='fa fa-info-circle fa-lg text-side'></i>
				These settings will be used for sending out e-mail notifications like reports or triggers. 
				If you are intending to use reports or triggers, make sure that outgoing email
				is setup properly.
				<br>
				<div style="float: right;">
					<i class='fa fa-send fa-lg text-blue'></i>
					<a id='testEmail' href="#">Test outgoing email</a><br>
				</div>
				<br>
				
				<form id="smtpForm">
					<table class="listing">
						<%
							for(OptionModel option : smtp){
						%>
						    <% request.setAttribute("option", option);%>
							<jsp:include page="optrow.jsp" />
						<%}%>
					</table>
		
					<div align="center"><br>
						<input type="submit" value="Apply"/> 
						<input type="reset" value="Undo"/>
					</div>
		
				</form>
			</div>
					
			<div id="reports">
				<i class='fa fa-info-circle fa-lg text-side'></i>
				Reports are scheduled queries which server will execute and deliver results to email recipients.
				Along with delivery options you can specify database query to cover certain period of time. One 
				of the typical examples of reports usage is to schedule daily list of errors, exceptions or other interesting
				items. Fired periodically such report will bring you fresh information daily.

				<div class="buttonBar">
					<a id="radd" href="#" title='Create new report'><i class='fa fa-plus text-side'></i> Create new</a>&nbsp;&nbsp;
					<a id="r-disable-all" title='Pause all active reports' href="#"><i class='fa fa-pause text-side'></i> Pause all</a>&nbsp;&nbsp;
					<a id="r-enable-all" title='Resume all paused reports' href="#"><i class='fa fa-play text-side'></i> Resume all</a>
				</div>

				<table id='reportsTable'>
					<thead>
						<tr>
							<th title='Report state'></th>
							<th title='Name of the report for reference'>Name</th>
							<th title='Cron expression for scheduling report'>Cron</th>
							<th title='Next time report will be fired'>Next</th>
							<th title='Report control actions'>Actions</th>
						</tr>
				   </thead>
				   
				   <tbody>
					   <%for(ReportModel report : reports){%>
						<tr>
							<td style="width: 20px;">
								<input type="hidden" class='id' name='id' value='<%=report.getId()%>'/>
								<span class='renabled'><%=report.isEnabled()?"<img title='Enabled' src='images/enabled.gif'/>":"<img title='Disabled' src='images/exclude.gif'/>"%></span>
							</td>	
	
							<td> 
								<%=report.getName()%>
							</td>
		
							<td style="width:150px;">
								<%=report.getCron()%>
							</td>
		
							<td>
							    <%if(report.isEnabled()){ %>
								<%=report.getNextFireTime()%>
								<%}%>
							</td>
		
							<td style="width:130px;">
								<a class='renable' href='#'><%=report.isEnabled()?"<img title='Pause' src='images/pause.gif'/>":"<img title='Resume' src='images/run.gif'/>"%></a>&nbsp;
								<a class='redit' href="#"><img title='Modify this report' src='images/edit.gif'/></a>&nbsp;
								<a class='rclone' href="#"><img title='Duplicate this report' src='images/copy.gif'/></a>&nbsp;
								<a class='rtest' href="#"><img title='Test this report' src='images/export.gif'/></a>&nbsp;
								<a class='rremove' href="#"><img title='Remove this report' src='images/clear.gif'/></a>
							</td>
						</tr>
						<%}%>
					<tbody>
				</table>
			</div>
				
		   <div id="triggers">
		   	   <i class='fa fa-info-circle fa-lg text-side'></i>	
			   Triggers send notifications when captured log events fall under a specified criteria. 
			   This works in <b>real-time</b>, once trigger conditions are met, the notification gets delivered with 
			   the events captured. You can enable or disable triggers, specify delivery options and capture criteria.

				<div class="buttonBar">
					<a id="tadd" title='Create new trigger' href="#"><i class='fa fa-plus text-side'></i> Create new</a>&nbsp;&nbsp;
					<a id="t-disable-all" title='Disable all active triggers' href="#"><i class='fa fa-pause text-side'></i> Disable all</a>&nbsp;&nbsp;
					<a id="t-enable-all" title='Enable all disabled triggers' href="#"><i class='fa fa-play text-side'></i> Enable all</a>&nbsp;&nbsp;
					<a id="t-ack-alerts" title='Acknowledge all outstanding alerts' href="#"><i class='fa fa-bell-slash text-side'></i> Clear alerts</a>
				</div>

				<table id='triggersTable'>
					<thead>
						<tr>
							<th title='Tigger state'></th>
							<th title='Name of the trigger for reference'>Name</th>
							<th title='Trigger firing rule'>Rule</th>
							<th title='Last time trigger was fired'>Fired</th>
							<th title='Trigger control actions'>Actions</th>
						</tr>
				   </thead>
				   
				   <tbody>
					   	<%for(TriggerModel trigger : triggers){%>
					   		<tr>
					   			<td>
					   				<input type="hidden" class='id' name='id' value='<%=trigger.getId()%>'/>
					   				<span class='tenabled'><%=trigger.isEnabled()?"<img title='Enabled' src='images/enabled.gif'/>":"<img title='Disabled' src='images/exclude.gif'/>"%></span>
					   			</td>
					   			<td><%=trigger.getName()%></td>
					   			<td><%=trigger.getRule()%></td>
					   			<td>
					   				<span class='<%=trigger.isAlerts()?"talert text-warn":"talert"%>'>
					   					<%=trigger.getLastFiredTime()%>
					   				</span>
					   			</td>
								<td style="width:120px;">
									<a class='tenable' href='#'><%=trigger.isEnabled()?"<img title='Pause' src='images/pause.gif'/>":"<img title='Resume' src='images/run.gif'/>"%></a>&nbsp;
									<a class='tedit' href="#"><img title='Modify this trigger' src='images/edit.gif'/></a>&nbsp;
									<a class='tclone' href="#"><img title='Duplicate this trigger' src='images/copy.gif'/></a>&nbsp;
									<a class='tremove' href="#"><img title='Remove this trigger' src='images/clear.gif'/></a>
								</td>
					   		</tr>
					   	<%}%>
				   </tbody>				   
				</table>
			</div>
		</div>		
		
		<%@ include file="common-dialogs.jsp"%>
		
	</div> <!--end main DIV -->
</div> <!--end content DIV -->

<%@ include file="footer.jsp" %>