<%@ include file="header.jsp"%>
<%@ page import="java.util.*"%>
<%@ page import="com.moonlit.logfaces.server.util.LastError"%>

<%
	Map params = (Map)request.getAttribute("params");
	List<LastError> errors = (List<LastError>)params.get("lastErrors");
%>

<script src="scripts/lasterrors.js?v=100720" type="text/javascript"></script>

<%@ include file="menu.jsp"%>
<div id="content" class="ui-widget ui-widget-content">
	<div id="main">
	    <i class='fa fa-info-circle fa-lg text-side'></i>
		These are the most recent errors occurred in the server and may require some of your attention.
		Internal log file will often have more insight into the root causes of these issues.   
		If you can't interpret the logs yourself, please submit a support call
		including your server license and the log file.
		<br>

		<div style="float: right;margin-bottom: 5px;margin-top: 20px;">
		    <i class='fa fa-trash-o text-side'></i>
		    <a id="reset" href="#" title='Acknowledge and reset all errors'>Reset all</a>&nbsp;&nbsp;
		    <i class='fa fa-download text-side'></i>
			<a id="getlog" href="#" title='Download the most recent server log file'>Download the logs</a>&nbsp;&nbsp;
			<i class='fa fa-support text-red'></i>
			<a target="new" title='Open new support ticket' href="<%=System.getProperty("com.moonlit.logfaces.url.support")%>"> Support call</a>
		</div>

		<table id="errorsTable">
			<thead>
				<tr>
					<th title="Time">Time</th>
					<th title="Code">Code</th>
					<th title="Message">Error message</th>
				</tr>
			</thead>
		
			<tbody>
				<%for(LastError error : errors){%>
				<tr>
					<td><%=error.getTimeStamp()%></td>
					<td><%=error.getCode()%></td>
					<td><%=error.getText()%></td>
				</tr>
				<%}%>
			</tbody>
		
		</table>

		<br/>
		<%@ include file="common-dialogs.jsp"%>
	
	</div>
</div>

<%@ include file="footer.jsp"%>