<%@ include file="header.jsp" %>
<%@ page import="java.util.*" %>
<%@ page import="com.moonlit.logfaces.server.admin.models.*"%>

<%
	Map<String,Object> params = (Map<String,Object>)request.getAttribute("params");
	List<OptionModel> detector = (List<OptionModel>)params.get("detector");
	long fid = (Long)params.get("fid");
	String criteria = ((String)params.get("criteria"));
	String title = ((String)params.get("title"));
%>

<script src="scripts/fd.js?v=211217" type="text/javascript"></script>

<ul id="menu">
	<li style="color: #717174;"><%=title%></li>
	<li class="icon"><img class="subject" title='Flood detector' src='images/report.png'/></li>
</ul>

<div id="content">		
	<div id="main">
		<div id="tabs">
		    <ul>
		    	<li><a href="#params"><span>Parameters</span></a></li>
		        <li><a href="#query"><span>Criteria</span></a></li>
		    </ul>
	    	<form id="fd-form">
	    		<input type="hidden" class='fid' name='id' value='<%=fid%>'/>
		    	<div id="params">
			   		<table class="listing">
						<%
							for(OptionModel option : detector){
						%>
						    <% request.setAttribute("option", option);%>
						    <% request.setAttribute("width", "40%");%>
							<jsp:include page="optrow.jsp" />
						<%}%>
			   		</table>
		   		</div>
			    
			    <div id="query">
					Log events matching this criteria will be subjected to flood detection in specified time window and threshold.
					<input id="jsonText" name="criteria" type="hidden" value="<%=criteria%>"></input>
					<div id="criteria" class="criteria"></div>
		    	</div>
			    
				<div align="center">
					<input type="submit" value="Save"/>
					<input type="button" value="Cancel" id="cancel"/>  
				</div>
			</form>	    
		</div>
	</div> <!--end main DIV -->
	
	<%@ include file="common-dialogs.jsp"%>
	
</div> <!--end content DIV -->

<%@ include file="footer.jsp" %>