<%@ include file="header.jsp"%>
<%@ page import="java.util.*"%>
<%@ page import="com.moonlit.logfaces.server.admin.models.*"%>

<script src="scripts/connectivity.js?v=100720" type="text/javascript"></script>

<%
	Map<?,?> params = (Map<?,?>)request.getAttribute("params");
    List<OptionModel> external = (List<OptionModel>)params.get("external");
    List<ReceiverModel> receivers = (List<ReceiverModel>)params.get("receivers");
    List<FloodDetectorModel> fds = (List<FloodDetectorModel>)params.get("fds");
    boolean pairingEnabled = ((Boolean)params.get("pairingEnabled")).booleanValue();
    String blacklist = (String)params.get("blacklist");
    Object subtab = params.get("subtab");
%>

<%@ include file="menu.jsp"%>

<div id="content">
	<div id="main">
		<div id="tabs">
		    <ul>
		        <li><a href="#clients"><span>Front end</span></a></li>
		        <li><a href="#receivers"><span>Receivers</span></a></li>
		        <li><a href="#blacklist"><span>Blacklist</span></a></li>
		        <li><a href="#flood"><span>Flood</span></a></li>
		        <%if(pairingEnabled){%>
		        <li><a href="#pairing"><span>Pairing</span></a></li>
		        <%}%>
		    </ul>
		    <input id="subtab" type="hidden" value='<%=subtab%>'/>

			<div id="clients">	
				<form action="updateConnectivity" method="post">
				    <input name="subtab" type="hidden" value="0"/>
				    <i class='fa fa-info-circle fa-lg text-side'></i>
					Here you specify how logFaces server is exposed to rich clients and administration.
					Note that changing any of these parameters may require server restart.<br><br>
					<table class="listing">
						<%
							for(OptionModel option : external){
						%>
						    <%
						    	request.setAttribute("option", option);
						    %>
							<jsp:include page="optrow.jsp" />
						<%
							}
						%>
					</table>
					
					<br>
					<div align="center">
						<input type="submit" value="Apply"/>
						<input type="reset" value="Undo"/>
					</div>
				</form>
				
			</div>
			
			<div id="receivers">
					<i class='fa fa-info-circle fa-lg text-side'></i>
					Logs are handled by means of receivers. There are several types of receivers supported.
					You can have several instances of the same type provided that they are bound to different resources.
					For example, socket receivers must not collide with port numbers.
					Use links below to add receivers and links in the table to modify and control them. 

					<div class="buttonBar">
						<a id='newLog4jRx' href='#' title="Create new TCP or UDP socket receiver"><i class='fa fa-plug text-side'></i> Add socket receiver</a>&nbsp;
						<a id='newSyslogRx' href='#' title="Create new syslog receiver"><i class='fa fa-microchip text-side'></i> Add syslog receiver</a>&nbsp;
						<a id='newWebRx' href='#' title="Create new HTTP receiver"><i class='fa fa-globe text-side'></i> Add web receiver</a>&nbsp;
						<a id='newDropzoneRx' href='#' title="Create new drop zone receiver"><i class='fa fa-folder-open text-side'></i> Add dropzone</a>
						
					</div>

					<table id='rxtable'>
						<thead>
							<tr>
								<th title='ID'></th>
								<th title='Type of receiver'>Type</th>
								<th title='Protocol'>Protocol</th>
								<th title='Socket binding'>Binding</th>
								<th title='Description'>Description</th>
								<th title='Receiver actions'>Actions</th>
							</tr>
						</thead>		
						<tbody>						
						<%for(ReceiverModel vo : receivers){%>
							<tr>
								<td style="width: 20px;">
									<input type="hidden" name='id' value='<%=vo.getId()%>'/>
									<span class='id' style='display: none;'><%=vo.getId()%></span>
									<span class='enabledRx'><%=vo.isActive()?"<img title='Active' src='images/enabled.gif'/>":"<img title='Disabled' src='images/exclude.gif'/>"%></span>
								</td>
								<td><span class='type'><%=vo.getType()%></span></td>
								<td><span class='protocol'><%=vo.getProtocol()%></span></td>
								<td><span class='binding'><%=vo.getBinding()%></span></td>
								<td><span class='desc'><%=vo.getDescription()%></span></td>
								<td style="width: 100px;">
									<a class='controlRx' href='#'><%=vo.isActive()?"<img title='Pause' src='images/pause.gif'/>":"<img title='Resume' src='images/run.gif'/>"%></a>&nbsp;
									<a class='editRx' href='#'><img title='Modify' src='images/edit.gif'/></a>&nbsp;
									<a class='testRx' href='#'><img title='Test' src='images/export.gif'/></a>&nbsp;
									<a class='removeRx' href='#'><img title='Remove' src='images/clear.gif'/></a>
								</td>
							</tr>
						<%}%>
						</tbody>
					</table>   
			</div>
			
			<div id="blacklist">
				<i class='fa fa-info-circle fa-lg text-side'></i>
				Use the criteria below to prevent some logs entering the system. 
				Log events matching the criteria below will be permanently discarded.
				<div class="helpRight">
					<a class='help' id='criteria' href='#'><img src='../images/tip.gif'></img>What is criteria?</a>
				</div>
				<br><br>
				
				<form id="blc">
					<input id="json" name="json" type="hidden" value="<%=blacklist%>"/>
					<input name="subtab" type="hidden" value="blacklist"/>
					<div id="criteria" class="criteria"></div>
				
					<br>
					<div align="center">
						<input type="submit" value="Apply"/>
					</div>
				</form>
				
			</div>

			<div id="flood">
				<i class='fa fa-info-circle fa-lg text-side'></i>
				Flood detectors can reduce incoming traffic by discarding certain events when 
				they arrive in large numbers or bursts. 
				It is possible to have several detectors working independantly each using its own rules.   

				<div class="buttonBar">
					<a id="fd-add" title='Create new flood detector' href="#"><i class='fa fa-plus text-side'></i> Add new</a>&nbsp;&nbsp;
					<a id="fd-disable-all" title='Pause all active detectors' href="#"><i class='fa fa-pause text-side'></i> Pause all</a>&nbsp;&nbsp;
					<a id="fd-enable-all" title='Resume all paused detectors' href="#"><i class='fa fa-play text-side'></i> Resume all</a>
				</div>
				
				<table id="fdstable">
					<thead>
						<tr>
							<th></th>
							<th title="Detector name or description">Description</th>
							<th title="Time window for determining if flood occurs">Window</th>
							<th title="How many events in time window to consider as flood">Threshold</th>
							<th title="How many events this detector is discarded so far">Discarded</th>
							<th title="Control actions">Actions</th>
						</tr>
				   </thead>
				   
				   <tbody>
					   	<%for(FloodDetectorModel fd : fds){%>
					   		<tr>
								<td style="width: 20px;">
									<span class='id' style='display: none;'><%=fd.getId()%></span>
									<span class='fd-enabled'><%=fd.isEnabled()?"<img title='Active' src='images/enabled.gif'/>":"<img title='Disabled' src='images/exclude.gif'/>"%></span>
								</td>
					   			<td><%=fd.getDescription()%></td>
					   			<td><%=fd.getWindowString()%></td>
					   			<td><%=fd.getThreshold()%></td>
					   			<td><%=fd.getCount()%></td>
								<td style="width: 120px;">
									<a class='fd-enable' href='#'><%=fd.isEnabled()?"<img title='Pause' src='images/pause.gif'/>":"<img title='Resume' src='images/run.gif'/>"%></a>&nbsp;
									<a class='fd-edit' href="#"><img title='Modify this detector rules' src='images/edit.gif'/></a>&nbsp;
									<a class='fd-clone' href="#"><img title='Duplicate this detector' src='images/copy.gif'/></a>&nbsp;
									<a class='fd-remove' href="#"><img title='Remove this detector' src='images/clear.gif'/></a>
								</td>
					   		</tr>
					   	<%}%>
				   </tbody>
				</table>
			</div>
					
			<%if(pairingEnabled){
				List<PairModel> pairs = (List<PairModel>)params.get("pairs");
			%>
			<div id="pairing">
				<i class='fa fa-info-circle fa-lg text-side'></i>
				When several logFaces nodes serving large amount of applications, 
				you may want to have a (front end) as a single point of access for the clients. 
				To achieve this, add other nodes to be paired with this node and then use this node as front end. 
				Once paired, the clients will receive consolidated log stream from all paired nodes you define below: 				    
				
				<div>
					<div class="buttonBar">
						<a id="addPair" href="#" title="Create new paired node for this host"><i class='fa fa-plus text-side'></i> Add pair</a>&nbsp;&nbsp;
						<a id="unpair" href="#" title="Remove all pairs from this host configuration"><i class='fa fa-remove text-red'></i> Remove all pairs</a>
					</div>
					
					<table id="pairs">
						<thead>
							<tr>
								<th></th>
								<th>Address</th>
								<th>Port</th>
								<th>SSL</th>
								<th>Actions</th>
							</tr>
					   </thead>
					   
					   <%for(int i=0; i<pairs.size(); i++){
						   PairModel pair = pairs.get(i);
					   %>
					   		<tr>
					   			<td>
					   				<span class='pairState'>
						   				<%=pair.isConnected()?"<img title='node is active' src='images/enabled.gif'/>":"<img title='node is offline' src='images/exclude.gif'/>"%>
					   				</span>
					   			</td>
					   			<td>
					   				<span class='pairHost'><%=pair.getHost()%></span>
					   			</td>
					   			<td>
					   				<span class='pairPort'><%=pair.getPort()%></span>
					   			</td>
								<td>
								    <span class='pairSsl'><%if(pair.isSecure()){%>yes<%}else{%>no<%}%></span>
								</td>
								<td>
									<a class='editPair' href='#'><img title='Modify' src='images/edit.gif'/></a>&nbsp;
									<a class="removePair" href="#"><img title='Remove this node' src='images/remove.gif'/></a>&nbsp;
									<a class="syncPair<%=i%>" href="#"><img title='Deploy this node configuration on remote node' src='images/import.gif'/></a>&nbsp;
									<a class="adminPair<%=i%>" href="<%=pair.getAdminUrl()%>" target="new"><img title='Go to administration' src='images/right.gif'/></a>
								</td>
					   		</tr>
					   <%}%>
					</table>
				</div>
			</div>
			<%}%>	
		</div>
	
      <div id="rxDialog">
           <div class="formNote"></div>
      
          <form id="rxForm">
             <input type="hidden" id='type' name='type'/>
             <input type="hidden" id='id' name='id'/>
             <table id="options" class="listing">
             </table>
          </form>
      </div>

      <div id="testDialog">
          <div class="formNote"></div>
          <form id="testForm">
             <input type="hidden" id='id' name='id'/>
             <textarea name="message" id='message' rows="10" cols="20" style="width: 100%;"></textarea>
          </form>
      </div>

      <div id="pairDialog">
      	  <div class="formNote">Paired nodes are defined by their connection end point. 
      	  This server instance will converse with the paired node using the following parameters below.
      	  </div>
          <form id="pairForm">
             <input type="hidden" id='id' name='id'/>
             <table class="listing">
               <tr>
                  <td>Host or IP</td>
                  <td><input type="text" name="pairHost" id="pairHost" style="width: 100%"/></td>
               </tr>
               <tr>
                  <td>Port</td>
                  <td><input type="text" name="pairPort" id="pairPort" style="width: 100%"/></td>
               </tr>
               <tr>
                  <td>Use SSL</td>
                  <td>
                     <select style="width: 100%;" id="pairSsl" name="pairSsl">
                        <option>yes</option>
                        <option selected>no</option>
                     </select>
                  </td>
               </tr>
               <tr>
                  <td>Configuration</td>
                  <td>
                     <select style="width: 100%;" id="sync" name="sync">
                        <option selected value="true">Deploy this configuration</option>
                        <option value="false">Do nothing</option>
                     </select>
                  </td>
               </tr>
             </table>
          </form>
      </div>

      <%@ include file="common-dialogs.jsp"%>
      
	</div>
</div>
<%@ include file="footer.jsp"%>