#!/bin/sh
# ---------------------------------------------------------------------------
# Backup script for logFaces Server performs complete backup of 
# currently configured logFaces database into a file you specify.
#
# If logFaces server runs under embedded database - stop the server before backup.
# Expected two parameters - home directory and a file name where the backup will be saved.
# If file not specified, a default file name will be used.
#
# Expecting java to be installed and available to launch.
# ---------------------------------------------------------------------------
THE_OPTIONS ='-Xms256m -Xmx512m' 
THE_CLASSPATH=
for i in `ls ../lib/*.jar ../lib/dbdrivers/*.jar ../conf/*`
do
  THE_CLASSPATH=${THE_CLASSPATH}:${i}
done

BACKUP_FILE=$1
if [ -z $BACKUP_FILE ] 
  then
    BACKUP_FILE=./last-backup-data
fi  

java -cp $THE_CLASSPATH $THE_OPTIONS com.moonlit.logfaces.server.backup.Backup .. $BACKUP_FILE