$(document).ready(function() {
	var editedDest;
	var tid = $(".tid").val();
	$("#tabs").tabs();
	$("#tabs").tabs('option', 'activate', 0);

	$.get("rest?method=getTriggerDestinations&id="+tid, function(data, textStatus, xhr) {
		var table = $("div#params table");
		var destinations = data.destinations;
		for(i=0;i<destinations.length;i++){
			var row = $("<tr/>").appendTo(table);
			populateDestRow(row, destinations[i]);
		}
		
		
	}, "json")
	.fail(function(xhr){ 
		json = jQuery.parseJSON(xhr.responseText);
		alert(json.error); 
	})
	
	var criteria = new Criteria();
	criteria.show($('div#criteria'), $('input#jsonText'));
	$('#tform').on("submit", function(){
		criteria.makeJson();
		var formData = $("#tform").serialize();
		$.post("rest?method=updateTrigger", formData, function(data, textStatus, xhr) {
			window.location.href = "/notificationsTab?subtab=2";
		}, "json")
		.fail(function(xhr){ 
			$("#progress").dialog("close");
			json = jQuery.parseJSON(xhr.responseText);
			alert(json.error); 
		})
		
		return false;
	});
	
	
	$('select#type').on('change', function() {
		   if($(this).val() == "simple"){
			   $("tr#counter").show();
			   $("tr#sattr").hide();
			   $("tr#sexpr").hide();
		   }
		   else if($(this).val() == "split"){
			   $("tr#counter").show();
			   $("tr#sattr").show();
			   $("tr#sexpr").show();
		   }
		   else if($(this).val() == "silence"){
			   $("tr#counter").hide();
			   $("tr#sattr").hide();
			   $("tr#sexpr").hide();
		   }
	});
	
	$('input#cancel').on('click', null, function(event) {
		$.post("rest?method=updateTrigger&cancel=true&id="+tid, null, function(data, textStatus, xhr) {
			window.location.href = "/notificationsTab?subtab=2";
		}, "json")
		.fail(function(xhr){ 
			$("#progress").dialog("close");
			json = jQuery.parseJSON(xhr.responseText);
			alert(json.error); 
		})
	});
	
	$("body").on("click", "a#dest-email", function(event) {
		editedDest = $('a#dest-email').closest("tr");
		$.get("rest?method=getTriggerDestination&type=email&id="+tid, function(data, textStatus, xhr) {
			populateDestOptions(data.options);
			$("#destDialog #destForm #type").val("email");
			$("#destDialog").dialog("option", "title", "Mail parameters");
			$("#destDialog").dialog("open" );
		}, "json")
		.fail(function(xhr){ 
			json = jQuery.parseJSON(xhr.responseText);
			alert(json.error); 
		})
	});

	$("body").on("click", "a#remove-email", function(event) {
		if(!confirm("Remove e-mail notification?"))
			return;
		$.post("rest?method=removeTriggerDestination&type=email&id="+tid, null, function(data, textStatus, xhr) {
			$('a#dest-email').html("not specified");
			$('i#fa-email').removeClass("text-red");
			$('i#fa-email').removeClass("text-green");
			$('i#fa-email').addClass("text-gray");
			$('a#remove-email').remove();
		}, "json")
		.fail(function(xhr){ 
			json = jQuery.parseJSON(xhr.responseText);
			alert(json.error); 
		})
	});
	
	$("body").on("click", "a#dest-slack", function(event) {
		editedDest = $('a#dest-slack').closest("tr");
		$.get("rest?method=getTriggerDestination&type=slack&id="+tid, function(data, textStatus, xhr) {
			populateDestOptions(data.options);
			$("#destDialog #destForm #type").val("slack");
			$("#destDialog").dialog("option", "title", "Slack integration");
			$("#destDialog").dialog("open" );
		}, "json")
		.fail(function(xhr){ 
			json = jQuery.parseJSON(xhr.responseText);
			alert(json.error); 
		})
	});
	
	$("body").on("click", "a#remove-slack", function(event) {
		if(!confirm("Remove Slack notifications?"))
			return;
		$.post("rest?method=removeTriggerDestination&type=slack&id="+tid, null, function(data, textStatus, xhr) {
			$('a#dest-slack').html("not specified");
			$('i#fa-slack').removeClass("text-blue");
			$('i#fa-slack').addClass("text-gray");
			$('a#remove-slack').remove();
		}, "json")
		.fail(function(xhr){ 
			json = jQuery.parseJSON(xhr.responseText);
			alert(json.error); 
		})
	});
	
	$("body").on("click", "a#dest-webhook", function(event) {
		editedDest = $('a#dest-webhook').closest("tr");
		$.get("rest?method=getTriggerDestination&type=webhook&id="+tid, function(data, textStatus, xhr) {
			populateDestOptions(data.options);
			$("#destDialog #destForm #type").val("webhook");
			$("#destDialog").dialog("option", "title", "Web hook");
			$("#destDialog").dialog("open" );
		}, "json")
		.fail(function(xhr){ 
			json = jQuery.parseJSON(xhr.responseText);
			alert(json.error); 
		})
	});
	
	$("body").on("click", "a#remove-webhook", function(event) {
		if(!confirm("Remove web hook?"))
			return;
		$.post("rest?method=removeTriggerDestination&type=webhook&id="+tid, null, function(data, textStatus, xhr) {
			$('a#dest-webhook').html("not specified");
			$('i#fa-webhook').removeClass("text-green");
			$('i#fa-webhook').addClass("text-gray");
			$('a#remove-webhook').remove();
		}, "json")
		.fail(function(xhr){ 
			json = jQuery.parseJSON(xhr.responseText);
			alert(json.error); 
		})
	});

	$("body").on("click", "a#dest-alert", function(event) {
		editedDest = $('a#dest-alert').closest("tr");
		$.get("rest?method=getTriggerDestination&type=alert&id="+tid, function(data, textStatus, xhr) {
			populateDestOptions(data.options);
			$("#destDialog #destForm #type").val("alert");
			$("#destDialog").dialog("option", "title", "Alert");
			$("#destDialog").dialog("open" );
		}, "json")
		.fail(function(xhr){ 
			json = jQuery.parseJSON(xhr.responseText);
			alert(json.error); 
		})
	});
	
	$("body").on("click", "a#remove-alert", function(event) {
		if(!confirm("Remove alert?"))
			return;
		$.post("rest?method=removeTriggerDestination&type=alert&id="+tid, null, function(data, textStatus, xhr) {
			$('a#dest-alert').html("not specified");
			$('i#fa-alert').removeClass("text-green");
			$('i#fa-alert').removeClass("text-red");
			$('i#fa-alert').removeClass("text-orange");
			$('i#fa-alert').addClass("text-gray");
			$('a#remove-alert').remove();
		}, "json")
		.fail(function(xhr){ 
			json = jQuery.parseJSON(xhr.responseText);
			alert(json.error); 
		})
	});
	
	$("body").on("click", "a#dest-plugin", function(event) {
		editedDest = $('a#dest-plugin').closest("tr");
		$.get("rest?method=getTriggerDestination&type=plugin&id="+tid, function(data, textStatus, xhr) {
			populateDestOptions(data.options);
			$('select[name ="plugin"]').on('change', function() {
				populatePluginArguments($(this).prop('selectedIndex'));
			});	
			
			$("#destDialog #destForm #type").val("plugin");
			$("#destDialog").dialog("option", "title", "Plugin");
			$("#destDialog").dialog("open" );
		}, "json")
		.fail(function(xhr){ 
			json = jQuery.parseJSON(xhr.responseText);
			alert(json.error); 
		})
	});

	$("body").on("click", "a#remove-plugin", function(event) {
		if(!confirm("Remove plugin usage?"))
			return;
		$.post("rest?method=removeTriggerDestination&type=plugin&id="+tid, null, function(data, textStatus, xhr) {
			$('a#dest-plugin').html("not specified");
			$('i#fa-plugin').removeClass("text-green");
			$('i#fa-plugin').addClass("text-gray");
			$('a#remove-plugin').remove();
		}, "json")
		.fail(function(xhr){ 
			json = jQuery.parseJSON(xhr.responseText);
			alert(json.error); 
		})
	});	
	
   function populateDestOptions(options){
	   var table = $("#destDialog #destForm #options");
	   $(table).empty();
	   table = $("<tbody/>").appendTo(table);
	   for(i=0;i<options.length;i++){
		   var row = $("<tr/>").appendTo(table);
		   var td = $("<td style='width: 80px;'/>").appendTo(row);
		   if(options[i].helpID != null)
			   td.append("<a class='help' title='Click for explanation' id='" + options[i].helpID + "' href='#'>" + options[i].display + "</a>");
		   else
			   td.append(options[i].display);
		   
		   td = $("<td/>").appendTo(row);
		   if(options[i].choices == null){
			   $("<input name='" + options[i].name + "' type='text' value=\"" + options[i].value + "\" style='width: 100%'/>").appendTo(td);
		   }
		   else{
			   var select  = $("<select style='width: 100%;' name='" + options[i].name + "'/>").appendTo(td);
			   for(j=0;j<options[i].choices.length;j++){
					var option = $('<option>' + options[i].choices[j] + '</option>').appendTo(select);
					option.attr('value', options[i].choices[j]);
					if(options[i].value == options[i].choices[j])
						option.attr('selected', 'selected');
			   }
		   }
		   $("<td style='width: 30%;'>" + options[i].description + "</td>").appendTo(row);
	   }
   }
   
   function populatePluginArguments(plugin){
	   $.get("rest?method=getPluginArgs&plugin="+plugin, function(data, textStatus, xhr) {
		   var args = data.response;
		   var table = $("#destDialog #destForm #options");
		   table.find("tr:gt(0)").remove();
		   for(var r=0; r < args.length; r++){
			   var row = $("<tr/>").appendTo(table);
			   var td = $("<td/>").appendTo(row);
			   td.html(args[r]);
			   
			   td = $("<td/>").appendTo(row);
			   $("<input type='text' name='arg." + args[r] + "' style='width: 100%'/>").appendTo(td);
			   
			   td = $("<td/>").appendTo(row);
			   td.html(" invocation argument #" + (r+1));
		   }
		   
	   }, "json")
	   .fail(function(xhr){ 
		   json = jQuery.parseJSON(xhr.responseText);
		   alert(json.error); 
	  })
   }
	
	$("#destDialog").dialog({
		autoOpen: false,
		height: 350,
		width: 650,
		modal: true,
		buttons: {
			"Save": function() {
				var formData = $("#destForm").serialize();
				$.post("rest?method=updateTriggerDestination", formData, function(data, textStatus, xhr) {
					populateDestRow(editedDest, data.destination);
					$("#destDialog").dialog("close");
				}, "json")
				.fail(function(xhr){ 
					json = jQuery.parseJSON(xhr.responseText);
					alert(json.error);
				})
			},
			Cancel: function() {
				$(this).dialog( "close" );
				}
			},
		close: function() {
		}
	});   

	function populateDestRow(row, dest){
		row.empty();
		
		var td = $("<td/>").appendTo(row);
		var helpID = "trigger." + dest.type;
		var html = "<i id='fa-" + dest.type.toLowerCase() + "' class='fa " + dest.icon + "  fa-lg text-" + dest.color + "'></i>";
		html += "&nbsp;";
		html += dest.label;
		html = "<a class='help' title='Click for explanation' href='#' id='" + helpID + "'>" + html + "</a>";
		td.html(html);
		
		var td = $("<td/>").appendTo(row);
		if(!dest.display)
			dest.display = "not specified";
		var html = "<a title='modify' href='#' id='dest-" + dest.type.toLowerCase() + "'>" + shorten(dest.display, 50) + "</a>";
		if(dest.enabled)
			html += "<a title='mute' href='#' id='remove-" +dest.type.toLowerCase()+ "'><i class='fa fa-bell-slash-o text-gray right'></i></a>";
		td.html(html);

		var td = $("<td/>").appendTo(row);
		td.html(dest.description);
	}
	
	function shorten(text, maxLength) {
	    var ret = text;
	    if (ret.length > maxLength) {
	        ret = ret.substr(0,maxLength-3) + "...";
	    }
	    return ret;
	}	
});
