$(document).ready(function() {
	$("#tabs").tabs();
	$("#tabs").tabs("option", "active", $("#subtab").val());	

	$('#plibForm').on("submit", function(){
		$("#progress .message").html("Saving patterns library, please stand by...");
		$("#progress").dialog( "option", "title", "Saving");
		$("#progress").dialog("open");

		var formData = $('#plibForm').serialize();
		$.post("rest?method=updatePatterns", formData, function(data, textStatus, xhr) {
			$("#progress").dialog("close");
		}, "json")
		.fail(function(xhr) { 
			$("#progress").dialog("close");
			json = jQuery.parseJSON(xhr.responseText);
			alert(json.error); 
		})

		return false;
	});

	function normalizeEOL(text){
		return text.replace(/(\r\n|\r|\n)/g, '\r\n');
	}

	$("#testRegex").on('click', null, function(event) {
		var formData = $('#testForm').serialize();
		$.post("rest?method=testRegex", formData, function(data, textStatus, xhr) {
			showTestResult(data.response);
		}, "json")
		.fail(function(xhr) { 
			json = jQuery.parseJSON(xhr.responseText);
			alert(json.error); 
		})
	});

	function showTestResult(response){
		$("#helpDialog ").dialog( "option", "height", "500");
		$("#helpDialog ").dialog( "option", "width", "650");
		$("#helpDialog .formNote").html("<pre>" + response + "</pre>");
		$("#helpDialog").dialog( "option", "title", "Result");
		$("#helpDialog" ).dialog( "open" );
	}

});