$(document).ready(function() {
	var atable = $('#atable').dataTable({
		"bJQueryUI": true,
		"bPaginate": false,
		"bFilter": false,
		"bLengthChange": false,
		"fnInitComplete": initCallback,
		"sScrollY": '220px',
		"bStateSave": false,
		"aaSorting": [[ 1, "asc" ]],
		"oLanguage": {
			"sEmptyTable": "<p align='center'>No authorization defined<br></p>"
		},
		"aoColumns": [
			{"sClass": "text-left", "sWidth": "20px", "bSortable": false},
			{"sClass": "text-left", "bSortable": false},
			{"sClass": "text-left", "bSortable": false},
			{"sClass": "text-left", "sWidth": "60px","bSortable": false }
			]		

	});

	$("#tabs").tabs();
	$("#tabs").tabs("option", "active", $("#subtab").val());	
	$("#tabs" ).tabs({
		activate: function( event, ui ) {
			if(ui.newTab.index() == 2)
				atable.fnAdjustColumnSizing();
		}
	});
	
	handleAuthTypeSelection();
	$('select#authentication').on("change", function(){
		handleAuthTypeSelection();
	});
	
	function initCallback(oSettings, json){
		setTimeout(function(){
			atable.fnAdjustColumnSizing();
		}, 100);
	}
	
	function handleAuthTypeSelection(){
		if($('select#authentication').val() == "none"){
			$("tr[id*='com.logfaces.auth.user']").hide();
			$("tr[id*='com.logfaces.auth.pwd']").hide();
			$("tr[id*='ldap']").hide();
		}
		else if($('select#authentication').val() == "simple"){
			$("tr[id*='com.logfaces.auth.user']").show();
			$("tr[id*='com.logfaces.auth.pwd']").show();
			$("tr[id*='ldap']").hide();
		}
		else if($('select#authentication').val() == "ldap"){
			$("tr[id*='com.logfaces.auth.pwd']").hide();
			$("tr[id*='com.logfaces.auth.user']").hide();
			$("tr[id*='ldap']").show();
		}
	}

	function showGroups(filter){
		$("#progress .message").html("Getting group names...");
		$("#progress img").show();
		$("#progress").dialog( "option", "title", "Progress");
		$("#progress").dialog("open");

		$.get("rest?method=listGroups&filter=" + encodeURIComponent(filter), function(data, textStatus, xhr) {
			$("#progress").dialog("close");
			var groups = data.groups;
			if(groups.length == 0){
				alert("No user groups found"); 
				return;
			}

			var form = $('#groupsForm');
			form.empty();
			var select = $("<select id='groups' name='groups' multiple='multiple' style='width: 100%;height: 100%;'></select>").appendTo(form);
			for(i=0; i<groups.length; i++){
				$('<option>' + groups[i] + '</option>').appendTo(select);
			}

			$("#groupsDialog").dialog( "option", "title", "Select groups");
			$("#groupsDialog").dialog("open");

		}, "json")
		.fail(function(xhr){
			$("#progress").dialog("close");
			alert("Failed to walk directory tree"); 
		})
	}

	$('#authForm').on("submit", function(){
		$("#progress .message").html("Applying authentication settings, please stand by...");
		$("#progress").dialog( "option", "title", "Updating");
		$("#progress").dialog("open");
	    
	    var formData = $('#authForm').serialize();	
		$.post("/updateAuthentication", formData, function(data, textStatus, xhr) {
			if(!data.error){
				$("#progress").dialog("close");
				window.location.href = "securityTab?subtab=1";
				return;
			}
			
			doneProgress(data.info, false, function(){
				// do something after dialog closed?
			}); 
			
		}, "json")
		.fail(function(xhr){ 
			json = jQuery.parseJSON(xhr.responseText);
			doneProgress(json.error, false, function(){
				window.location.href = "securityTab?subtab=1";
			}); 
		})
	    	
    	return false;
	});

	$("a#importAll").on("click", null, function(){
		showGroups("");
	});

	$("a#importFiltered").on("click", null, function(){
		var filter = prompt("Use standard LDAP filter to match specific groups.\nFor example: (&(description=My*)(cn=H*))","");
		if(filter)
			showGroups(filter);
	});

	$("#authorizationEnabled").on("click", null, function(){
		$.post("rest?method=enableAuthorization", null, function(data, textStatus, xhr) {
			$("#authorizationEnabled").attr("checked", data.enabled);
			$("#acontrols").toggle();
			atable.fnAdjustColumnSizing();
		}, "json")
		.fail(function(xhr){
			$("#progress").dialog("close");
			json = jQuery.parseJSON(xhr.responseText);
			alert(json.error); 
		})
	});

	$("a#clearGroups").on("click", null, function(){
		if(confirm("This will remove all groups mapping.\nThis doesn't touch your DS, only logFaces configuration gets updated.") != true)
			return;
		$.post("rest?method=clearGroups", null, function(data, textStatus, xhr) {
			window.location.href = "/securityTab?subtab=2";
		}, "json")
		.fail(function(xhr){
			$("#progress").dialog("close");
			json = jQuery.parseJSON(xhr.responseText);
			alert(json.error); 
		})
	});

	$("a.gr-remove").on("click", null, function(){
		if(confirm("Remove this group mapping?\n(directory server is not changed, only logFaces configuration gets updated)") != true)
			return;

		var id = getID($(this));
		$.post("rest?method=removeGroup&id=" + id, null, function(data, textStatus, xhr) {
			window.location.href = "/securityTab?subtab=2";
		}, "json")
		.fail(function(xhr){
			json = jQuery.parseJSON(xhr.responseText);
			alert(json.error);
		})
	});

	$("a.gr-edit").on("click", null, function(){
		var id = getID($(this));
		window.location.href = "/group?id=" + id;
	});

	$("a#generateKeyStore").on("click", null, function(){
		var msg = "This will generate self signed certificate and use it as default for \nincoming SSL connections";
		if(confirm(msg) != true)
			return;

		showProgress("Generating certificate, please stand by...");
		$.post("rest?method=importKeyStoreCert&import=false", null, function(data, textStatus, xhr) {
			doneProgress(data.response.message, data.response.rc, function(){
				window.location.href = "/securityTab?subtab=0";	
			});
		}, "json")
		.fail(function(xhr){
			doneProgress(jQuery.parseJSON(xhr.responseText).error, false);
		})
	});

	$("a#importKeyStore").on("click", null, function(){
		$("#sslDialog").dialog("option", "url", "rest?method=importKeyStoreCert&import=true");
		$("#sslDialog").dialog("option", "title", "Create SSL key store");
		$("#sslDialog").dialog("open");
	});

	$("a#clearTrustStore").on("click", null, function(){
		var msg = "This will remove all enties in local trust store, proceed?";
		if(confirm(msg) != true)
			return;
			
		showProgress("Clearing local trust store, please stand by...");	
		$.post("rest?method=clearKeyStore&store=truststore", null, function(data, textStatus, xhr) {
					doneProgress(data.response.message, data.response.rc, function(){
						window.location.href = "/securityTab?subtab=0";	
					});

		}, "json")
		.fail(function(xhr){
			$("#progress").dialog("close");
			json = jQuery.parseJSON(xhr.responseText);
			alert(json.error); 
		})

	});

	$("a#importTrustStore").on("click", null, function(){
		$('#tsFile').trigger('click');
	});

	$("#tsFile").on("change", null, function(){
		showProgress("Importing certificate, please stand by...");

	    var reader = new FileReader();
	    var file = $("#tsFile")[0].files[0];
	    reader.readAsText(file,'UTF-8');
	    reader.onload = readerEvent => {
			var formData = new FormData();
			formData.append("fileName", file.name);
			formData.append("certificate", readerEvent.target.result);
			
			$.ajax({
				url: "rest?method=importTrustStoreCert",
				type: "POST",
				data: formData,
				async: true,
				cache: false,
				contentType: false,
				processData: false,
				success: function(data) {
					doneProgress(data.response.message, data.response.rc, function(){
						window.location.href = "/securityTab?subtab=0";	
					});
				},
				error: function(xhr) {
					json = jQuery.parseJSON(xhr.responseText);
					doneProgress(json, false, function(){
						window.location.href = "/securityTab?subtab=0";	
					});
				}
			});
	      
	   }
	});

	$("#sslDialog").dialog({
		autoOpen: false,
		height: 350,
		width: 650,
		modal: true,
		buttons: {
			"Create": function() {
				var url = $(this).dialog("option", "url");
				var formData = new FormData();
				var f1 = $('#sslForm #public')[0].files[0];
				var f2 = $('#sslForm #private')[0].files[0];
				formData.append("password", $('#sslForm #password').val());
				formData.append("public", f1);
				formData.append("private", f2);
				showProgress("Importing certificate, please stand by...");

				$.ajax({
					url: url,
					type: "POST",
					data: formData,
					async: true,
					cache: false,
					contentType: false,
					processData: false,
					success: function(data) {
						doneProgress(data.response.message, data.response.rc, function(){
							window.location.href = "/securityTab?subtab=0";	
						});
					},
					error: function(xhr) {
						json = jQuery.parseJSON(xhr.responseText);
						doneProgress(json, false, function(){
							window.location.href = "/securityTab?subtab=0";	
						});
					}
				});
			},
			Cancel: function() {
				$( this ).dialog( "close" );
				$('select#ssl').val("No");
			}
		},
		close: function() {
		}
	});	

	$("#groupsDialog").dialog({
		autoOpen: false,
		height: 350,
		width: 500,
		modal: true,
		buttons: {
			"Import": function() {
				var formData = $("#groupsForm").serialize();
				$.post("rest?method=importGroups", formData, function(data, textStatus, xhr) {
					$("#groupsDialog").dialog("close");
					window.location.href = "/securityTab?subtab=2";
				}, "json")
				.fail(function(xhr){
					$("#progress").dialog("close");
					json = jQuery.parseJSON(xhr.responseText);
					alert(json.error); 
				})

			},
			"Cancel": function() {
				$(this).dialog( "close" );
			}
		},
		close: function() {
		}
	});   

	$("#prompt #inp").html("How shall we list the groups?");
	$("#prompt").dialog({
		autoOpen: false,
		modal: true,
		buttons: {
			"Use the filter": function() {
				var text1 = $("#txt1");
				var text2 = $("#txt2");
				//Do your code here
				text1.val(text2.val().substr(1,9));
				$(this).dialog("close");
			},
			"List all groups": function() {
				$(this).dialog("close");
			}
		}
	});

	function getID(el){
		return $(el).parent().parent().find(".id").html();
	}

});