$(document).ready(function() {
	var smtpFormDirty = false;
	var ttable = $('#triggersTable').dataTable({
		"bJQueryUI": true,
		"bPaginate": false,
		"bFilter": false,
		"bLengthChange": false,
		"sScrollY": '220px',
		"bStateSave": false,
		'bAutoWidth': false,
		"aaSorting": [[ 1, "asc" ]],
		"oLanguage": {
			"sEmptyTable": "<p align='center'>No triggers defined<br></p>"
		},
		"aoColumns": [
			{ "sWidth": "20px" },
			{"sClass": "text-left"},
			{"sClass": "text-left"},
			{"sClass": "text-left"},
			{ "sWidth": "100px" }
			]		
	});

	var rtable = $('#reportsTable').dataTable({
		"bJQueryUI": true,
		"bPaginate": false,
		"bFilter": false,
		"bLengthChange": false,
		"sScrollY": '220px',
		"bStateSave": false,
		'bAutoWidth': false,
		"aaSorting": [[ 1, "asc" ]],
		"oLanguage": {
			"sEmptyTable": "<p align='center'>No reports scheduled<br></p>"
		},
		"aoColumns": [
			{ "sWidth": "20px" },
			{"sClass": "text-left"},
			{"sClass": "text-left"},
			{"sClass": "text-left"},
			{ "sWidth": "100px" }
			]		
	});

	$("#tabs").tabs();
	$("#tabs").tabs({
		activate: function( event, ui ) {
			if(ui.newTab.index() == 1)
				rtable.fnAdjustColumnSizing();
			if(ui.newTab.index() == 2)
				ttable.fnAdjustColumnSizing();
		}
	});
	$("#tabs").tabs("option", "active", $("#subtab").val());	

	$('#smtpForm :input').change(function() {
		smtpFormDirty = true;
	});
  
	$('#smtpForm').on("submit", function(){
		showProgress("Applying SMPT settings");
		var formData = $("#smtpForm").serialize();
		$.post("rest?method=updateEmail", formData, function(data) {
			doneProgress(data.response, true);
			smtpFormDirty = false;
		}, "json")
		.fail(function(xhr){
			json = jQuery.parseJSON(xhr.responseText);
			doneProgress(json.error, false);
		})

		return false;
	});

	$("a#testEmail").on("click", null, function(){
		var emailTo = prompt("Enter e-mail address for a test message:", localStorage.getItem('emailTo') || $("input#emailAccount").val());
		if(emailTo == null)
			return;
		
		localStorage.setItem('emailTo', emailTo);
		
		if(smtpFormDirty){
			showProgress("Applying SMTP settings and sending test email to " + emailTo);
			var formData = $("#smtpForm").serialize();
			$.post("rest?method=updateEmail", formData, function() {
				smtpFormDirty = false;
				
				$.post("rest?method=testEmail&email="+emailTo, null, function(data) {
					doneProgress(data.response, true);
				}, "json")
				.fail(function(xhr){
					json = jQuery.parseJSON(xhr.responseText);
					doneProgress(json.error, false);
				})
				
			}, "json")
			.fail(function(xhr){
				json = jQuery.parseJSON(xhr.responseText);
				doneProgress(json.error, false);
			})
	
			return;
		}
		
		showProgress("Sending test email to " + emailTo);
		$.post("rest?method=testEmail&email="+emailTo, null, function(data) {
			doneProgress(data.response, true);
		}, "json")
		.fail(function(xhr){
			json = jQuery.parseJSON(xhr.responseText);
			doneProgress(json.error, false);
		})
	});

	$("#radd").on('click', null, function(event) {
		$.post("rest?method=addReport", null, function(data) {
			window.location.href = "/report?id=" + data.id;
		}, "json")
		.fail(function(xhr){
			json = jQuery.parseJSON(xhr.responseText);
			alert(json.error); 
		})
	});

	$("a.renable").on('click', null, function(event) {
		var id = getID($(this));
		var row = getRow($(this));
		$.post("rest?method=enable&object=report&id="+id, null, function(data, textStatus, xhr) {
			var report = data.object;
			var img = row.find(".renabled img");
			img.attr("title", report.enabled ? "Enabled" : "Disabled");
			img.attr("src", report.enabled ? "images/enabled.gif" : "images/exclude.gif");
			img = row.find(".renable img");
			img.attr("title", report.enabled ? "Pause" : "Resume");
			img.attr("src", report.enabled ? "images/pause.gif" : "images/run.gif");
		}, "json")
		.fail(function(xhr){
			json = jQuery.parseJSON(xhr.responseText);
			alert(json.error); 
		})
	});

	$("#r-enable-all").on('click', null, function(event) {
		var id = getID($(this));
		$.post("rest?method=enableAll&object=report&enable=true", null, function(data, textStatus, xhr) {
			window.location.href = "/notificationsTab?subtab=1";
		}, "json")
		.fail(function(xhr){
			json = jQuery.parseJSON(xhr.responseText);
			alert(json.error); 
		})
	});

	$("#r-disable-all").on('click', null, function(event) {
		var id = getID($(this));
		$.post("rest?method=enableAll&object=report&enable=false", null, function(data, textStatus, xhr) {
			window.location.href = "/notificationsTab?subtab=1";
		}, "json")
		.fail(function(xhr){
			json = jQuery.parseJSON(xhr.responseText);
			alert(json.error); 
		})
	});

	$("a.rtest").on('click', null, function(event) {
		if(confirm("This will execute the query and deliver report email to specified recipients\nThe same action will be performed when report gets triggered by cron in real life.\n\nProceed?") != true)
			return;

		var id = getID($(this));
		showProgress("Executing report and sending email");
		$.post("rest?method=testReport&id="+id, null, function(data, textStatus, xhr) {
			doneProgress(data.response, true);
		}, "json")
		.fail(function(xhr){
			json = jQuery.parseJSON(xhr.responseText);
			doneProgress(json.error, false);
		})
	});

	$("a.redit").on('click', null, function(event) {
		var id = getID($(this));
		window.location.href = "/report?id=" + id;
	});

	$("a.rclone").on('click', null, function(event) {
		var id = getID($(this));
		$.post("rest?method=addReport&id="+id, null, function(data, textStatus, xhr) {
			window.location.href = "/report?id=" + data.id;
		}, "json")
		.fail(function(xhr){
			json = jQuery.parseJSON(xhr.responseText);
			alert(json.error); 
		})
	});

	$("a.rremove").on('click', null, function(event) {
		if(confirm("Remove this report") != true)
			return;
		var id = getID($(this));
		$.post("rest?method=remove&object=report&id="+id, function(data, textStatus, xhr) {
			window.location.href = "/notificationsTab?subtab=1";
		}, "json")
		.fail(function(xhr){
			json = jQuery.parseJSON(xhr.responseText);
			alert(json.error); 
		})
	});

	$("#tadd").on('click', null, function(event) {
		var id = getID($(this));
		$.post("rest?method=addTrigger", null, function(data, textStatus, xhr) {
			window.location.href = "/trigger?id=" + data.id;
		}, "json")
		.fail(function(xhr){
			json = jQuery.parseJSON(xhr.responseText);
			alert(json.error); 
		})
	});

	$("#t-enable-all").on('click', null, function(event) {
		var id = getID($(this));
		$.post("rest?method=enableAll&object=trigger&enable=true", null, function(data, textStatus, xhr) {
			window.location.href = "/notificationsTab?subtab=2";
		}, "json")
		.fail(function(xhr){
			json = jQuery.parseJSON(xhr.responseText);
			alert(json.error); 
		})
	});

	$("#t-disable-all").on('click', null, function(event) {
		var id = getID($(this));
		$.post("rest?method=enableAll&object=trigger&enable=false", null, function(data, textStatus, xhr) {
			window.location.href = "/notificationsTab?subtab=2";
		}, "json")
		.fail(function(xhr){
			json = jQuery.parseJSON(xhr.responseText);
			alert(json.error); 
		})
	});

	$("#t-ack-alerts").on('click', null, function(event) {
		$.post("rest?method=enableAll&object=alert&enable=false", null, function(data, textStatus, xhr) {
			window.location.href = "/notificationsTab?subtab=2";
		}, "json")
		.fail(function(xhr){
			json = jQuery.parseJSON(xhr.responseText);
			alert(json.error); 
		})
	});

	$("a.tenable").on('click', null, function(event) {
		var id = getID($(this));
		var row = getRow($(this));
		$.post("rest?method=enable&object=trigger&id="+id, null, function(data, textStatus, xhr) {
			var trigger = data.object;
			var img = row.find(".tenabled img");
			img.attr("title", trigger.enabled ? "Enabled" : "Disabled");
			img.attr("src", trigger.enabled ? "images/enabled.gif" : "images/exclude.gif");
			img = row.find(".tenable img");
			img.attr("title", trigger.enabled ? "Pause" : "Resume");
			img.attr("src", trigger.enabled ? "images/pause.gif" : "images/run.gif");
			
			var alert = row.find(".talert");
			alert.removeClass('text-warn');
			if(trigger.alerts)
				alert.addClass('text-warn');
		}, "json")
		.fail(function(xhr){
			json = jQuery.parseJSON(xhr.responseText);
			alert(json.error); 
		})
	});

	$("a.tedit").on('click', null, function(event) {
		var id = getID($(this));
		window.location.href = "/trigger?id=" + id;
	});

	$("a.tclone").on('click', null, function(event) {
		var id = getID($(this));
		$.post("rest?method=addTrigger&id="+id, null, function(data, textStatus, xhr) {
			window.location.href = "/trigger?id=" + data.id;
		}, "json")
		.fail(function(xhr){
			json = jQuery.parseJSON(xhr.responseText);
			alert(json.error); 
		})
	});

	$("a.tremove").on('click', null, function(event) {
		if(confirm("Remove this trigger?") != true)
			return;
		var id = getID($(this));	
		$.post("rest?method=remove&object=trigger&id="+id, function(data, textStatus, xhr) {
			window.location.href = "/notificationsTab?subtab=2";
		}, "json")
		.fail(function(xhr){
			json = jQuery.parseJSON(xhr.responseText);
			alert(json.error); 
		})
	});

	function getID(el){
		return $(el).parent().parent().find(".id").val();
	}

	function getRow(el){
		return $(el).parent().parent();
	}

});
