$(document).ready(function() {
	$.ajaxSetup ({  
	    cache: false  
	}); 

	var ttable = $('#errorsTable').dataTable({
		"bJQueryUI": true,
		"bPaginate": false,
		"bFilter": false,
		"bLengthChange": false,
		"sScrollY": '220px',
		"bStateSave": false,
		'bAutoWidth': true,
		"oLanguage": {
			"sEmptyTable": "<p align='center'>No errors<br></p>"
		},
		"aoColumns": [
		            { "sWidth": "130px", "sClass": "text-left" },
		            { "sWidth": "50px"},
		            {"sClass": "text-left"},
		          ]		
	});
	
	$('a#reset').on('click', null, function(event) {
		callService("resetErrors", "Reset last errors?", function(){
			window.location.href = "/home";
		});
	});

	$('a#getlog').on('click', null, function(event) {
		callService("getlog");
	});
	
	function callService(what, question, done){
		if(question != null && !confirm(question))
			return;
		showProgress("Operation is in progress...");
		$.get("rest?method=control&what="+what, function(data, textStatus, xhr) {
			if(data.link != null){
				doneProgress("<a href='" + data.link + "' target='new'>click here to download</a>", true);
				return;
			}
			closeProgress();
			if(done)
				done();
			
		}, "json")
		.fail(function(xhr){
			json = jQuery.parseJSON(xhr.responseText);
			doneProgress(json != null ? json.error: "Server call failed", false);
		})
	}
});
