$(document).ready(function() {
	$("#tabs").tabs();
	$("#tabs").tabs("option", "active", $("#subtab").val());	
	
	var partitionWarn = false;
	var citeria = new Criteria();
	citeria.show($('div#criteria'), $('input#json'));

   $("a#newMongo").on("click", null, function(){
	   $("select#collection").prop("disabled", false);
	   $('select#collection').val("Regular collection");
	   $("tr#cappedSize").hide();
	   $("tr#ttlSize").hide();
	   $("tr#partitionSize").hide();
	   $("input#cappedSize").prop("disabled", false);
	   $("input#ttlSize").prop("disabled", false);
	   $("input#partitionSize").prop("disabled", false);
	   
	   $("input#databaseName").prop("disabled", false);
	   $("input#databaseName").val("new-database-name");
	   $("input#databaseName").focus();
	   $("input#databaseName").select();
	   $("input#newmongo").val("true");
	   console.log($("input#newmongo").val());
	   
	   $("#apply").val("Create database");
	   return true;
   });
	
	$('select#auth').on("change", function() {
	   if ($(this).val() == "Yes"){
		 $("tr#userName").show();
		 $("tr#password").show();
		 $("tr#userDB").show();
		 $("input#userName").val("userName");
		 $("input#userName").focus();
		 $("input#userName").select();
		 $("input#password").val("password");
		 $("input#userDB").val("admin");
	   }
	   else{
		 $("tr#userName").hide();
		 $("tr#password").hide();
		 $("tr#userDB").hide();
		 $("#userName").val("");
		 $("#password").val("");
	   }
	});	

	$('select#collection').on("change", function() {
	   if($(this).val() == "Regular collection"){
		   $("tr#cappedSize").hide();
		   $("tr#ttlSize").hide();
		   $("tr#partitionSize").hide();
	   }
	   else if($(this).val() == "Capped collection"){
		   $("tr#cappedSize").show();
		   $("input#cappedSize").val("100");
		   $("input#cappedSize").focus();
		   $("input#cappedSize").select();
		   $("tr#ttlSize").hide();
		   $("input#ttlSize").val("");
		   $("tr#partitionSize").hide();
		   $("input#partitionSize").val("");
	   }
	   else if($(this).val() == "TTL collection"){
		   $("tr#cappedSize").hide();
		   $("input#cappedSize").val("");
		   $("tr#partitionSize").hide();
		   $("input#partitionSize").val("");
		   $("tr#ttlSize").show();
		   $("input#ttlSize").val("7");
		   $("input#ttlSize").focus();
		   $("input#ttlSize").select();
	   }
	   else if($(this).val() == "Partitioned store"){
		   $("tr#cappedSize").hide();
		   $("input#cappedSize").val("");
		   $("tr#ttlSize").hide();
		   $("input#ttlSize").val("");
		   $("tr#partitionSize").show();
		   $("input#partitionSize").val("1");
		   $("input#partitionSize").focus();
		   $("input#partitionSize").select();
		   partitionWarn = true;
	   }
	});	

	$('select#capacity').on("change", function() {
		if($(this).val() == "Custom"){
			$("tr#retentionDays").show();
		}
		else{
			$("tr#retentionDays").hide();
		}
	});	
	
	$('#dbForm').on("submit", function(){
		$("#progress .message").html("Please stand by...");
		$("#progress").dialog( "option", "title", "Updating");
		$("#progress").dialog("open");
	    
	    var formData = $('#dbForm').serialize();	
		$.post("rest?method=updateDb", formData, function(data, textStatus, xhr) {
		   window.location.href = "databaseTab?subtab=general";
		}, "json")
		.fail(function(xhr){ 
		    $("#progress").dialog("close");
			json = jQuery.parseJSON(xhr.responseText);
			alert(json.error); 
			window.location.href = "databaseTab?subtab=general";
		})
	    	
    	return false;
	});

	$('#mongoForm').on("submit", function(){
		if(partitionWarn && $('select#collection').val() == "Partitioned store"){
	    	if(!confirm("Switching to a partitioned store will automatically drop all\npreviously created partitions (if found).\n\nOK to proceed?")){
	    		return false;
	    	}
	    }
	    	
		$("#progress .message").html("Please stand by...");
		$("#progress").dialog( "option", "title", "Updating");
		$("#progress").dialog("open");
	    
	    var formData = $("#mongoForm").serialize();	
		$.post("rest?method=updateMongo", formData, function(data, textStatus, xhr) {
		   window.location.href = "databaseTab?subtab=mongo";
		}, "json")
		.fail(function(xhr){ 
		    $("#progress").dialog("close");
			json = jQuery.parseJSON(xhr.responseText);
			alert(json.error); 
			window.location.href = "databaseTab?subtab=mongo";
		})
	    	
    	return false;
	});

	$('#bqForm').on("submit", function(){
		$("#progress .message").html("Please stand by...");
		$("#progress").dialog( "option", "title", "Updating");
		$("#progress").dialog("open");
	    
	    var formData = new FormData();
	    var file = $('#bqForm input#credentials')[0].files[0];
	    formData.append("subtab", "bq");
	    formData.append("project", $('#bqForm input#project').val());
	    formData.append("dataset", $('#bqForm input#dataset').val());
	    formData.append("location", $('#bqForm input#location').val());
	    formData.append("credentials", file);
	    formData.append("writeapi", $('#bqForm select#writeapi').val());
	    formData.append("pool", $('#bqForm input#pool').val());
	    
		$.ajax({
	          url: "rest?method=updateBQ",
	          type: "POST",
	          data: formData,
	          async: true,
	          cache: false,
	          contentType: false,
	          processData: false,
	          success: function(data) {
	  			doneProgress(data.response.message, data.response.rc, function(){
	  				window.location.href = "databaseTab?subtab=bq";	
				});
	          },
	          error: function(xhr) {
	  			json = jQuery.parseJSON(xhr.responseText);
		  		doneProgress(json, false, function(){
		  			window.location.href = "databaseTab?subtab=bq";
				});
	          }
	    });
	    
    	return false;
	});
	
	$('#formCriteria').on("submit", function(){
		$("#progress .message").html("Please stand by...");
		$("#progress").dialog( "option", "title", "Updating");
		$("#progress").dialog("open");
	    
		citeria.makeJson();
	    var formData = $('#formCriteria').serialize();	
		$.post("rest?method=updateDbCriteria", formData, function(data, textStatus, xhr) {
		   window.location.href = "databaseTab?subtab=criteria";
		}, "json")
		.fail(function(xhr){ 
		    $("#progress").dialog("close");
			json = jQuery.parseJSON(xhr.responseText);
			alert(json.error); 
			window.location.href = "databaseTab?subtab=criteria";
		})
	    	
    	return false;
	});

   $(".tipped").tooltip({
	    bodyHandler: function() {
	    	return $(this).find(".tip").html(); 
	    }, 	   
	    track: true, 
	    delay: 0, 
	    fade: 0,
	    position: { my: "center center", at: "center center" }
	});
   
   $("#undo").on("click", null, function(){
 	  window.location.href = "/databaseTab?subtab=mongo";	         
      return true;
   });   
});
