$(document).ready(function() {
	var log4jNote = "<i class='fa fa-plug text-side'></i> <b>Socket</b> receivers work over live TCP or UDP sockets against appenders in real time directly from your applications. These receivers can work in different data formats."
	var webNote = "<i class='fa fa-globe text-side'></i> <b>Web</b> receivers can be POST'ed to directly with log data from anywhere. Tecnically each web receiver corresponds to a mapped servlet in logFaces web server."
	var tlog4jNote ="<i class='fa fa-plug text-side'></i> <b>Socket</b> receivers expect input in currently specified format. Paste your sample below and click Send:"
	var syslogNote = "<i class='fa fa-microchip text-side'></i> <b>Syslog</b> receivers work over live TCP or UDP sockets and can be used with any standard syslog source."
	var tsyslogNote = "<i class='fa fa-microchip text-side'></i> <b>Syslog</b> receivers expect input in <a href='https://tools.ietf.org/html/rfc5424' target='new'>RFC5424</a> or <a href='https://tools.ietf.org/html/rfc3164' target='new'>RFC3164</a> format. Paste your sample below and click Send:"
	var dzNote = "<i class='fa fa-folder-open text-side'></i> <b>Drop zone</b> is a directory where you can drop raw text files for import into logFaces database.";
	var tdzNote = "<i class='fa fa-folder-open text-side'></i> <b>Drop zone</b> receivers will parse the input using its regular expressions. Paste your sample below and click Send:";

	window.setTimeout(function() {
		 updatePairStates();
	}, 3000);
	
	var rxtable = $('#rxtable').dataTable({
		"bJQueryUI": true,
		"bPaginate": false,
		"bFilter": false,
		"bLengthChange": false,
		"sScrollY": '180px',
		"bStateSave": false,
		"aaSorting": [[ 3, "asc" ]],
		"oLanguage": {
			"sEmptyTable": "<p align='center'>No receivers<br></p>"
		},
		"aoColumns": [
			            {"sWidth": "20px", "bSortable": false},
			            {"sClass": "text-left", "sWidth": "60px", "bSortable": false},
			            {"sClass": "text-left", "sWidth": "80px", "bSortable": false},
			            {"sClass": "text-left", "bSortable": false},
			            {"sClass": "text-left", "bSortable": false},
			            {"sClass": "text-left", "sWidth": "80px",  "bSortable": false}
			          ]		
	});

	var fdtable = $('#fdstable').dataTable({
		"bJQueryUI": true,
		"bPaginate": false,
		"bFilter": false,
		"bLengthChange": false,
		"sScrollY": '180px',
		"bStateSave": false,
		"aaSorting": [[ 1, "asc" ]],
		"oLanguage": {
			"sEmptyTable": "<p align='center'>No flood detectors defined<br></p>"
		},
		"aoColumns": [
			            {"sWidth": "20px", "bSortable": false},
			            {"sClass": "text-left", "bSortable": false},
			            {"sClass": "text-left", "sWidth": "60px", "bSortable": false},
			            {"sClass": "text-left", "sWidth": "60px", "bSortable": false},
			            {"sClass": "text-left", "sWidth": "60px", "bSortable": false},
			            {"sClass": "text-left", "sWidth": "100px",  "bSortable": false}
			          ]		
	});
	
	var ptable = $('#pairs').dataTable({
		"bJQueryUI": true,
		"bPaginate": false,
		"bFilter": false,
		"bLengthChange": false,
		"sScrollY": '100px',
		"bStateSave": false,
		"oLanguage": {
			"sEmptyTable": "<p align='center'>No pairs defined for this server<br></p>"
		},
		"aoColumns": [
            {"sWidth": "20px", "bSortable": false},
            {"sClass": "text-left", "bSortable": false},
            {"sClass": "text-left", "sWidth": "60px", "bSortable": false},
            {"sClass": "text-left", "sWidth": "60px", "bSortable": false},
            {"sClass": "text-left", "sWidth": "140px", "bSortable": false},
          ]		
		
	});
	
   $("#tabs").tabs();
   $("#tabs").tabs({
		activate: function( event, ui ) {
			if(ui.newTab.index() == 1)
				rxtable.fnAdjustColumnSizing();
			if(ui.newTab.index() == 3)
				fdtable.fnAdjustColumnSizing();
			if(ui.newTab.index() == 4)
				ptable.fnAdjustColumnSizing();
		}
   });
   $("#tabs").tabs("option", "active", $("#subtab").val());
	
   $("a#newLog4jRx").on("click", null, function(){
		$.get("rest?method=getReceiverOptions&type=log4j", function(data, textStatus, xhr) {
			populateRxOptions(data.options);
			$("#rxDialog #rxForm #type").val("log4j");
			$("#rxDialog #rxForm #id").val("");
		    $("#rxDialog .formNote").html(log4jNote);
		    $("#rxDialog").dialog( "option", "title", "Add new socket receiver");
		    $("#rxDialog").dialog( "option", "width", "640");
		    $("#rxDialog").dialog( "option", "height", "520");
			$("#rxDialog").dialog( "open" );
			
		}, "json")
		.fail(function(xhr){
			json = jQuery.parseJSON(xhr.responseText);
			alert(json.error); 
		})
   });

   $("a#newWebRx").on("click", null, function(){
		$.get("rest?method=getReceiverOptions&type=servlet", function(data, textStatus, xhr) {
			populateRxOptions(data.options);
			$("#rxDialog #rxForm #type").val("servlet");
			$("#rxDialog #rxForm #id").val("");
		    $("#rxDialog .formNote").html(webNote);
		    $("#rxDialog").dialog( "option", "title", "Add new web receiver");
		    $("#rxDialog").dialog( "option", "width", "640");
		    $("#rxDialog").dialog( "option", "height", "520");
			$("#rxDialog").dialog( "open" );
			
		}, "json")
		.fail(function(xhr){
			json = jQuery.parseJSON(xhr.responseText);
			alert(json.error); 
		})
  });
   
   $("a#newSyslogRx").on("click", null, function(){
		$.get("rest?method=getReceiverOptions&type=syslog", function(data, textStatus, xhr) {
			populateRxOptions(data.options);
			$("#rxDialog #rxForm #type").val("syslog");
			$("#rxDialog #rxForm #id").val("");
		    $("#rxDialog .formNote").html(syslogNote);
		    $("#rxDialog").dialog("option", "title", "Add new syslog receiver");
		    $("#rxDialog").dialog("option", "width", "680");
		    $("#rxDialog").dialog("option", "height", "540");
			$("#rxDialog" ).dialog("open" );
		}, "json")
		.fail(function(xhr){
			json = jQuery.parseJSON(xhr.responseText);
			alert(json.error); 
		})
  });
   
   $("a#newDropzoneRx").on("click", null, function(){
		$.get("rest?method=getReceiverOptions&type=dropzone", function(data, textStatus, xhr) {
			populateDxOptions(data.options);
			$("#rxDialog #rxForm #type").val("dropzone");
			$("#rxDialog #rxForm #id").val("");
		    $("#rxDialog .formNote").html(dzNote);
		    $("#rxDialog").dialog( "option", "title", "Add new drop zone");
		    $("#rxDialog").dialog( "option", "width", "860");
		    $("#rxDialog").dialog( "option", "height", "510");
			$("#rxDialog").dialog( "open" );
		}, "json")
		.fail(function(xhr){
			json = jQuery.parseJSON(xhr.responseText);
			alert(json.error); 
		})
   });

   function populateRxOptions(options){
	   var table = $("#rxDialog #rxForm #options");
	   $(table).empty();
	   table = $("<tbody/>").appendTo(table);
	   for(i=0;i<options.length;i++){
		   var row = $("<tr/>").appendTo(table);
		   var td = $("<td style='width: 100px;'/>").appendTo(row);
		   if(options[i].helpID != null)
			   td.append("<a class='help' title='Click for explanation' id='" + options[i].helpID + "' href='#'>" + options[i].display + "</a>");
		   else
			   td.append(options[i].display);
		   
		   td = $("<td/>").appendTo(row);
		   if(options[i].choices == null){
			   $("<input name='" + options[i].name + "' type='text' value=\"" + options[i].value + "\" style='width: 100%'/>").appendTo(td);
		   }
		   else{
			   var select  = $("<select style='width: 100%;' name='" + options[i].name + "'/>").appendTo(td);
			   for(j=0;j<options[i].choices.length;j++){
					var option = $('<option>' + options[i].choices[j] + '</option>').appendTo(select);
					option.attr('value', options[i].choices[j]);
					if(options[i].value == options[i].choices[j])
						option.attr('selected', 'selected');
			   }
		   }
		   $("<td style='width: 30%;'>" + options[i].description + "</td>").appendTo(row);
	   }
   }

   function populateDxOptions(options){
	   var table = $("#rxDialog #rxForm #options");
	   $(table).empty();
	   table = $("<tbody/>").appendTo(table);
	   for(i=0;i<options.length;i++){
		   var row = $("<tr/>").appendTo(table);
		   var td = $("<td style='width: 100px;'/>").appendTo(row);
		   if(options[i].helpID != null)
			   td.append("<a class='help' title='Click for explanation' id='" + options[i].helpID + "' href='#'>" + options[i].display + "</a>");
		   else
			   td.append(options[i].display);

		   td = $("<td/>").appendTo(row);
		   if(options[i].choices == null){
			   $("<input name='" + options[i].name + "' type='text' value=\"" + options[i].value + "\" style='width: 100%'/>").appendTo(td);
		   }
		   else{
			   var select  = $("<select style='width: 100%;' name='" + options[i].name + "'/>").appendTo(td);
			   for(j=0;j<options[i].choices.length;j++){
					var option = $('<option>' + options[i].choices[j] + '</option>').appendTo(select);
					option.attr('value', options[i].choices[j]);
					if(options[i].value == options[i].choices[j])
						option.attr('selected', 'selected');
			   }
		   }
	   }
   }
   
   $("a#syspattern").on("click", null, function(){
	    $("#helpDialog ").dialog( "option", "height", "350");
	    $("#helpDialog ").dialog( "option", "width", "500");
	    $("#helpDialog .formNote").html(sptHelp);
	    $("#helpDialog").dialog( "option", "title", "Help");
		$("#helpDialog" ).dialog( "open" );
  });

   $("a.testRx").on("click", null, function(){
	    var id = getRxParam($(this), ".id");
	    var type = getRxParam($(this), ".type");
	    var message = $.cookie('lfs-rx-test');
	    
	    if(type=="log4j")
		    $("#testDialog .formNote").html(tlog4jNote);
	    else if(type=="syslog")
	    	$("#testDialog .formNote").html(tsyslogNote);
	    else if(type=="dropzone")
	    	$("#testDialog .formNote").html(tdzNote);

	    $("#testDialog #testForm #id").val(id);
	    
	    if(message)
	    	$("#testForm #message").val(message);
	    else
	    	generateMessage();
	    
	    $("#testDialog").dialog( "option", "title", "Send testing event to receiver");
		$("#testDialog" ).dialog( "open" );
   });

   function showTestResult(event){
	   $("#helpDialog ").dialog( "option", "height", "500");
	   $("#helpDialog ").dialog( "option", "width", "500");
	   $("#helpDialog .formNote").html("<pre>" + event + "</pre>");
	   $("#helpDialog").dialog( "option", "title", "Result");
	   $("#helpDialog" ).dialog( "open" );
   }
   
  $("a.removeRx").on("click", null, function(){
		if(confirm("Remove this receiver?") == false)
			return;
		var id = getRxParam($(this), ".id");
		$.post("rest?method=remove&object=receiver&id="+id, function(data, textStatus, xhr) {
			window.location.href = "/connectivityTab?subtab=1";
		}, "json")
		.fail(function(xhr){
			json = jQuery.parseJSON(xhr.responseText);
			alert(json.error); 
		})
  });

  $("a.controlRx").on("click", null, function(){
		var id = getRxParam($(this), ".id");
        var row = getRow($(this));
		$("#progress .message").html("Adjusting receiver, please stand by...");
		$("#progress").dialog( "option", "title", "Progress");
		$("#progress").dialog("open");
		
		$.post("rest?method=enable&object=receiver&id="+id, function(data, textStatus, xhr) {
			$("#progress").dialog("close");

			var rx = data.object;
			var img = row.find(".enabledRx img");
			img.attr("title", rx.active ? "Active" : "Disabled");
			img.attr("src", rx.active ? "images/enabled.gif" : "images/exclude.gif");
			img = row.find(".controlRx img");
			img.attr("title", rx.active ? "Pause" : "Resume");
			img.attr("src", rx.active ? "images/pause.gif" : "images/run.gif");
			
		}, "json")
		.fail(function(xhr){
			$("#progress").dialog("close");
			json = jQuery.parseJSON(xhr.responseText);
			alert(json.error); 
		})
  });

  $("a.editRx").on("click", null, function(){
		var id = getRxParam($(this), ".id");
	    var type = getRxParam($(this), ".type")

		$("#rxDialog #rxForm #id").val(id);
		$("#rxDialog").dialog( "option", "title", getRxParam($(this), ".desc"));
	    if(type=="log4j" || type=="servlet"){
		    $("#rxDialog .formNote").html(log4jNote);
	    	$("#rxDialog").dialog( "option", "width", "640");
	    	$("#rxDialog").dialog( "option", "height", "520");
	    }
	    else if(type=="syslog"){
	    	$("#rxDialog .formNote").html(syslogNote);
	    	$("#rxDialog").dialog( "option", "width", "680");
	    	$("#rxDialog").dialog( "option", "height", "540");
	    }
	    else if(type=="dropzone"){
	    	$("#rxDialog .formNote").html(dzNote);
	    	$("#rxDialog").dialog( "option", "width", "860");
	    	$("#rxDialog").dialog( "option", "height", "510");
	    }
	    
		$.get("rest?method=getReceiverOptions&id="+id, function(data, textStatus, xhr) {
			if(type == "dropzone"){
				populateDxOptions(data.options);
			}
			else
				populateRxOptions(data.options);
			$("#rxDialog").dialog( "open" );
			
		}, "json")
		.fail(function(xhr){
			json = jQuery.parseJSON(xhr.responseText);
			alert(json.error); 
		})
  });
  
  function getRxParam(el, name){
	  return $(el).parent().parent().find(name).html();
  }
  
   $( "#rxDialog" ).dialog({
		autoOpen: false,
		height: 350,
		width: 450,
		modal: true,
		buttons: {
			"OK": function() {
				$("#progress .message").html("Setting up receiver, please stand by...");
				$("#progress").dialog( "option", "title", "Progress");
				$("#progress").dialog("open");
				
				var formData = $("#rxForm").serialize();
				$.post("rest?method=addReceiver", formData, function(data, textStatus, xhr) {
					$("#progress").dialog("close");
					$("#rxDialog").dialog("close");
					window.location.href = "/connectivityTab?subtab=1";
				}, "json")
				.fail(function(xhr) { 
					$("#progress").dialog("close");
					json = jQuery.parseJSON(xhr.responseText);
					alert(json.error); 
				})
			},
			Cancel: function() {
				$( this ).dialog( "close" );
			}
		},
		close: function() {
		}
	});   
   
   $( "#testDialog" ).dialog({
		autoOpen: false,
		height: 450,
		width: 600,
		modal: true,
		buttons: {
			"Make test message": function(){
				generateMessage();
			},
			"Send": function() {
				$("#progress .message").html("Message sent, please stand by...");
				$("#progress").dialog( "option", "title", "Testing");
				$("#progress").dialog("open");
				
				$.cookie('lfs-rx-test', $("#testForm #message").val())
				var formData = $("#testForm").serialize();
				$.post("rest?method=testReceiver", formData, function(data, textStatus, xhr) {
					$("#progress").dialog("close");
					showTestResult(data.event);
				}, "json")
				.fail(function(xhr) { 
					$("#progress").dialog("close");
					json = jQuery.parseJSON(xhr.responseText);
					alert(json.error); 
				})

				$(this).dialog( "close" );
				
			},
			Cancel: function() {
				$( this ).dialog( "close" );
			}
		},
		close: function() {
		}
	});

	function generateMessage(){
		var rxid = $("#testDialog #testForm #id").val();
		$.get("rest?method=generateTestMessage&id="+rxid, function(data, textStatus, xhr) {
			if(data.message){
				$("#testForm #message").val(data.message);
			}
		}, "json")
		.fail(function(xhr){
			json = jQuery.parseJSON(xhr.responseText);
			alert(json.error); 
		})
	}
   
    handleAdminPwd();
	$('select#adminDelegate').on("change", function(){
		handleAdminPwd();
	});

	$("a#addBouncer").on("click", null, function(){
	   $("#helpDialog .formNote").html("Coming soon, please check on us later!");
	   $("#helpDialog").dialog( "option", "title", "New bouncer");
       $("#helpDialog").dialog( "option", "height", "200");
	   $("#helpDialog").dialog( "open" );
	});
   
	$("a#addPair").on("click", null, function(){
	    $("#pairForm #pairPort").val("8050");
	    $("#pairForm #pairSsl").val("no");
	    $("#pairDialog").dialog("option", "title", "Add paired node");
		$("#pairDialog").dialog("open" );
	});
   
	$("a#unpair").on("click", null, function(){
		if(confirm("Un-pair all nodes from this server?") != true)
			return;
			
		$("#progress .message").html("One moment...");
		$("#progress").dialog( "option", "title", "Removing pairs");
		$("#progress").dialog("open");
			
		$.post("rest?method=unpair", null, function(data, textStatus, xhr) {
		    $("#progress").dialog("close");
			window.location.href = "/connectivityTab?subtab=4";
		}, "json")
		.fail(function(xhr) { 
		    $("#progress").dialog("close");
			json = jQuery.parseJSON(xhr.responseText);
			alert(json.error); 
		})
			
	});
	
	$("a.editPair").on("click", null, function(){
		var pairHost = getRxParam($(this), ".pairHost");
		var pairPort = getRxParam($(this), ".pairPort");
		var pairSsl = getRxParam($(this), ".pairSsl");
		$("#pairForm #id").val(pairHost);
	    $("#pairForm #pairHost").val(pairHost);
	    $("#pairForm #pairPort").val(pairPort);
	    $("#pairForm #pairSsl").val(pairSsl);
	    $("#pairDialog").dialog( "option", "title", "Update paired node");
		$("#pairDialog").dialog( "open" );
	});
	
	$("a.removePair").on("click", null, function(){
		var pairHost = getRxParam($(this), ".pairHost");
		if(confirm("Un-pair " + pairHost + "?") != true)
			return;
			
		$.post("rest?method=unpair&pairHost=" + pairHost, null, function(data, textStatus, xhr) {
		    $("#progress").dialog("close");
			window.location.href = "/connectivityTab?subtab=4";
		}, "json")
		.fail(function(xhr) { 
		    $("#progress").dialog("close");
			json = jQuery.parseJSON(xhr.responseText);
			alert(json.error); 
		})
	});

	$("[class^=syncPair]").on("click", null, function(){
		var pairHost = getRxParam($(this), ".pairHost");
		if(confirm("Deploy configuration from this node to " + pairHost + "?") != true)
			return;
			
		showProgress("Configuring paired node at " + pairHost + ", it will be restarted shortly, please stand by.");
		$.post("rest?method=syncPairConfig&pairHost=" + pairHost, null, function(data, textStatus, xhr) {
			doneProgress("Paired node is configured successfully", true);
		}, "json")
		.fail(function(xhr) { 
			doneProgress(jQuery.parseJSON(xhr.responseText).error, false);
		})
	});
	
	$("#pairDialog" ).dialog({
		autoOpen: false,
		height: 360,
		width: 500,
		modal: true,
		buttons: {
			"Save": function() {
				$("#progress .message").html("Setting up the pair, please stand by...");
				$("#progress").dialog( "option", "title", "Pairing");
				$("#progress").dialog("open");
			
				var formData = $("#pairForm").serialize();
				$.post("rest?method=pair", formData, function(data, textStatus, xhr) {
				   $("#progress").dialog("close");
					window.location.href = "/connectivityTab?subtab=4";
				}, "json")
				.fail(function(xhr) { 
				    doneProgress(jQuery.parseJSON(xhr.responseText).error, false, function(){
				    	window.location.href = "/connectivityTab?subtab=4";
				    });
				})

				$(this).dialog( "close" );

			},
			Cancel: function() {
				$( this ).dialog( "close" );
			}
		},
		close: function() {
		}
	});
	
	function updatePairStates(){
		$.get("rest?method=getPairs", function(data, textStatus, xhr) {
			var pairs = data.pairs;
			if(pairs == null || pairs.length == 0)
				return;
			for(var i=0; i<pairs.length; i++){
				if(pairs[i].connected){
					$(".syncPair"+i).show();
					$(".adminPair"+i).show();
				}
				else{
					$(".syncPair"+i).hide();
					$(".adminPair"+i).hide();
				}
				
				var html = pairs[i].connected ? "<img title='node is active' src='images/enabled.gif'/>" : 
                    "<img title='node is offline' src='images/exclude.gif'/>";
				var span = $(".pairState")[i];
				$(span).html(html);
			}
			
			window.setTimeout(function() {
				updatePairStates();
			}, 3000);
			
		}, "json")
		.fail(function(xhr) { 
		    $("#progress").dialog("close");
			json = jQuery.parseJSON(xhr.responseText);
			alert(json.error); 
		})
	}
		
	var citeria = new Criteria();
	citeria.show($('div#criteria'), $('input#json'));
	$('#blc').on("submit", function(){
		$("#progress .message").html("Applying blacklist, please stand by...");
		$("#progress").dialog( "option", "title", "Progress");
		$("#progress").dialog("open");
		
		citeria.makeJson();
		var formData = $("#blc").serialize();
		$.post("rest?method=setBlackList", formData, function(data, textStatus, xhr) {
			$("#progress").dialog("close");
		}, "json")
		.fail(function(xhr) { 
			$("#progress").dialog("close");
			json = jQuery.parseJSON(xhr.responseText);
			alert(json.error); 
		})
	    	
    	return false;
	});

  	$("#fd-add").on("click", null, function(){
  		var id = getID($(this));
		$.post("rest?method=addFloodDetector", null, function(data, textStatus, xhr) {
			window.location.href = "/fd?id=" + data.id;
		}, "json")
		.fail(function(xhr){
			json = jQuery.parseJSON(xhr.responseText);
			alert(json.error); 
		})
  	});

  	$("#fd-enable-all").on("click", null, function(){
  		var id = getID($(this));
		$.post("rest?method=enableAll&object=flood&enable=true", null, function(data, textStatus, xhr) {
			window.location.href = "/connectivityTab?subtab=3";
		}, "json")
		.fail(function(xhr){
			json = jQuery.parseJSON(xhr.responseText);
			alert(json.error); 
		})
  	});

  	$("#fd-disable-all").on("click", null, function(){
  		var id = getID($(this));
		$.post("rest?method=enableAll&object=flood&enable=false", null, function(data, textStatus, xhr) {
			window.location.href = "/connectivityTab?subtab=3";
		}, "json")
		.fail(function(xhr){
			json = jQuery.parseJSON(xhr.responseText);
			alert(json.error); 
		})
  	});
  	
  	$("a.fd-enable").on("click", null, function(){
		var id = getID($(this));
		var row = getRow($(this));
		$.post("rest?method=enable&object=flood&id="+id, null, function(data, textStatus, xhr) {
			var detector = data.object;
			var img = row.find(".fd-enabled img");
			img.attr("title", detector.enabled ? "Active" : "Disabled");
			img.attr("src", detector.enabled ? "images/enabled.gif" : "images/exclude.gif");
			img = row.find(".fd-enable img");
			img.attr("title", detector.enabled ? "Pause" : "Resume");
			img.attr("src", detector.enabled ? "images/pause.gif" : "images/run.gif");
		}, "json")
		.fail(function(xhr){
			json = jQuery.parseJSON(xhr.responseText);
			alert(json.error); 
		})
  	});
	
  	$("a.fd-edit").on("click", null, function(){
  		var id = getID($(this));
  		window.location.href = "/fd?id=" + id;
  	});
  	
  	$("a.fd-clone").on("click", null, function(){
  		var id = getID($(this));
		$.post("rest?method=addFloodDetector&id="+id, null, function(data, textStatus, xhr) {
			window.location.href = "/fd?id=" + data.id;
		}, "json")
		.fail(function(xhr){
			json = jQuery.parseJSON(xhr.responseText);
			alert(json.error); 
		})
  	});
  	
  	$("a.fd-remove").on("click", null, function(){
  		if(confirm("Remove this flood detector?") != true)
  			return;
  		var id = getID($(this));	
		$.post("rest?method=remove&object=flood&id="+id, function(data, textStatus, xhr) {
			window.location.href = "/connectivityTab?subtab=3";
		}, "json")
		.fail(function(xhr){
			json = jQuery.parseJSON(xhr.responseText);
			alert(json.error); 
		})
  	});
  	
  	function getID(el){
  	  return $(el).parent().parent().find(".id").html();
    }
  	
  	function getRow(el){
   	  return $(el).parent().parent();
   	}
  	
	function handleAdminPwd(){
		if($('select#adminDelegate').val() == "ldap")
			$("tr#adminPwd").hide();
		else
			$("tr#adminPwd").show();
	}
});