<%@ include file="header.jsp"%>
<%@ page import="java.util.*"%>
<%@ page import="com.moonlit.logfaces.server.admin.models.*"%>

<script src="scripts/tools.js?v=100720" type="text/javascript"></script>

<%
	Map<?,?> params = (Map<?,?>)request.getAttribute("params");
    int subtab = (Integer)params.get("subtab");
    String patterns = (String)params.get("patterns");
%>

<%@ include file="menu.jsp"%>

<div id="content">
	<div id="main">
		<div id="tabs">
		    <ul>
		        <li><a href="#plib"><span>Patterns library</span></a></li>
		        <li><a href="#debugger"><span>Patterns debugger</span></a></li>
		    </ul>
		    <input id="subtab" type="hidden" value='<%=subtab%>'/>
	
			<div id="plib">	
			    	These regular expression patterns are used globally to match and parse text.
			    	Make sure to preserve the format when you submit changes - names of patterns 
			    	and their expressions must be separated by space. 
			    	Names of patterns should be capitalized for better readability.
			    	Each pattern should fit exactly one line. 
			    	<b><a id='plibhelp' class='help' href='#'>More details</a></b>
				<form id='plibForm' action="">
				    <input name="subtab" type="hidden" value="0"/>
					<p>					    	
						<textarea name="patterns" id='patterns' rows="15" cols="20" wrap="off" spellcheck='false' style="overflow: auto;width: 100%;white-space: pre;"><%=patterns%>
						</textarea>
					</p>
					<div align="center">
						<input type="submit" value="Save"/>
						<input type="reset" value="Undo"/>
					</div>
				</form>
				
			</div>
			
			<div id="debugger">
				Use this tool to test your regular expressions and patterns.
				Enter the expression below, paste a sample text and let server interpret it.
				Once you get the desirable outcome, the pattern is ready to be used.
                <b><a id='pdebughelp' class='help' href='#'>More details</a></b>				
				<form id='testForm' action="">
				    <input name="subtab" type="hidden" value="1"/>
					<p>
						<input placeholder="Pattern to use" name="pattern" type="text" autocomplete="off" style="width: 100%;"/>
					</p>	
					<p>				
						<textarea placeholder="Input to parse" name="input" id='patterns' rows="15" cols="20" wrap='off' spellcheck='false' style="overflow: auto;width: 100%;white-space: nowrap;"></textarea>
					</p>
					<div align="center">
						<input id='testRegex' type="button" value="TEST"/>
					</div>
				</form>
				
			</div>
			
		</div>

		<%@ include file="common-dialogs.jsp"%>	
	
	</div>
</div>
<%@ include file="footer.jsp"%>