<%@ include file="header.jsp"%>
<%@ page import="java.util.*"%>
<%@ page import="com.moonlit.logfaces.server.admin.models.*"%>

<%
	Map params = (Map)request.getAttribute("params");
	List<OptionModel> general = (List<OptionModel>)params.get("general");
	List<OptionModel> mongo = (List<OptionModel>)params.get("mongo");
	List<OptionModel> bq = (List<OptionModel>)params.get("bq");
	String json = ((String)params.get("json"));
	int subtab = (Integer)params.get("subtab");
%>

<script src="scripts/db.js?v=100720" type="text/javascript"></script>

<%@ include file="menu.jsp"%>

<div id="content">
	<div id="main">
		<div id="tabs">
		    <ul>
		        <li><a href="#general-tab"><span>General options</span></a></li>
		        <%if(mongo != null){%>
		        	<li><a href="#mongo-tab"><span>MongoDB options</span></a></li>
		        <%}else if (bq != null){%>
		            <li><a href="#bq-tab"><span>BigQuery integration</span></a></li>
		        <%}%>
		        <li><a href="#citeria-tab"><span>Commit criteria</span></a></li>
		    </ul>
		    
		    <input id="subtab" type="hidden" value='<%=subtab%>'/>

			<div id="general-tab">
				<form id="dbForm">
				    <input name="subtab" type="hidden" value="general"/>
					<table class="listing">
						<%for(OptionModel option : general){%>
						    <%request.setAttribute("option", option);%>
							<jsp:include page="optrow.jsp" />
						<%}%>
					</table>
					
					<br>
					<div align="center">
						<input type="submit" value="Apply"/>
						<input type="reset" value="Undo">
					</div>
				</form>
			</div>	
			
			<%if(mongo != null){%>
			<div id="mongo-tab">
				<i class='fa fa-info-circle fa-lg text-side'></i>
				These integration parameters specify how logFaces instance should use MongoDB database
				in terms of connection, storage type, preferences, etc. This configuration is stored
				in /conf/mongo.properties file on this instance local drive.

				<div class="buttonBar">
					<i class='fa fa-database text-side'></i>&nbsp;
					<a id="newMongo" href="#" title = "Create new MongoDB instance">New database instance</a>
				</div>	
			
				<form id="mongoForm">
					<input name="subtab" type="hidden" value="mongo"/>
					<input name="newmongo" id = "newmongo" type="hidden" value="false"/>
					<table class="listing">
						<%for(OptionModel option : mongo){%>
						    <%request.setAttribute("option", option);%>
						    <% request.setAttribute("width", "40%");%>
							<jsp:include page="optrow.jsp" />
						<%}%>
					</table>
					
					<br>
					<div align="center">
						<input id="apply" type="submit" value="Apply"/>
						<input id="undo" type="button" value="Undo">
					</div>
				</form>
			</div>
			<%}%>

			<%if(bq != null){%>
			<div id="bq-tab">
				<i class='fa fa-info-circle fa-lg text-side'></i>
				We need to know the project, dataset and have your credentials file to 
				communicate with the BigQuery end point. You should be able to obtain 
				this information from your <a target='new' href='https://cloud.google.com/bigquery/what-is-bigquery'>Google Cloud Platform</a> console.
				<br><br> 
				<form id="bqForm" enctype="multipart/form-data">
					<input name="subtab" type="hidden" value="bq"/>
					<table class="listing">
						<%for(OptionModel option : bq){%>
						    <%request.setAttribute("option", option);%>
						    <% request.setAttribute("width", "40%");%>
							<jsp:include page="optrow.jsp" />
						<%}%>
					</table>
					
					<br>
					<div align="center">
						<input id="apply" type="submit" value="Apply"/>
						<input id="undo" type="button" value="Undo">
					</div>
				</form>
			</div>
			<%}%>

			<div id="citeria-tab">
				<i class='fa fa-info-circle fa-lg text-side'></i>
				Events matching the following criteria will be persisted into database. 
				Leave this page blank if you don't want to store anything. 
				Otherwise add rules and conditions below:
				<div class="helpRight">
					<a class='help' id='criteria' href='#'><img src='../images/tip.gif'></img>What is criteria?</a>
				</div>
				<br><br>
				
				<form id="formCriteria">
					<input id="json" name="json" type="hidden" value="<%=json%>"/>
					<input name="subtab" type="hidden" value="criteria"/>
					<div id="criteria" class="criteria"></div>
				
					<br>
					<div align="center">
						<input type="submit" value="Apply"/>
					</div>
				</form>
			</div>
		</div>
	
	    <%@ include file="common-dialogs.jsp"%>	
			
	</div><!--end main DIV -->
</div><!--end content DIV -->
<%@ include file="footer.jsp"%>
