<%@ include file="header.jsp"%>
<%@ page import="java.util.*"%>
<%@ page import="com.moonlit.logfaces.server.log4j.LfsLevel"%>
<%@ page import="com.moonlit.logfaces.server.admin.Helper" %>
<%@ page import="com.moonlit.logfaces.server.admin.models.*"%>

<script src="scripts/context.js?v=100720" type="text/javascript"></script>

<%
	Map params = (Map)request.getAttribute("params");
    Map<Integer,String> mdcMap = (Map<Integer,String>)params.get("mdcNames");
    List<OptionModel> repository = (List<OptionModel>)params.get("repository");
    boolean addMdc = (Boolean)params.get("addMdc");
    boolean removeMdc = (Boolean)params.get("removeMdc");
    String warning = (String)params.get("warning");
	List<LfsLevel> levels = (List<LfsLevel>)params.get("levels"); 
	Object subtab = params.get("subtab");
	String hosts = (String)params.get("hosts");
	List<PluginModel> plugins = (List<PluginModel>)params.get("plugins"); 
	List<PivotNodeModel> pivot = (List<PivotNodeModel>)params.get("pivot");
%>

<%@ include file="menu.jsp"%>

<div id="content">
<div id="main">
	<div id="tabs">
	    <ul>
	        <li><a href="#tab1"><span>MDC</span></a></li>
	        <li><a href="#tab2"><span>Repository</span></a></li>
	        <li><a href="#tab3"><span>Levels</span></a></li>
	        <li><a href="#tab4"><span>Hosts</span></a></li>
	        <li><a href="#tab5"><span>Plugins</span></a></li>
	        <li><a href="#tab6"><span>Pivot chain</span></a></li>
	    </ul>
	    
	    <input id="subtab" type="hidden" value='<%=subtab%>'/>
		<div id="tab1">
		    <i class='fa fa-info-circle fa-lg text-side'></i>
			<b>Mapped Diagnostic Context</b> is a common term for thread context variables generated inside applications.
			Here you can map your application MDC names with logFaces server. At
			run time, the server will look for those properties in logging events
			and automatically map them to corresponding database columns. Those
			names will also appear on client for doing real-time filtering and
			database queries.
			<%if(addMdc){%>
				<div style="float: right;">
					<img title='Add mapped name' src='images/add.gif'/>
					<a id='addMdc' href='#'>Add names</a>
					<br>
				</div>
				<br>
			<%}%>
			
			<br>
			<%if(!mdcMap.isEmpty()){%>
			<div style="width:60%; margin:0 auto;">
				<form id="mdcForm">
				    <input name="subtab" type="hidden" value="0"/>
					<table class="listing">
						<%for(int i=0; i<mdcMap.size(); i++){ %>
						<tr>
							<td style="width: 10px;"><%=i+1%>.</td>
							<td>
								<input name="mdc<%=i%>" value="<%=mdcMap.get(i)%>" style="width: 80%;" />
								<%if(removeMdc){%>
								<a class="removeMdc" data-mdc="<%=i%>" href="#">
									<img title='Remove this name' src='images/trash.gif' />
								</a>
								<%}%>
							</td>
							
							<%if(++i < mdcMap.size()){%>
								<td style="width: 10px;">   </td>
								<td style="width: 10px;"><%=i+1%>.</td>
								<td>
									<input name="mdc<%=i%>" value="<%=mdcMap.get(i)%>" style="width: 80%;" />
									<%if(removeMdc){%>
									<a class="removeMdc" data-mdc="<%=i%>" href="#">
										<img title='Remove this name' src='images/trash.gif' />
									</a>
									<%}%>
								</td>
							<%}%>
						</tr>
						<%}%>
			
					</table>
					<br>
					<div align="center">
						<input type="submit" value="Apply" />
						<input type="reset" value="Undo"/>
					</div>  
				</form>			
			</div>
			<br>
			<%=warning%>
			<%}%>
		</div>
		
		<div id="tab2">
			<i class='fa fa-info-circle fa-lg text-side'></i>
			Repository is a metadata collection (or table) holding names of applications, hosts, loggers and exception classes 
			recorded by server during its life time. This metadata is used by clients to help constructing queries and prompts.
			Note that this data collection is not managed and may grow very large in some cases. 
			Use the flags below to prevent this from spinning out of control.<br><br>
			
			<form id="repoForm">
			    <input name="subtab" type="hidden" value="1"/>
				<table class="listing">
					<%for(OptionModel option : repository){%>
					    <%request.setAttribute("option", option);%>
						<jsp:include page="optrow.jsp" />
					<%}%>
				</table>
				
				<br>
				<div align="center">
					<input type="submit" value="Apply"/>
					<input type="reset" value="Undo">
				</div>
			</form>
		</div>
		
		<div id="tab3">
		    <i class='fa fa-info-circle fa-lg text-side'></i>
			Along with standard severity levels listed below you can specify your own custom levels.<br>
			<div style="float: right;">
				<img title='Add custom level' src='images/add.gif'/>
				<a class="addLevel" href="#">Add custom level</a>
				<br>
			</div>
			<br>
			<div style="width:40%; margin:0 auto;">
				<table class="listing">
					<%for(LfsLevel level : levels){%>
					<tr>
						<td style="width: 20px;">
							<%if(level.isCustom()){%>
							<a class="removeLevel" data-name="<%=level.toString()%>" data-level="<%=level.intLevel()%>" href="#"><img title='Remove this level' src='images/trash.gif' /></a>
							<%}%>
						</td>
						
						<td>
							<%if(level.isCustom()){%>
							<a class="editLevel" data-name="<%=level.toString()%>" data-level="<%=level.intLevel()%>" href="#"><%=level.toString()%></a>
							<%}else{%>
								<%=level.toString()%>
							<%}%>
						</td>
						<td>
							<%if(level.isCustom()){%>
							<a class="editLevel" data-name="<%=level.toString()%>" data-level="<%=level.intLevel()%>" href="#"><%=level.intLevel()%></a>
							<%}else{%>
								<%=level.intLevel()%>
							<%}%>
						</td>
					</tr>
					<%}%>
				</table>
			</div>
		</div>
		
		<div id="tab4">
			<i class='fa fa-info-circle fa-lg text-side'></i>
			The hosts mapping is used by logFaces server to map incoming hostnames or IP's received from outside to friendlier names. 
			Each line should contain exactly one mapping separated by '=' sign.<br>
			For example <b>1.2.4.5 = myhost</b> or <b>thishost = thathost</b>. 
			Comments can be used with '#' character at the begining of the line.

			<%if(!Helper.isMongo()){%>			 
			<p>
				<i class='fa fa-info-circle fa-lg text-side'></i>
				The substitution is performed at the time events are received and doesn't effect older records in the database.
				If you want to update existing database records, please use external tools and <b>off peak hours</b> 
				to avoid possible performace implications with large data sets, indices, etc...
			</p>
			<%}%>

			
			<form id="hostsForm">
			    <input name="subtab" type="hidden" value="3"/>
				<p>					    	
					<textarea name="hosts" id='hosts' rows="10" cols="20" wrap="off" spellcheck='false' style="overflow: auto;width: 100%;white-space: pre;"><%=hosts%></textarea>
				</p>
				<div align="center">
					<input type="submit" value="Save"/>
					<input type="reset" value="Undo"/>
				</div>
			</form>
		</div>

		<div id="tab5">
			<i class='fa fa-info-circle fa-lg text-side'></i>
			Plugins are custom made modules for extending logFaces functionality.
			Plugins are written in Groovy language following certain implementation instructions which you can find in user manual. 
			Once your plugin is ready and tested, you can deploy it here.   
			Deployed plugins can then be retrieved by the clients in your team or used locally in Pivot Chain.
			
		 	<div class="buttonBar">
		 			<a class="addPlugin" title='Upload new plugin package' href="#"><i class='fa fa-plus text-side'></i> Add plugin</a>
			 	    <input type="file" multiple id="pluginFiles" name="pluginFiles" style="display:none">
			 	    <input type="file" multiple id="pluginUpdateFiles" name="pluginUpdateFiles" style="display:none">
			</div>
			 		
			<table id='pluginsTable'>
				<thead>
					<tr>
						<th title='ID'>#</th>
						<th title='Name of the plugin'>Plugin name or description</th>
						<th title='Used by this server'>Used by this server</th>
						<th title='Control actions'>Plugin actions</th>
					</tr>
			   </thead>
			   
			   <tbody>
				   <%for(PluginModel plugin : plugins){%>
					<tr>
						<td>
							<input type="hidden" class='id' name='id' value='<%=plugin.getId()%>'/>
							<%=plugin.getId()%>
						</td>	

						<td> 
							<div class="pname"><%=plugin.getName()%></div>
						</td>

						<td> 
							<div class="pused"><%=plugin.isUsed()?"yes":""%></div>
						</td>
	
						<td>
							<a class='editPlugin' href="#"><img title='Re-deploy this plugin' src='images/edit.gif'/></a>&nbsp;&nbsp;
							<a class='testPlugin' href="#"><img title='Test this plugin' src='images/export.gif'/></a>&nbsp;
							<a class='removePlugin' href="#"><img title='Remove this plugin' src='images/remove.gif'/></a>&nbsp;&nbsp;
						</td>
					</tr>
					<%}%>
				</tbody>
			</table>
		</div>
		
		<div id="tab6">
			<i class='fa fa-info-circle fa-lg text-side'></i>
			Pivot chain is a sequence of modules for processing the incoming log traffic. 
			Log events visit each module in chain sequentially.
			Each module can modify the event, act upon the event, or discard it from the chain.
			There are two built-in modules in the chain - the <a href='/connectivityTab?subtab=2'>blacklist</a> and the <a href='/connectivityTab?subtab=3'>flood management</a>.
			The rest can be customized away with the your own plugins. 
			The output events get committed to the database, dispatched to clients and fed to triggers.
			Table below is the chain of event processing in top to bottom order.
			<br>
			
						
		 	<div class="buttonBar">
		 		<%if(!plugins.isEmpty()){%>
		 		<a class="ppAdd" title='Insert existing plugin into pivot chain' href="#"><i class='fa fa-plus text-side'></i> Add plugin</a>
		 		<%}%>
			</div>
			 		
			<table id='pivotTable'>
				<thead>
					<tr>
						<th title=""></th>
						<th title='Name of the plugin'>Plugin</th>
						<th title='Control actions'>Actions</th>
					</tr>
			   </thead>
			   
			   <tbody>
				   <%for(PivotNodeModel model : pivot){
					   boolean valid = model.getPid() > 0;
				   %>
					<tr>
						<td>
							<%=model.isEnabled()?"<img title='Enabled' src='images/enabled.gif'/>":"<img title='Disabled' src='images/exclude.gif'/>"%>
						</td>	

						<td> 
							<%=model.getName()%>
							<%if(model.isInternal()){%>
								 <i>(built-in)</i>
							<%}%>
						</td>
	
						<td>
							<%if(valid || model.isInternal()){%>
							<a class='ppEnable' href='#'><%=model.isEnabled()?"<img title='Pause' src='images/pause.gif'/>":"<img title='Resume' src='images/run.gif'/>"%></a>&nbsp;
							<a class='ppEdit' href="#"><img title='Modify' src='images/edit.gif'/></a>&nbsp;
							<%}%>
							<%if(valid && !model.isInternal()){%>
							<a class='ppUp' href="#"><img title='Move up the chain' src='images/up.png'/></a>&nbsp;
							<a class='ppDown' href="#"><img title='Move down the chain' src='images/down.png'/></a>&nbsp;
							<%}%>
							<%if(!model.isInternal()){%>
							<a class='ppRemove' href="#"><img title='Remove this plugin from chain' src='images/remove.gif'/></a>&nbsp;
							<%}%>
						</td>
					</tr>
					<%}%>
				</tbody>
			</table>
		</div>
				
	<%@ include file="common-dialogs.jsp"%>
	<%@ include file="level-dialog.jsp"%>
	<%@ include file="plugin-dialog.jsp"%>
	<%@ include file="test-plugin-dialog.jsp"%>
		
	</div>
</div>
<!--end main DIV --></div>
<!--end content DIV -->
<%@ include file="footer.jsp"%>