/*
 * Decompiled with CFR 0.152.
 */
package com.leansoft.bigqueue.page;

import com.leansoft.bigqueue.cleaner.DirectBufferCleaner;
import com.leansoft.bigqueue.cleaner.ReflectiveDirectBufferCleaner;
import com.leansoft.bigqueue.cleaner.UnsafeDirectBufferCleaner;
import com.leansoft.bigqueue.page.IMappedPage;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MappedPageImpl
implements IMappedPage,
Closeable {
    private static final Logger logger = LoggerFactory.getLogger(MappedPageImpl.class);
    private static final DirectBufferCleaner Cleaner = MappedPageImpl.majorJavaVersion() < 9 ? new ReflectiveDirectBufferCleaner() : new UnsafeDirectBufferCleaner();
    private ThreadLocalByteBuffer threadLocalBuffer;
    private volatile boolean dirty = false;
    private volatile boolean closed = false;
    private String pageFile;
    private long index;

    public MappedPageImpl(MappedByteBuffer mbb, String pageFile, long index) {
        this.threadLocalBuffer = new ThreadLocalByteBuffer(mbb);
        this.pageFile = pageFile;
        this.index = index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        MappedPageImpl mappedPageImpl = this;
        synchronized (mappedPageImpl) {
            if (this.closed) {
                return;
            }
            this.flush();
            MappedByteBuffer srcBuf = (MappedByteBuffer)this.threadLocalBuffer.getSourceBuffer();
            MappedPageImpl.unmap(srcBuf);
            this.threadLocalBuffer = null;
            this.closed = true;
            if (logger.isDebugEnabled()) {
                logger.debug("Mapped page for " + this.pageFile + " was just unmapped and closed.");
            }
        }
    }

    @Override
    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        MappedPageImpl mappedPageImpl = this;
        synchronized (mappedPageImpl) {
            if (this.closed) {
                return;
            }
            if (this.dirty) {
                MappedByteBuffer srcBuf = (MappedByteBuffer)this.threadLocalBuffer.getSourceBuffer();
                srcBuf.force();
                this.dirty = false;
                if (logger.isDebugEnabled()) {
                    logger.debug("Mapped page for " + this.pageFile + " was just flushed.");
                }
            }
        }
    }

    @Override
    public byte[] getLocal(int position, int length) {
        ByteBuffer buf = this.getLocal(position);
        byte[] data = new byte[length];
        buf.get(data);
        return data;
    }

    @Override
    public ByteBuffer getLocal(int position) {
        ByteBuffer buf = (ByteBuffer)this.threadLocalBuffer.get();
        buf.position(position);
        return buf;
    }

    private static void unmap(MappedByteBuffer buffer) {
        Cleaner.clean(buffer);
    }

    public static int majorJavaVersion() {
        String verStr = System.getProperty("java.specification.version");
        try {
            String[] parts = verStr.split("\\.");
            int major = Integer.parseInt(parts[0]);
            if (parts.length == 1) {
                return major;
            }
            int minor = Integer.parseInt(parts[1]);
            return major == 1 ? minor : major;
        }
        catch (Exception e) {
            return 0;
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    public String toString() {
        return "Mapped page for " + this.pageFile + ", index = " + this.index + ".";
    }

    @Override
    public String getPageFile() {
        return this.pageFile;
    }

    @Override
    public long getPageIndex() {
        return this.index;
    }

    private static class ThreadLocalByteBuffer
    extends ThreadLocal<ByteBuffer> {
        private ByteBuffer _src;

        public ThreadLocalByteBuffer(ByteBuffer src) {
            this._src = src;
        }

        public ByteBuffer getSourceBuffer() {
            return this._src;
        }

        @Override
        protected synchronized ByteBuffer initialValue() {
            ByteBuffer dup = this._src.duplicate();
            return dup;
        }
    }
}

