/*
 * Decompiled with CFR 0.152.
 */
package com.leansoft.bigqueue.cleaner;

import com.leansoft.bigqueue.cleaner.DirectBufferCleaner;
import com.leansoft.bigqueue.cleaner.UNSAFE;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import sun.misc.Unsafe;

public class UnsafeDirectBufferCleaner
implements DirectBufferCleaner {
    private final Method cleanerMtd;

    public UnsafeDirectBufferCleaner() {
        try {
            this.cleanerMtd = Unsafe.class.getMethod("invokeCleaner", ByteBuffer.class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Reflection failure: no sun.misc.Unsafe.invokeCleaner() method found", e);
        }
    }

    @Override
    public void clean(ByteBuffer buf) {
        UNSAFE.invoke(this.cleanerMtd, buf);
    }
}

