/*
 * Decompiled with CFR 0.152.
 */
package com.leansoft.bigqueue.cache;

import com.leansoft.bigqueue.cache.ILRUCache;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LRUCacheImpl<K, V extends Closeable>
implements ILRUCache<K, V> {
    private static final Logger logger = LoggerFactory.getLogger(LRUCacheImpl.class);
    public static final long DEFAULT_TTL = 10000L;
    private final Map<K, V> map;
    private final Map<K, TTLValue> ttlMap;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Lock readLock = this.lock.readLock();
    private final Lock writeLock = this.lock.writeLock();
    private static final ExecutorService executorService = Executors.newCachedThreadPool();
    private final Set<K> keysToRemove = new HashSet<K>();

    public LRUCacheImpl() {
        this.map = new HashMap();
        this.ttlMap = new HashMap<K, TTLValue>();
    }

    public static void CloseExecutorService() {
        executorService.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(K key, V value, long ttlInMilliSeconds) {
        Collection<V> valuesToClose = null;
        try {
            this.writeLock.lock();
            valuesToClose = this.markAndSweep();
            if (valuesToClose != null && valuesToClose.contains(value)) {
                valuesToClose.remove(value);
            }
            this.map.put(key, value);
            TTLValue ttl = new TTLValue(System.currentTimeMillis(), ttlInMilliSeconds);
            ttl.refCount.incrementAndGet();
            this.ttlMap.put(key, ttl);
        }
        finally {
            this.writeLock.unlock();
        }
        if (valuesToClose != null && valuesToClose.size() > 0) {
            if (logger.isDebugEnabled()) {
                int size;
                logger.info("Mark&Sweep found " + size + ((size = valuesToClose.size()) > 1 ? " resources" : " resource") + " to close.");
            }
            executorService.execute(new ValueCloser<V>(valuesToClose));
        }
    }

    @Override
    public void put(K key, V value) {
        this.put(key, value, 10000L);
    }

    private Collection<V> markAndSweep() {
        HashSet<Closeable> valuesToClose = null;
        this.keysToRemove.clear();
        Set<K> keys = this.ttlMap.keySet();
        long currentTS = System.currentTimeMillis();
        for (K key : keys) {
            TTLValue ttl = this.ttlMap.get(key);
            if (ttl.refCount.get() > 0L || currentTS - ttl.lastAccessedTimestamp.get() <= ttl.ttl) continue;
            this.keysToRemove.add(key);
        }
        if (this.keysToRemove.size() > 0) {
            valuesToClose = new HashSet<Closeable>();
            for (K key : this.keysToRemove) {
                Closeable v = (Closeable)this.map.remove(key);
                valuesToClose.add(v);
                this.ttlMap.remove(key);
            }
        }
        return valuesToClose;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(K key) {
        try {
            this.readLock.lock();
            TTLValue ttl = this.ttlMap.get(key);
            if (ttl != null) {
                ttl.lastAccessedTimestamp.set(System.currentTimeMillis());
                ttl.refCount.incrementAndGet();
            }
            Closeable closeable = (Closeable)this.map.get(key);
            return (V)closeable;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void release(K key) {
        try {
            this.readLock.lock();
            TTLValue ttl = this.ttlMap.get(key);
            if (ttl != null) {
                ttl.refCount.decrementAndGet();
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public int size() {
        try {
            this.readLock.lock();
            int n = this.map.size();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAll() throws IOException {
        try {
            this.writeLock.lock();
            HashSet<V> valuesToClose = new HashSet<V>();
            valuesToClose.addAll(this.map.values());
            if (valuesToClose != null && valuesToClose.size() > 0) {
                for (Closeable v : valuesToClose) {
                    v.close();
                }
            }
            this.map.clear();
            this.ttlMap.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(K key) throws IOException {
        try {
            this.writeLock.lock();
            this.ttlMap.remove(key);
            Closeable value = (Closeable)this.map.remove(key);
            if (value != null) {
                value.close();
            }
            Closeable closeable = value;
            return (V)closeable;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<V> getValues() {
        try {
            this.readLock.lock();
            ArrayList<Closeable> col = new ArrayList<Closeable>();
            for (Closeable v : this.map.values()) {
                col.add(v);
            }
            ArrayList<Closeable> arrayList = col;
            return arrayList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private static class TTLValue {
        AtomicLong lastAccessedTimestamp;
        AtomicLong refCount = new AtomicLong(0L);
        long ttl;

        public TTLValue(long ts, long ttl) {
            this.lastAccessedTimestamp = new AtomicLong(ts);
            this.ttl = ttl;
        }
    }

    private static class ValueCloser<V extends Closeable>
    implements Runnable {
        Collection<V> valuesToClose;

        public ValueCloser(Collection<V> valuesToClose) {
            this.valuesToClose = valuesToClose;
        }

        @Override
        public void run() {
            int size = this.valuesToClose.size();
            for (Closeable v : this.valuesToClose) {
                try {
                    if (v == null) continue;
                    v.close();
                }
                catch (IOException iOException) {}
            }
            if (logger.isDebugEnabled()) {
                logger.debug("ResourceCloser closed " + size + (size > 1 ? " resources." : " resource."));
            }
        }
    }
}

