/*
 * Decompiled with CFR 0.152.
 */
package com.leansoft.bigqueue;

import com.leansoft.bigqueue.BigArrayImpl;
import com.leansoft.bigqueue.IFanOutQueue;
import com.leansoft.bigqueue.page.IMappedPage;
import com.leansoft.bigqueue.page.IMappedPageFactory;
import com.leansoft.bigqueue.page.MappedPageFactoryImpl;
import com.leansoft.bigqueue.utils.FolderNameValidator;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class FanOutQueueImpl
implements IFanOutQueue {
    final BigArrayImpl innerArray;
    static final int QUEUE_FRONT_INDEX_ITEM_LENGTH_BITS = 3;
    static final int QUEUE_FRONT_INDEX_PAGE_SIZE = 8;
    static final long QUEUE_FRONT_PAGE_INDEX = 0L;
    static final String QUEUE_FRONT_INDEX_PAGE_FOLDER_PREFIX = "front_index_";
    final ConcurrentMap<String, QueueFront> queueFrontMap = new ConcurrentHashMap<String, QueueFront>();

    public FanOutQueueImpl(String queueDir, String queueName, int pageSize) throws IOException {
        this.innerArray = new BigArrayImpl(queueDir, queueName, pageSize);
    }

    public FanOutQueueImpl(String queueDir, String queueName) throws IOException {
        this(queueDir, queueName, 0x8000000);
    }

    QueueFront getQueueFront(String fanoutId) throws IOException {
        QueueFront found;
        QueueFront qf = (QueueFront)this.queueFrontMap.get(fanoutId);
        if (qf == null && (found = this.queueFrontMap.putIfAbsent(fanoutId, qf = new QueueFront(fanoutId))) != null) {
            qf.indexPageFactory.releaseCachedPages();
            qf = found;
        }
        return qf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty(String fanoutId) throws IOException {
        try {
            this.innerArray.arrayReadLock.lock();
            QueueFront qf = this.getQueueFront(fanoutId);
            boolean bl = qf.index.get() == this.innerArray.getHeadIndex();
            return bl;
        }
        finally {
            this.innerArray.arrayReadLock.unlock();
        }
    }

    @Override
    public boolean isEmpty() {
        return this.innerArray.isEmpty();
    }

    @Override
    public long enqueue(byte[] data) throws IOException {
        return this.innerArray.append(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] dequeue(String fanoutId) throws IOException {
        try {
            byte[] byArray;
            QueueFront qf;
            block11: {
                this.innerArray.arrayReadLock.lock();
                qf = this.getQueueFront(fanoutId);
                qf.writeLock.lock();
                if (qf.index.get() != this.innerArray.arrayHeadIndex.get()) break block11;
                byte[] byArray2 = null;
                qf.writeLock.unlock();
                return byArray2;
            }
            try {
                byte[] data = this.innerArray.get(qf.index.get());
                qf.incrementIndex();
                byArray = data;
            }
            catch (IndexOutOfBoundsException ex) {
                try {
                    ex.printStackTrace();
                    qf.resetIndex();
                    byte[] data = this.innerArray.get(qf.index.get());
                    qf.incrementIndex();
                    byte[] byArray3 = data;
                    qf.writeLock.unlock();
                    this.innerArray.arrayReadLock.unlock();
                    return byArray3;
                }
                catch (Throwable throwable) {
                    qf.writeLock.unlock();
                    throw throwable;
                }
            }
            qf.writeLock.unlock();
            return byArray;
        }
        finally {
            this.innerArray.arrayReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] peek(String fanoutId) throws IOException {
        try {
            this.innerArray.arrayReadLock.lock();
            QueueFront qf = this.getQueueFront(fanoutId);
            if (qf.index.get() == this.innerArray.getHeadIndex()) {
                byte[] byArray = null;
                return byArray;
            }
            byte[] byArray = this.innerArray.get(qf.index.get());
            return byArray;
        }
        finally {
            this.innerArray.arrayReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int peekLength(String fanoutId) throws IOException {
        try {
            this.innerArray.arrayReadLock.lock();
            QueueFront qf = this.getQueueFront(fanoutId);
            if (qf.index.get() == this.innerArray.getHeadIndex()) {
                int n = -1;
                return n;
            }
            int n = this.innerArray.getItemLength(qf.index.get());
            return n;
        }
        finally {
            this.innerArray.arrayReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long peekTimestamp(String fanoutId) throws IOException {
        try {
            this.innerArray.arrayReadLock.lock();
            QueueFront qf = this.getQueueFront(fanoutId);
            if (qf.index.get() == this.innerArray.getHeadIndex()) {
                long l = -1L;
                return l;
            }
            long l = this.innerArray.getTimestamp(qf.index.get());
            return l;
        }
        finally {
            this.innerArray.arrayReadLock.unlock();
        }
    }

    @Override
    public byte[] get(long index) throws IOException {
        return this.innerArray.get(index);
    }

    @Override
    public int getLength(long index) throws IOException {
        return this.innerArray.getItemLength(index);
    }

    @Override
    public long getTimestamp(long index) throws IOException {
        return this.innerArray.getTimestamp(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeBefore(long timestamp) throws IOException {
        try {
            this.innerArray.arrayWriteLock.lock();
            this.innerArray.removeBefore(timestamp);
            for (QueueFront qf : this.queueFrontMap.values()) {
                try {
                    qf.writeLock.lock();
                    qf.validateAndAdjustIndex();
                }
                finally {
                    qf.writeLock.unlock();
                }
            }
        }
        finally {
            this.innerArray.arrayWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void limitBackFileSize(long sizeLimit) throws IOException {
        try {
            this.innerArray.arrayWriteLock.lock();
            this.innerArray.limitBackFileSize(sizeLimit);
            for (QueueFront qf : this.queueFrontMap.values()) {
                try {
                    qf.writeLock.lock();
                    qf.validateAndAdjustIndex();
                }
                finally {
                    qf.writeLock.unlock();
                }
            }
        }
        finally {
            this.innerArray.arrayWriteLock.unlock();
        }
    }

    @Override
    public long getBackFileSize() throws IOException {
        return this.innerArray.getBackFileSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long findClosestIndex(long timestamp) throws IOException {
        try {
            this.innerArray.arrayReadLock.lock();
            if (timestamp == -2L) {
                long l = this.innerArray.getHeadIndex();
                return l;
            }
            if (timestamp == -1L) {
                long l = this.innerArray.getTailIndex();
                return l;
            }
            long l = this.innerArray.findClosestIndex(timestamp);
            return l;
        }
        finally {
            this.innerArray.arrayReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetQueueFrontIndex(String fanoutId, long index) throws IOException {
        try {
            this.innerArray.arrayReadLock.lock();
            QueueFront qf = this.getQueueFront(fanoutId);
            try {
                qf.writeLock.lock();
                if (index != this.innerArray.getHeadIndex()) {
                    this.innerArray.validateIndex(index);
                }
                qf.index.set(index);
                qf.persistIndex();
            }
            finally {
                qf.writeLock.unlock();
            }
        }
        finally {
            this.innerArray.arrayReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long size(String fanoutId) throws IOException {
        try {
            this.innerArray.arrayReadLock.lock();
            QueueFront qf = this.getQueueFront(fanoutId);
            long qFront = qf.index.get();
            long qRear = this.innerArray.getHeadIndex();
            if (qFront <= qRear) {
                long l = qRear - qFront;
                return l;
            }
            long l = Long.MAX_VALUE - qFront + 1L + qRear;
            return l;
        }
        finally {
            this.innerArray.arrayReadLock.unlock();
        }
    }

    @Override
    public long size() {
        return this.innerArray.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        try {
            this.innerArray.arrayReadLock.lock();
            for (QueueFront qf : this.queueFrontMap.values()) {
                try {
                    qf.writeLock.lock();
                    qf.indexPageFactory.flush();
                }
                finally {
                    qf.writeLock.unlock();
                }
            }
            this.innerArray.flush();
        }
        finally {
            this.innerArray.arrayReadLock.unlock();
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.innerArray.arrayWriteLock.lock();
            for (QueueFront qf : this.queueFrontMap.values()) {
                qf.indexPageFactory.releaseCachedPages();
            }
            this.innerArray.close();
        }
        finally {
            this.innerArray.arrayWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAll() throws IOException {
        try {
            this.innerArray.arrayWriteLock.lock();
            for (QueueFront qf : this.queueFrontMap.values()) {
                try {
                    qf.writeLock.lock();
                    qf.index.set(0L);
                    qf.persistIndex();
                }
                finally {
                    qf.writeLock.unlock();
                }
            }
            this.innerArray.removeAll();
        }
        finally {
            this.innerArray.arrayWriteLock.unlock();
        }
    }

    @Override
    public long getFrontIndex() {
        return this.innerArray.getTailIndex();
    }

    @Override
    public long getRearIndex() {
        return this.innerArray.getHeadIndex();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getFrontIndex(String fanoutId) throws IOException {
        try {
            this.innerArray.arrayReadLock.lock();
            QueueFront qf = this.getQueueFront(fanoutId);
            long l = qf.index.get();
            return l;
        }
        finally {
            this.innerArray.arrayReadLock.unlock();
        }
    }

    class QueueFront {
        final String fanoutId;
        final AtomicLong index = new AtomicLong();
        final IMappedPageFactory indexPageFactory;
        final Lock writeLock = new ReentrantLock();

        QueueFront(String fanoutId) throws IOException {
            try {
                FolderNameValidator.validate(fanoutId);
            }
            catch (IllegalArgumentException ex) {
                throw new IllegalArgumentException("invalid fanout identifier", ex);
            }
            this.fanoutId = fanoutId;
            this.indexPageFactory = new MappedPageFactoryImpl(8, FanOutQueueImpl.this.innerArray.arrayDirectory + FanOutQueueImpl.QUEUE_FRONT_INDEX_PAGE_FOLDER_PREFIX + fanoutId, 10000L);
            IMappedPage indexPage = this.indexPageFactory.acquirePage(0L);
            ByteBuffer indexBuffer = indexPage.getLocal(0);
            this.index.set(indexBuffer.getLong());
            this.validateAndAdjustIndex();
        }

        void validateAndAdjustIndex() throws IOException {
            if (this.index.get() != FanOutQueueImpl.this.innerArray.arrayHeadIndex.get()) {
                try {
                    FanOutQueueImpl.this.innerArray.validateIndex(this.index.get());
                }
                catch (IndexOutOfBoundsException ex) {
                    this.resetIndex();
                }
            }
        }

        void resetIndex() throws IOException {
            this.index.set(FanOutQueueImpl.this.innerArray.arrayTailIndex.get());
            this.persistIndex();
        }

        void incrementIndex() throws IOException {
            long nextIndex = this.index.get();
            nextIndex = nextIndex == Long.MAX_VALUE ? 0L : ++nextIndex;
            this.index.set(nextIndex);
            this.persistIndex();
        }

        void persistIndex() throws IOException {
            IMappedPage indexPage = this.indexPageFactory.acquirePage(0L);
            ByteBuffer indexBuffer = indexPage.getLocal(0);
            indexBuffer.putLong(this.index.get());
            indexPage.setDirty(true);
        }
    }
}

