/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.sqlbuilder;

import com.healthmarketscience.common.util.AppendableExt;
import com.healthmarketscience.sqlbuilder.Converter;
import com.healthmarketscience.sqlbuilder.Expression;
import com.healthmarketscience.sqlbuilder.SqlObject;
import com.healthmarketscience.sqlbuilder.SqlObjectList;
import com.healthmarketscience.sqlbuilder.ValidationContext;
import com.healthmarketscience.sqlbuilder.ValidationException;
import com.healthmarketscience.sqlbuilder.Verifiable;
import java.io.IOException;
import java.util.ListIterator;

public abstract class BaseCaseStatement<ThisType extends BaseCaseStatement<ThisType>>
extends Expression
implements Verifiable<ThisType> {
    private static final ElseObject NULL_ELSE = new ElseObject(null);
    private SqlObject _operand;
    private SqlObjectList<BaseWhenObject> _whens = SqlObjectList.create(" ");

    protected BaseCaseStatement(SqlObject operand) {
        this._operand = operand;
    }

    @Override
    public boolean isEmpty() {
        return this._whens.isEmpty();
    }

    public ThisType addCustomWhen(Object test, Object result) {
        this._whens.addObject(new WhenObject(Converter.toColumnSqlObject(test), result));
        return this.getThisType();
    }

    public ThisType addElse(Object result) {
        this._whens.addObject(new ElseObject(result));
        return this.getThisType();
    }

    public ThisType addElseNull() {
        this._whens.addObject(NULL_ELSE);
        return this.getThisType();
    }

    @Override
    public final ThisType validate() throws ValidationException {
        this.doValidate();
        return this.getThisType();
    }

    @Override
    public void validate(ValidationContext vContext) throws ValidationException {
        if (this._whens.size() > 1) {
            int okayIdx = this._whens.size() - 1;
            ListIterator<BaseWhenObject> iter = this._whens.listIterator();
            while (iter.hasNext()) {
                int idx = iter.nextIndex();
                BaseWhenObject obj = iter.next();
                if (!(obj instanceof ElseObject) || idx == okayIdx) continue;
                throw new ValidationException("Else clause at invalid index " + idx);
            }
        }
    }

    @Override
    protected void collectSchemaObjects(ValidationContext vContext) {
        vContext.addVerifiable(this);
        if (this._operand != null) {
            this._operand.collectSchemaObjects(vContext);
        }
        this._whens.collectSchemaObjects(vContext);
    }

    @Override
    public void appendTo(AppendableExt app) throws IOException {
        if (!this.isEmpty()) {
            app.append("(CASE ");
            if (this._operand != null) {
                app.append(this._operand).append(" ");
            }
            app.append(this._whens).append(" END)");
        }
    }

    protected final ThisType getThisType() {
        return (ThisType)this;
    }

    private static class ElseObject
    extends BaseWhenObject {
        private ElseObject(Object result) {
            super(result);
        }

        @Override
        public void appendTo(AppendableExt app) throws IOException {
            app.append("ELSE ");
            this.appendResult(app);
        }
    }

    private static class WhenObject
    extends BaseWhenObject {
        private SqlObject _test;

        private WhenObject(SqlObject test, Object result) {
            super(result);
            this._test = test;
        }

        @Override
        protected void collectSchemaObjects(ValidationContext vContext) {
            super.collectSchemaObjects(vContext);
            this._test.collectSchemaObjects(vContext);
        }

        @Override
        public void appendTo(AppendableExt app) throws IOException {
            app.append("WHEN ").append(this._test).append(" THEN ");
            this.appendResult(app);
        }
    }

    private static abstract class BaseWhenObject
    extends SqlObject {
        private SqlObject _result;

        protected BaseWhenObject(Object result) {
            this._result = Converter.toColumnSqlObject(result);
        }

        @Override
        protected void collectSchemaObjects(ValidationContext vContext) {
            this._result.collectSchemaObjects(vContext);
        }

        protected void appendResult(AppendableExt app) throws IOException {
            app.append(this._result);
        }
    }
}

