/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.syslog4j.util;

import com.moonlit.syslog4j.SyslogCharSetIF;
import com.moonlit.syslog4j.SyslogRuntimeException;
import java.net.InetAddress;
import java.net.UnknownHostException;

public final class SyslogUtility {
    private SyslogUtility() {
    }

    public static InetAddress getInetAddress(String host) throws SyslogRuntimeException {
        try {
            return InetAddress.getByName(host);
        }
        catch (UnknownHostException uhe) {
            throw new SyslogRuntimeException(uhe);
        }
    }

    public static boolean isClassExists(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException cnfe) {
            return false;
        }
    }

    public static String getLocalName() {
        String localName = "unknown";
        try {
            InetAddress addr = InetAddress.getLocalHost();
            return addr.getHostName();
        }
        catch (UnknownHostException uhe) {
            return localName;
        }
    }

    public static byte[] getBytes(SyslogCharSetIF syslogCharSet, String data) {
        return data.getBytes(syslogCharSet.getCharSet());
    }

    public static String newString(SyslogCharSetIF syslogCharSet, byte[] dataBytes) {
        String data = SyslogUtility.newString(syslogCharSet, dataBytes, dataBytes.length);
        return data;
    }

    public static String newString(SyslogCharSetIF syslogCharSet, byte[] dataBytes, int dataLength) {
        return new String(dataBytes, 0, dataLength, syslogCharSet.getCharSet());
    }

    public static void sleep(long duration) {
        try {
            Thread.sleep(duration);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

