/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.syslog4j.util;

import org.apache.commons.lang3.StringUtils;

public final class OSDetectUtility {
    private static final String[] UNIX_PLATFORMS = new String[]{"Linux", "Mac OS", "Solaris", "SunOS", "MPE/iX", "HP-UX", "AIX", "OS/390", "FreeBSD", "Irix", "Digital Unix", "FreeBSD", "OSF1", "OpenVMS"};
    private static final String[] WINDOWS_PLATFORMS = new String[]{"Windows", "OS/2"};
    private static boolean UNIX = false;
    private static boolean WINDOWS = false;

    private OSDetectUtility() {
    }

    private static boolean isMatch(String[] platforms) {
        boolean match = false;
        String osName = System.getProperty("os.name");
        if (!StringUtils.isBlank((CharSequence)osName)) {
            osName = osName.toLowerCase();
            for (int i = 0; i < platforms.length; ++i) {
                String platform = platforms[i].toLowerCase();
                if (osName.indexOf(platform) <= -1) continue;
                match = true;
                break;
            }
        }
        return match;
    }

    public static boolean isUnix() {
        return UNIX;
    }

    public static boolean isWindows() {
        return WINDOWS;
    }

    static {
        UNIX = OSDetectUtility.isMatch(UNIX_PLATFORMS);
        WINDOWS = OSDetectUtility.isMatch(WINDOWS_PLATFORMS);
    }
}

