/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.syslog4j.server.impl.net.udp;

import com.moonlit.syslog4j.SyslogRuntimeException;
import com.moonlit.syslog4j.server.SyslogServerEventIF;
import com.moonlit.syslog4j.server.SyslogServerIF;
import com.moonlit.syslog4j.server.impl.AbstractSyslogServer;
import com.moonlit.syslog4j.util.SyslogUtility;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UDPNetSyslogServer
extends AbstractSyslogServer {
    private static final Logger LOG = LogManager.getLogger(UDPNetSyslogServer.class);
    protected DatagramSocket ds = null;

    @Override
    public void initialize() throws SyslogRuntimeException {
    }

    @Override
    public void shutdown() {
        super.shutdown();
        if (this.syslogServerConfig.getShutdownWait() > 0L) {
            SyslogUtility.sleep(this.syslogServerConfig.getShutdownWait());
        }
        if (this.ds != null && !this.ds.isClosed()) {
            this.ds.close();
        }
        this.interruptThread();
    }

    protected DatagramSocket createDatagramSocket() throws SocketException, UnknownHostException {
        DatagramSocket datagramSocket = null;
        if (this.syslogServerConfig.getHost() != null) {
            InetAddress inetAddress = InetAddress.getByName(this.syslogServerConfig.getHost());
            datagramSocket = new DatagramSocket(this.syslogServerConfig.getPort(), inetAddress);
        } else {
            datagramSocket = new DatagramSocket(this.syslogServerConfig.getPort());
        }
        int rxbufSize = this.syslogServerConfig.getReceiveBufferSize();
        if (rxbufSize > 0) {
            datagramSocket.setReceiveBufferSize(rxbufSize);
            LOG.info(String.format("udp so_rcvbuf override: %d bytes", datagramSocket.getReceiveBufferSize()));
        }
        return datagramSocket;
    }

    @Override
    public void run() {
        try {
            this.ds = this.createDatagramSocket();
            this.shutdown = false;
        }
        catch (SocketException se) {
            LOG.warn("While creating datagram socket", (Throwable)se);
            return;
        }
        catch (UnknownHostException uhe) {
            LOG.warn("While creating datagram socket", (Throwable)uhe);
            return;
        }
        catch (Throwable e) {
            LOG.warn("While creating datagram socket", e);
            return;
        }
        byte[] receiveData = new byte[1024];
        this.handleInitialize(this);
        while (!this.shutdown) {
            DatagramPacket dp = null;
            try {
                dp = new DatagramPacket(receiveData, receiveData.length);
                this.ds.receive(dp);
                SyslogServerEventIF event = UDPNetSyslogServer.createEvent(this.getConfig(), receiveData, dp.getLength(), dp.getAddress());
                UDPNetSyslogServer.handleEvent(null, (SyslogServerIF)this, dp, event);
            }
            catch (SocketException se) {
                LOG.error(se.getMessage());
                int i = se.getMessage() == null ? -1 : se.getMessage().toLowerCase().indexOf("socket closed");
                if (i != -1) continue;
                UDPNetSyslogServer.handleException(null, this, dp.getSocketAddress(), se);
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
                UDPNetSyslogServer.handleException(null, this, dp.getSocketAddress(), e);
            }
            catch (Throwable e) {
                LOG.fatal(e.getMessage(), e);
            }
        }
        this.handleDestroy(this);
    }

    @Override
    public int getActualPort() {
        return this.ds.getLocalPort();
    }
}

