/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.syslog4j.server.impl.net.tcp.ssl;

import com.moonlit.syslog4j.SyslogRuntimeException;
import com.moonlit.syslog4j.server.impl.net.tcp.TCPNetSyslogServer;
import com.moonlit.syslog4j.server.impl.net.tcp.ssl.SSLTCPNetSyslogServerConfigIF;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import javax.net.ServerSocketFactory;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.StringUtils;

public class SSLTCPNetSyslogServer
extends TCPNetSyslogServer {
    @Override
    public void initialize() throws SyslogRuntimeException {
        String trustStorePassword;
        String trustStore;
        String keyStorePassword;
        super.initialize();
        SSLTCPNetSyslogServerConfigIF sslTcpNetSyslogServerConfig = (SSLTCPNetSyslogServerConfigIF)this.tcpNetSyslogServerConfig;
        String keyStore = sslTcpNetSyslogServerConfig.getKeyStore();
        if (!StringUtils.isBlank((CharSequence)keyStore)) {
            System.setProperty("javax.net.ssl.keyStore", keyStore);
        }
        if (!StringUtils.isBlank((CharSequence)(keyStorePassword = sslTcpNetSyslogServerConfig.getKeyStorePassword()))) {
            System.setProperty("javax.net.ssl.keyStorePassword", keyStorePassword);
        }
        if (!StringUtils.isBlank((CharSequence)(trustStore = sslTcpNetSyslogServerConfig.getTrustStore()))) {
            System.setProperty("javax.net.ssl.trustStore", trustStore);
        }
        if (!StringUtils.isBlank((CharSequence)(trustStorePassword = sslTcpNetSyslogServerConfig.getTrustStorePassword()))) {
            System.setProperty("javax.net.ssl.trustStorePassword", trustStorePassword);
        }
    }

    @Override
    protected ServerSocketFactory getServerSocketFactory() throws IOException {
        try {
            SSLTCPNetSyslogServerConfigIF sslTcpNetSyslogServerConfig = (SSLTCPNetSyslogServerConfigIF)this.tcpNetSyslogServerConfig;
            SSLContext sslContext = SSLContext.getInstance("SSL");
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            String file = sslTcpNetSyslogServerConfig.getKeyStore();
            String pass = sslTcpNetSyslogServerConfig.getKeyStorePassword();
            keyStore.load(new FileInputStream(file), pass.toCharArray());
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(keyStore, pass.toCharArray());
            sslContext.init(kmf.getKeyManagers(), null, null);
            return sslContext.getServerSocketFactory();
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }
}

