/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.syslog4j.server.impl.event.structured;

import com.moonlit.syslog4j.impl.message.structured.StructuredSyslogMessage;
import com.moonlit.syslog4j.server.impl.event.SyslogServerEvent;
import java.net.InetAddress;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class StructuredSyslogServerEvent
extends SyslogServerEvent {
    private String applicationName;
    private String processId;
    private DateTime dateTime;
    private DateTimeFormatter dateTimeFormatter;

    public StructuredSyslogServerEvent(byte[] message, int length, InetAddress inetAddress) {
        super(message, length, inetAddress);
    }

    public StructuredSyslogServerEvent(String message, InetAddress inetAddress) {
        super(message, inetAddress);
    }

    @Override
    protected void parse() {
        this.applicationName = "unknown";
        this.processId = null;
        this.dateTime = null;
        this.dateTimeFormatter = null;
        super.parse();
        this.parseApplicationName();
        this.parseProcessId();
    }

    public DateTimeFormatter getDateTimeFormatter() {
        if (this.dateTimeFormatter == null) {
            this.dateTimeFormatter = ISODateTimeFormat.dateTimeParser();
        }
        return this.dateTimeFormatter;
    }

    public void setDateTimeFormatter(Object dateTimeFormatter) {
        this.dateTimeFormatter = (DateTimeFormatter)dateTimeFormatter;
    }

    protected void parseApplicationName() {
        int i = this.message.indexOf(32);
        if (i > -1) {
            this.applicationName = StringUtils.trimToEmpty((String)this.message.substring(0, i));
            this.message = this.message.substring(i + 1);
        }
        if ("-".equals(this.applicationName)) {
            this.applicationName = null;
        }
    }

    protected void parseProcessId() {
        int i = this.message.indexOf(32);
        if (i > -1) {
            this.processId = StringUtils.trimToEmpty((String)this.message.substring(0, i));
            this.message = this.message.substring(i + 1);
        }
        if ("-".equals(this.processId)) {
            this.processId = null;
        }
    }

    @Override
    protected void parseDate() {
        int i = this.message.indexOf(32);
        this.message = this.message.substring(i + 1);
        i = this.message.indexOf(32);
        if (i > -1) {
            String dateString = StringUtils.trimToEmpty((String)this.message.substring(0, i));
            try {
                DateTimeFormatter formatter = this.getDateTimeFormatter();
                this.dateTime = formatter.parseDateTime(dateString);
                this.date = this.dateTime.toDate();
                this.message = this.message.substring(dateString.length() + 1);
            }
            catch (Exception e) {
                super.parseDate();
            }
        }
    }

    @Override
    protected void parseHost() {
        int i = this.message.indexOf(32);
        if (i > -1) {
            this.host = StringUtils.trimToEmpty((String)this.message.substring(0, i));
            this.message = this.message.substring(i + 1);
        }
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getProcessId() {
        return this.processId;
    }

    public DateTime getDateTime() {
        return this.dateTime;
    }

    public StructuredSyslogMessage getStructuredMessage() {
        return StructuredSyslogMessage.fromString(this.getMessage());
    }
}

