/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.syslog4j.server;

import com.moonlit.syslog4j.SyslogRuntimeException;
import com.moonlit.syslog4j.server.SyslogServerConfigIF;
import com.moonlit.syslog4j.server.SyslogServerIF;
import org.apache.commons.lang3.StringUtils;

public class SyslogServerFactory {
    public static final SyslogServerIF createInstance(String protocol, SyslogServerConfigIF config) throws SyslogRuntimeException {
        if (StringUtils.isBlank((CharSequence)protocol)) {
            throw new SyslogRuntimeException("Instance protocol cannot be null or empty", new Object[0]);
        }
        if (config == null) {
            throw new SyslogRuntimeException("SyslogServerConfig cannot be null", new Object[0]);
        }
        try {
            Class<? extends SyslogServerIF> clazz = config.getSyslogServerClass();
            SyslogServerIF instance = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            instance.initialize(protocol, config);
            Thread thread = new Thread(instance);
            thread.setName(String.format("syslog-%s-%d", protocol, config.getPort()));
            thread.setDaemon(config.isUseDaemonThread());
            if (config.getThreadPriority() > -1) {
                thread.setPriority(config.getThreadPriority());
            }
            instance.setThread(thread);
            thread.start();
            return instance;
        }
        catch (Throwable e) {
            throw new SyslogRuntimeException(e);
        }
    }
}

