/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.syslog4j.impl.pool;

import com.moonlit.syslog4j.SyslogRuntimeException;
import com.moonlit.syslog4j.impl.AbstractSyslog;
import com.moonlit.syslog4j.impl.AbstractSyslogConfigIF;
import com.moonlit.syslog4j.impl.AbstractSyslogWriter;
import org.apache.commons.pool.BasePoolableObjectFactory;
import org.apache.commons.pool.ObjectPool;

public abstract class AbstractSyslogPoolFactory
extends BasePoolableObjectFactory<AbstractSyslogWriter> {
    protected AbstractSyslog syslog = null;
    protected AbstractSyslogConfigIF syslogConfig = null;
    protected ObjectPool<AbstractSyslogWriter> pool = null;

    public void initialize(AbstractSyslog abstractSyslog) throws SyslogRuntimeException {
        this.syslog = abstractSyslog;
        try {
            this.syslogConfig = (AbstractSyslogConfigIF)this.syslog.getConfig();
        }
        catch (ClassCastException cce) {
            throw new SyslogRuntimeException("config must implement AbstractSyslogConfigIF", new Object[0]);
        }
        this.pool = this.createPool();
    }

    public AbstractSyslogWriter makeObject() throws Exception {
        AbstractSyslogWriter syslogWriter = this.syslog.createWriter();
        if (this.syslogConfig.isThreaded()) {
            this.syslog.createWriterThread(syslogWriter);
        }
        return syslogWriter;
    }

    public void destroyObject(AbstractSyslogWriter writer) throws Exception {
        writer.shutdown();
        super.destroyObject((Object)writer);
    }

    public abstract ObjectPool<AbstractSyslogWriter> createPool() throws SyslogRuntimeException;

    public AbstractSyslogWriter borrowSyslogWriter() throws Exception {
        AbstractSyslogWriter syslogWriter = (AbstractSyslogWriter)this.pool.borrowObject();
        return syslogWriter;
    }

    public void returnSyslogWriter(AbstractSyslogWriter syslogWriter) throws Exception {
        this.pool.returnObject((Object)syslogWriter);
    }

    public void clear() throws Exception {
        this.pool.clear();
    }

    public void close() throws Exception {
        this.pool.close();
    }
}

