/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.syslog4j.impl.net.udp;

import com.moonlit.syslog4j.SyslogLevel;
import com.moonlit.syslog4j.SyslogRuntimeException;
import com.moonlit.syslog4j.impl.AbstractSyslogWriter;
import com.moonlit.syslog4j.impl.net.AbstractNetSyslog;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;

public class UDPNetSyslog
extends AbstractNetSyslog {
    protected DatagramSocket socket = null;

    @Override
    public void initialize() throws SyslogRuntimeException {
        super.initialize();
        this.createDatagramSocket(true);
    }

    protected synchronized void createDatagramSocket(boolean initialize) {
        try {
            this.socket = new DatagramSocket();
        }
        catch (SocketException se) {
            if (initialize) {
                if (this.syslogConfig.isThrowExceptionOnInitialize()) {
                    throw new SyslogRuntimeException(se);
                }
            }
            throw new SyslogRuntimeException(se);
        }
        if (this.socket == null) {
            throw new SyslogRuntimeException("Cannot seem to get a Datagram socket", new Object[0]);
        }
    }

    @Override
    protected void write(SyslogLevel level, byte[] message) throws SyslogRuntimeException {
        if (this.socket == null) {
            this.createDatagramSocket(false);
        }
        InetAddress hostAddress = this.getHostAddress();
        DatagramPacket packet = new DatagramPacket(message, message.length, hostAddress, this.syslogConfig.getPort());
        int attempts = 0;
        while (attempts != -1 && attempts < this.netSyslogConfig.getWriteRetries() + 1) {
            try {
                this.socket.send(packet);
                attempts = -1;
            }
            catch (IOException ioe) {
                if (attempts != this.netSyslogConfig.getWriteRetries() + 1) continue;
                throw new SyslogRuntimeException(ioe);
            }
        }
    }

    @Override
    public void flush() throws SyslogRuntimeException {
        this.shutdown();
        this.createDatagramSocket(true);
    }

    @Override
    public void shutdown() throws SyslogRuntimeException {
        if (this.socket != null) {
            this.socket.close();
            this.socket = null;
        }
    }

    @Override
    public AbstractSyslogWriter getWriter() {
        return null;
    }

    @Override
    public void returnWriter(AbstractSyslogWriter syslogWriter) {
    }
}

