/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.syslog4j.impl.message.modifier.sequential;

import com.moonlit.syslog4j.SyslogFacility;
import com.moonlit.syslog4j.SyslogIF;
import com.moonlit.syslog4j.SyslogLevel;
import com.moonlit.syslog4j.SyslogMessageModifierIF;
import com.moonlit.syslog4j.impl.message.modifier.sequential.SequentialSyslogMessageModifierConfig;

public class SequentialSyslogMessageModifier
implements SyslogMessageModifierIF {
    protected SequentialSyslogMessageModifierConfig config = null;
    protected long[] currentSequence = new long[SyslogLevel.values().length];

    public static final SequentialSyslogMessageModifier createDefault() {
        SequentialSyslogMessageModifier modifier = new SequentialSyslogMessageModifier(SequentialSyslogMessageModifierConfig.createDefault());
        return modifier;
    }

    public SequentialSyslogMessageModifier(SequentialSyslogMessageModifierConfig config) {
        this.config = config;
        for (int i = 0; i < this.currentSequence.length; ++i) {
            this.currentSequence[i] = config.getFirstNumber();
        }
    }

    protected String pad(long number) {
        StringBuffer buffer = new StringBuffer(Long.toString(number));
        while ((long)buffer.length() < this.config.getLastNumberDigits()) {
            buffer.insert(0, this.config.getPadChar());
        }
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNextSequence(SyslogLevel level, long nextSequence) {
        if (nextSequence >= this.config.getFirstNumber() && nextSequence < this.config.getLastNumber()) {
            SequentialSyslogMessageModifier sequentialSyslogMessageModifier = this;
            synchronized (sequentialSyslogMessageModifier) {
                this.currentSequence[level.getValue()] = nextSequence;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String nextSequence(SyslogLevel syslogLevel) {
        long sequence = -1L;
        int level = syslogLevel.getValue();
        SequentialSyslogMessageModifier sequentialSyslogMessageModifier = this;
        synchronized (sequentialSyslogMessageModifier) {
            sequence = this.currentSequence[level];
            if (this.currentSequence[level] >= this.config.getLastNumber()) {
                this.currentSequence[level] = this.config.getFirstNumber();
            } else {
                int n = level;
                this.currentSequence[n] = this.currentSequence[n] + 1L;
            }
        }
        String _sequence = null;
        _sequence = this.config.isUsePadding() ? this.pad(sequence) : Long.toString(sequence);
        return _sequence;
    }

    public SequentialSyslogMessageModifierConfig getConfig() {
        return this.config;
    }

    @Override
    public String modify(SyslogIF syslog, SyslogFacility facility, SyslogLevel level, String message) {
        StringBuffer buffer = new StringBuffer(message);
        buffer.append(this.config.getPrefix());
        buffer.append(this.nextSequence(level));
        buffer.append(this.config.getSuffix());
        return buffer.toString();
    }

    @Override
    public boolean verify(String message) {
        return true;
    }
}

