/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.syslog4j.impl.message.modifier.checksum;

import com.moonlit.syslog4j.SyslogFacility;
import com.moonlit.syslog4j.SyslogIF;
import com.moonlit.syslog4j.SyslogLevel;
import com.moonlit.syslog4j.SyslogRuntimeException;
import com.moonlit.syslog4j.impl.message.modifier.AbstractSyslogMessageModifier;
import com.moonlit.syslog4j.impl.message.modifier.checksum.ChecksumSyslogMessageModifierConfig;
import com.moonlit.syslog4j.util.SyslogUtility;
import java.util.zip.Checksum;

public class ChecksumSyslogMessageModifier
extends AbstractSyslogMessageModifier {
    protected ChecksumSyslogMessageModifierConfig config = null;

    public static final ChecksumSyslogMessageModifier createCRC32() {
        ChecksumSyslogMessageModifier crc32 = new ChecksumSyslogMessageModifier(ChecksumSyslogMessageModifierConfig.createCRC32());
        return crc32;
    }

    public static final ChecksumSyslogMessageModifier createADLER32() {
        ChecksumSyslogMessageModifier adler32 = new ChecksumSyslogMessageModifier(ChecksumSyslogMessageModifierConfig.createADLER32());
        return adler32;
    }

    public ChecksumSyslogMessageModifier(ChecksumSyslogMessageModifierConfig config) {
        super(config);
        this.config = config;
        if (this.config == null) {
            throw new SyslogRuntimeException("Checksum config object cannot be null", new Object[0]);
        }
        if (this.config.getChecksum() == null) {
            throw new SyslogRuntimeException("Checksum object cannot be null", new Object[0]);
        }
    }

    public ChecksumSyslogMessageModifierConfig getConfig() {
        return this.config;
    }

    protected void continuousCheckForVerify() {
        if (this.config.isContinuous()) {
            throw new SyslogRuntimeException("%s.verify(..) does not work with isContinuous() returning true", this.getClass().getName());
        }
    }

    @Override
    public boolean verify(String message, String hexChecksum) {
        this.continuousCheckForVerify();
        long checksum = Long.parseLong(hexChecksum, 16);
        return this.verify(message, checksum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verify(String message, long checksum) {
        this.continuousCheckForVerify();
        Checksum checksum2 = this.config.getChecksum();
        synchronized (checksum2) {
            this.config.getChecksum().reset();
            byte[] messageBytes = SyslogUtility.getBytes(this.config, message);
            this.config.getChecksum().update(messageBytes, 0, message.length());
            return this.config.getChecksum().getValue() == checksum;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String modify(SyslogIF syslog, SyslogFacility facility, SyslogLevel level, String message) {
        Checksum checksum = this.config.getChecksum();
        synchronized (checksum) {
            StringBuffer messageBuffer = new StringBuffer(message);
            byte[] messageBytes = SyslogUtility.getBytes(syslog.getConfig(), message);
            if (!this.config.isContinuous()) {
                this.config.getChecksum().reset();
            }
            this.config.getChecksum().update(messageBytes, 0, message.length());
            messageBuffer.append(this.config.getPrefix());
            messageBuffer.append(Long.toHexString(this.config.getChecksum().getValue()).toUpperCase());
            messageBuffer.append(this.config.getSuffix());
            return messageBuffer.toString();
        }
    }
}

