/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.syslog4j.impl.backlog;

import com.moonlit.syslog4j.Syslog;
import com.moonlit.syslog4j.SyslogIF;
import com.moonlit.syslog4j.SyslogLevel;
import com.moonlit.syslog4j.SyslogRuntimeException;
import com.moonlit.syslog4j.impl.backlog.AbstractSyslogBackLogHandler;

public class Syslog4jBackLogHandler
extends AbstractSyslogBackLogHandler {
    protected SyslogIF syslog = null;
    protected SyslogLevel downLevel = SyslogLevel.WARN;
    protected SyslogLevel upLevel = SyslogLevel.WARN;

    public Syslog4jBackLogHandler(String protocol) {
        this.syslog = Syslog.getInstance(protocol);
    }

    public Syslog4jBackLogHandler(String protocol, boolean appendReason) {
        this.syslog = Syslog.getInstance(protocol);
        this.appendReason = appendReason;
    }

    public Syslog4jBackLogHandler(SyslogIF syslog) {
        this.syslog = syslog;
    }

    public Syslog4jBackLogHandler(SyslogIF syslog, boolean appendReason) {
        this.syslog = syslog;
        this.appendReason = appendReason;
    }

    @Override
    public void initialize() throws SyslogRuntimeException {
    }

    @Override
    public void log(SyslogIF syslog, SyslogLevel level, String message, String reason) throws SyslogRuntimeException {
        if (this.syslog.getProtocol().equals(syslog.getProtocol())) {
            throw new SyslogRuntimeException("Ignoring this log entry since the backLog protocol \"%s\" is the same as the main protocol", this.syslog.getProtocol());
        }
        String combinedMessage = this.combine(syslog, level, message, reason);
        this.syslog.log(level, combinedMessage);
    }

    @Override
    public void down(SyslogIF syslog, String reason) {
        if (!this.syslog.getProtocol().equals(syslog.getProtocol())) {
            this.syslog.log(this.downLevel, "Syslog protocol \"" + syslog.getProtocol() + "\" is down: " + reason);
        }
    }

    @Override
    public void up(SyslogIF syslog) {
        if (!this.syslog.getProtocol().equals(syslog.getProtocol())) {
            this.syslog.log(this.upLevel, "Syslog protocol \"" + syslog.getProtocol() + "\" is up");
        }
    }
}

