/*
 * Decompiled with CFR 0.152.
 */
package com.moonlit.syslog4j;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.moonlit.syslog4j.SyslogConfigIF;
import com.moonlit.syslog4j.SyslogIF;
import com.moonlit.syslog4j.SyslogMain;
import com.moonlit.syslog4j.SyslogRuntimeException;
import com.moonlit.syslog4j.impl.net.tcp.TCPNetSyslogConfig;
import com.moonlit.syslog4j.impl.net.udp.UDPNetSyslogConfig;
import com.moonlit.syslog4j.impl.unix.UnixSyslogConfig;
import com.moonlit.syslog4j.impl.unix.socket.UnixSocketSyslogConfig;
import com.moonlit.syslog4j.util.OSDetectUtility;
import com.moonlit.syslog4j.util.SyslogUtility;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public final class Syslog {
    protected static final Map<String, SyslogIF> instances = Maps.newHashMap();

    private Syslog() {
    }

    public static SyslogIF getInstance(String protocol) throws SyslogRuntimeException {
        String _protocol = protocol.toLowerCase();
        if (instances.containsKey(_protocol)) {
            return instances.get(_protocol);
        }
        StringBuffer message = new StringBuffer("Syslog protocol \"" + protocol + "\" not defined; call Syslogger.createSyslogInstance(protocol,config) first");
        if (instances.size() > 0) {
            message.append(" or use one of the following instances: ");
            Iterator<String> i = instances.keySet().iterator();
            while (i.hasNext()) {
                String k = i.next();
                message.append(k);
                if (!i.hasNext()) continue;
                message.append(' ');
            }
        }
        throw new SyslogRuntimeException(message.toString(), new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SyslogIF createInstance(String protocol, SyslogConfigIF config) throws SyslogRuntimeException {
        Preconditions.checkArgument((!StringUtils.isBlank((CharSequence)protocol) ? 1 : 0) != 0, (Object)"Instance protocol cannot be null or empty");
        Preconditions.checkArgument((config != null ? 1 : 0) != 0, (Object)"SyslogConfig cannot be null");
        String syslogProtocol = protocol.toLowerCase();
        SyslogIF syslog = null;
        Map<String, SyslogIF> map = instances;
        synchronized (map) {
            Preconditions.checkState((!instances.containsKey(syslogProtocol) ? 1 : 0) != 0, (String)"Syslog protocol \"%s\" already defined", (Object)protocol);
            try {
                Class<? extends SyslogIF> syslogClass = config.getSyslogClass();
                syslog = syslogClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception cse) {
                if (!config.isThrowExceptionOnInitialize()) {
                    throw new SyslogRuntimeException(cse);
                }
                return null;
            }
            syslog.initialize(syslogProtocol, config);
            instances.put(syslogProtocol, syslog);
        }
        return syslog;
    }

    public static boolean exists(String protocol) {
        if (StringUtils.isBlank((CharSequence)protocol)) {
            return false;
        }
        return instances.containsKey(protocol.toLowerCase());
    }

    public static synchronized void shutdown() {
        Set<String> protocols = instances.keySet();
        if (protocols.size() > 0) {
            Iterator<String> i = protocols.iterator();
            SyslogUtility.sleep(500L);
            while (i.hasNext()) {
                String protocol = i.next();
                SyslogIF syslog = instances.get(protocol);
                syslog.shutdown();
            }
            instances.clear();
        }
    }

    private static synchronized void initialize() {
        Syslog.createInstance("udp", new UDPNetSyslogConfig());
        Syslog.createInstance("tcp", new TCPNetSyslogConfig());
        if (OSDetectUtility.isUnix() && SyslogUtility.isClassExists("com.sun.jna.Native")) {
            Syslog.createInstance("unix_syslog", new UnixSyslogConfig());
            Syslog.createInstance("unix_socket", new UnixSocketSyslogConfig());
        }
    }

    static void reset() throws InterruptedException {
        Syslog.shutdown();
        Thread.sleep(200L);
        Syslog.initialize();
    }

    public static synchronized void destroyInstance(String protocol) throws SyslogRuntimeException {
        if (StringUtils.isBlank((CharSequence)protocol)) {
            return;
        }
        String _protocol = protocol.toLowerCase();
        if (instances.containsKey(_protocol)) {
            SyslogUtility.sleep(500L);
            SyslogIF syslog = instances.get(_protocol);
            try {
                syslog.shutdown();
            }
            finally {
                instances.remove(_protocol);
            }
        } else {
            throw new SyslogRuntimeException("Cannot destroy protocol \"%s\" instance; call shutdown instead", protocol);
        }
    }

    public static synchronized void destroyInstance(SyslogIF syslog) throws SyslogRuntimeException {
        if (syslog == null) {
            return;
        }
        String protocol = syslog.getProtocol().toLowerCase();
        if (instances.containsKey(protocol)) {
            try {
                syslog.shutdown();
            }
            finally {
                instances.remove(protocol);
            }
        } else {
            throw new SyslogRuntimeException("Cannot destroy protocol \"%s\" instance; call shutdown instead", protocol);
        }
    }

    public static void main(String[] args) throws Exception {
        SyslogMain.main(args);
    }

    static {
        Syslog.initialize();
    }
}

