/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.inprocess;

import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import io.grpc.Attributes;
import io.grpc.CallOptions;
import io.grpc.ClientStreamTracer;
import io.grpc.Compressor;
import io.grpc.Deadline;
import io.grpc.Decompressor;
import io.grpc.DecompressorRegistry;
import io.grpc.Grpc;
import io.grpc.InternalChannelz;
import io.grpc.InternalLogId;
import io.grpc.InternalMetadata;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.SecurityLevel;
import io.grpc.ServerStreamTracer;
import io.grpc.Status;
import io.grpc.SynchronizationContext;
import io.grpc.inprocess.InProcessServer;
import io.grpc.inprocess.InProcessSocketAddress;
import io.grpc.internal.ClientStream;
import io.grpc.internal.ClientStreamListener;
import io.grpc.internal.ClientTransport;
import io.grpc.internal.ConnectionClientTransport;
import io.grpc.internal.GrpcAttributes;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.InUseStateAggregator;
import io.grpc.internal.InsightBuilder;
import io.grpc.internal.ManagedClientTransport;
import io.grpc.internal.NoopClientStream;
import io.grpc.internal.ObjectPool;
import io.grpc.internal.ServerListener;
import io.grpc.internal.ServerStream;
import io.grpc.internal.ServerStreamListener;
import io.grpc.internal.ServerTransport;
import io.grpc.internal.ServerTransportListener;
import io.grpc.internal.StatsTraceContext;
import io.grpc.internal.StreamListener;
import java.io.InputStream;
import java.net.SocketAddress;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class InProcessTransport
implements ServerTransport,
ConnectionClientTransport {
    private static final Logger log = Logger.getLogger(InProcessTransport.class.getName());
    private final InternalLogId logId;
    private final SocketAddress address;
    private final int clientMaxInboundMetadataSize;
    private final String authority;
    private final String userAgent;
    private final Optional<ServerListener> optionalServerListener;
    private int serverMaxInboundMetadataSize;
    private final boolean includeCauseWithStatus;
    private ObjectPool<ScheduledExecutorService> serverSchedulerPool;
    private ScheduledExecutorService serverScheduler;
    private ServerTransportListener serverTransportListener;
    private Attributes serverStreamAttributes;
    private ManagedClientTransport.Listener clientTransportListener;
    @GuardedBy(value="this")
    private boolean shutdown;
    @GuardedBy(value="this")
    private boolean terminated;
    @GuardedBy(value="this")
    private Status shutdownStatus;
    @GuardedBy(value="this")
    private final Set<InProcessStream> streams = Collections.newSetFromMap(new IdentityHashMap());
    @GuardedBy(value="this")
    private List<ServerStreamTracer.Factory> serverStreamTracerFactories;
    private final Attributes attributes;
    private Thread.UncaughtExceptionHandler uncaughtExceptionHandler = new Thread.UncaughtExceptionHandler(){

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            if (e instanceof Error) {
                throw new Error(e);
            }
            throw new RuntimeException(e);
        }
    };
    @GuardedBy(value="this")
    private final InUseStateAggregator<InProcessStream> inUseState = new InUseStateAggregator<InProcessStream>(){

        @Override
        protected void handleInUse() {
            InProcessTransport.this.clientTransportListener.transportInUse(true);
        }

        @Override
        protected void handleNotInUse() {
            InProcessTransport.this.clientTransportListener.transportInUse(false);
        }
    };

    private InProcessTransport(SocketAddress address, int maxInboundMetadataSize, String authority, String userAgent, Attributes eagAttrs, Optional<ServerListener> optionalServerListener, boolean includeCauseWithStatus) {
        this.address = address;
        this.clientMaxInboundMetadataSize = maxInboundMetadataSize;
        this.authority = authority;
        this.userAgent = GrpcUtil.getGrpcUserAgent("inprocess", userAgent);
        Preconditions.checkNotNull((Object)eagAttrs, (Object)"eagAttrs");
        this.attributes = Attributes.newBuilder().set(GrpcAttributes.ATTR_SECURITY_LEVEL, SecurityLevel.PRIVACY_AND_INTEGRITY).set(GrpcAttributes.ATTR_CLIENT_EAG_ATTRS, eagAttrs).set(Grpc.TRANSPORT_ATTR_REMOTE_ADDR, address).set(Grpc.TRANSPORT_ATTR_LOCAL_ADDR, address).build();
        this.optionalServerListener = optionalServerListener;
        this.logId = InternalLogId.allocate(this.getClass(), address.toString());
        this.includeCauseWithStatus = includeCauseWithStatus;
    }

    public InProcessTransport(SocketAddress address, int maxInboundMetadataSize, String authority, String userAgent, Attributes eagAttrs, boolean includeCauseWithStatus) {
        this(address, maxInboundMetadataSize, authority, userAgent, eagAttrs, (Optional<ServerListener>)Optional.absent(), includeCauseWithStatus);
    }

    InProcessTransport(String name, int maxInboundMetadataSize, String authority, String userAgent, Attributes eagAttrs, ObjectPool<ScheduledExecutorService> serverSchedulerPool, List<ServerStreamTracer.Factory> serverStreamTracerFactories, ServerListener serverListener, boolean includeCauseWithStatus) {
        this(new InProcessSocketAddress(name), maxInboundMetadataSize, authority, userAgent, eagAttrs, (Optional<ServerListener>)Optional.of((Object)serverListener), includeCauseWithStatus);
        this.serverMaxInboundMetadataSize = maxInboundMetadataSize;
        this.serverSchedulerPool = serverSchedulerPool;
        this.serverStreamTracerFactories = serverStreamTracerFactories;
    }

    @Override
    @CheckReturnValue
    public synchronized Runnable start(ManagedClientTransport.Listener listener) {
        this.clientTransportListener = listener;
        if (this.optionalServerListener.isPresent()) {
            this.serverScheduler = this.serverSchedulerPool.getObject();
            this.serverTransportListener = ((ServerListener)this.optionalServerListener.get()).transportCreated(this);
        } else {
            InProcessServer server = InProcessServer.findServer(this.address);
            if (server != null) {
                this.serverMaxInboundMetadataSize = server.getMaxInboundMetadataSize();
                this.serverSchedulerPool = server.getScheduledExecutorServicePool();
                this.serverScheduler = this.serverSchedulerPool.getObject();
                this.serverStreamTracerFactories = server.getStreamTracerFactories();
                this.serverTransportListener = server.register(this);
            }
        }
        if (this.serverTransportListener == null) {
            final Status localShutdownStatus = this.shutdownStatus = Status.UNAVAILABLE.withDescription("Could not find server: " + this.address);
            return new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    InProcessTransport inProcessTransport = InProcessTransport.this;
                    synchronized (inProcessTransport) {
                        InProcessTransport.this.notifyShutdown(localShutdownStatus);
                        InProcessTransport.this.notifyTerminated();
                    }
                }
            };
        }
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                InProcessTransport inProcessTransport = InProcessTransport.this;
                synchronized (inProcessTransport) {
                    Attributes serverTransportAttrs = Attributes.newBuilder().set(Grpc.TRANSPORT_ATTR_REMOTE_ADDR, InProcessTransport.this.address).set(Grpc.TRANSPORT_ATTR_LOCAL_ADDR, InProcessTransport.this.address).build();
                    InProcessTransport.this.serverStreamAttributes = InProcessTransport.this.serverTransportListener.transportReady(serverTransportAttrs);
                    InProcessTransport.this.clientTransportListener.transportReady();
                }
            }
        };
    }

    @Override
    public synchronized ClientStream newStream(MethodDescriptor<?, ?> method, Metadata headers, CallOptions callOptions, ClientStreamTracer[] tracers) {
        int metadataSize;
        StatsTraceContext statsTraceContext = StatsTraceContext.newClientContext(tracers, this.getAttributes(), headers);
        if (this.shutdownStatus != null) {
            return this.failedClientStream(statsTraceContext, this.shutdownStatus);
        }
        headers.put(GrpcUtil.USER_AGENT_KEY, this.userAgent);
        if (this.serverMaxInboundMetadataSize != Integer.MAX_VALUE && (metadataSize = InProcessTransport.metadataSize(headers)) > this.serverMaxInboundMetadataSize) {
            Status status = Status.RESOURCE_EXHAUSTED.withDescription(String.format(Locale.US, "Request metadata larger than %d: %d", this.serverMaxInboundMetadataSize, metadataSize));
            return this.failedClientStream(statsTraceContext, status);
        }
        return new InProcessStream(method, headers, callOptions, this.authority, statsTraceContext).clientStream;
    }

    private ClientStream failedClientStream(final StatsTraceContext statsTraceCtx, final Status status) {
        return new NoopClientStream(){

            @Override
            public void start(ClientStreamListener listener) {
                statsTraceCtx.clientOutboundHeaders();
                statsTraceCtx.streamClosed(status);
                listener.closed(status, ClientStreamListener.RpcProgress.PROCESSED, new Metadata());
            }
        };
    }

    @Override
    public synchronized void ping(final ClientTransport.PingCallback callback, Executor executor) {
        if (this.terminated) {
            final Status shutdownStatus = this.shutdownStatus;
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    callback.onFailure(shutdownStatus.asRuntimeException());
                }
            });
        } else {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    callback.onSuccess(0L);
                }
            });
        }
    }

    @Override
    public synchronized void shutdown(Status reason) {
        if (this.shutdown) {
            return;
        }
        this.shutdownStatus = reason;
        this.notifyShutdown(reason);
        if (this.streams.isEmpty()) {
            this.notifyTerminated();
        }
    }

    @Override
    public synchronized void shutdown() {
        this.shutdown(Status.UNAVAILABLE.withDescription("InProcessTransport shutdown by the server-side"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdownNow(Status reason) {
        ArrayList<InProcessStream> streamsCopy;
        Preconditions.checkNotNull((Object)reason, (Object)"reason");
        InProcessTransport inProcessTransport = this;
        synchronized (inProcessTransport) {
            this.shutdown(reason);
            if (this.terminated) {
                return;
            }
            streamsCopy = new ArrayList<InProcessStream>(this.streams);
        }
        for (InProcessStream stream : streamsCopy) {
            stream.clientStream.cancel(reason);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("logId", this.logId.getId()).add("address", (Object)this.address).toString();
    }

    @Override
    public InternalLogId getLogId() {
        return this.logId;
    }

    @Override
    public Attributes getAttributes() {
        return this.attributes;
    }

    @Override
    public ScheduledExecutorService getScheduledExecutorService() {
        return this.serverScheduler;
    }

    @Override
    public ListenableFuture<InternalChannelz.SocketStats> getStats() {
        SettableFuture ret = SettableFuture.create();
        ret.set(null);
        return ret;
    }

    private synchronized void notifyShutdown(Status s) {
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
        this.clientTransportListener.transportShutdown(s);
    }

    private synchronized void notifyTerminated() {
        if (this.terminated) {
            return;
        }
        this.terminated = true;
        if (this.serverScheduler != null) {
            this.serverScheduler = this.serverSchedulerPool.returnObject(this.serverScheduler);
        }
        this.clientTransportListener.transportTerminated();
        if (this.serverTransportListener != null) {
            this.serverTransportListener.transportTerminated();
        }
    }

    private static int metadataSize(Metadata metadata) {
        byte[][] serialized = InternalMetadata.serialize(metadata);
        if (serialized == null) {
            return 0;
        }
        long size = 0L;
        for (int i = 0; i < serialized.length; i += 2) {
            size += (long)(32 + serialized[i].length + serialized[i + 1].length);
        }
        size = Math.min(size, Integer.MAX_VALUE);
        return (int)size;
    }

    private static Status cleanStatus(Status status, boolean includeCauseWithStatus) {
        if (status == null) {
            return null;
        }
        Status clientStatus = Status.fromCodeValue(status.getCode().value()).withDescription(status.getDescription());
        if (includeCauseWithStatus) {
            clientStatus = clientStatus.withCause(status.getCause());
        }
        return clientStatus;
    }

    private static class SingleMessageProducer
    implements StreamListener.MessageProducer {
        private InputStream message;

        private SingleMessageProducer(InputStream message) {
            this.message = message;
        }

        @Override
        @Nullable
        public InputStream next() {
            InputStream messageToReturn = this.message;
            this.message = null;
            return messageToReturn;
        }
    }

    private class InProcessStream {
        private final InProcessClientStream clientStream;
        private final InProcessServerStream serverStream;
        private final CallOptions callOptions;
        private final Metadata headers;
        private final MethodDescriptor<?, ?> method;
        private volatile String authority;

        private InProcessStream(MethodDescriptor<?, ?> method, Metadata headers, CallOptions callOptions, String authority, StatsTraceContext statsTraceContext) {
            this.method = (MethodDescriptor)Preconditions.checkNotNull(method, (Object)"method");
            this.headers = (Metadata)Preconditions.checkNotNull((Object)headers, (Object)"headers");
            this.callOptions = (CallOptions)Preconditions.checkNotNull((Object)callOptions, (Object)"callOptions");
            this.authority = authority;
            this.clientStream = new InProcessClientStream(callOptions, statsTraceContext);
            this.serverStream = new InProcessServerStream(method, headers);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void streamClosed() {
            InProcessTransport inProcessTransport = InProcessTransport.this;
            synchronized (inProcessTransport) {
                boolean justRemovedAnElement = InProcessTransport.this.streams.remove(this);
                if (GrpcUtil.shouldBeCountedForInUse(this.callOptions)) {
                    InProcessTransport.this.inUseState.updateObjectInUse(this, false);
                }
                if (InProcessTransport.this.streams.isEmpty() && justRemovedAnElement && InProcessTransport.this.shutdown) {
                    InProcessTransport.this.notifyTerminated();
                }
            }
        }

        private class InProcessClientStream
        implements ClientStream {
            final StatsTraceContext statsTraceCtx;
            final CallOptions callOptions;
            private ServerStreamListener serverStreamListener;
            private final SynchronizationContext syncContext;
            @GuardedBy(value="this")
            private int serverRequested;
            @GuardedBy(value="this")
            private ArrayDeque<StreamListener.MessageProducer> serverReceiveQueue;
            @GuardedBy(value="this")
            private boolean serverNotifyHalfClose;
            @GuardedBy(value="this")
            private boolean closed;
            @GuardedBy(value="this")
            private int outboundSeqNo;

            InProcessClientStream(CallOptions callOptions, StatsTraceContext statsTraceContext) {
                this.syncContext = new SynchronizationContext(InProcessTransport.this.uncaughtExceptionHandler);
                this.serverReceiveQueue = new ArrayDeque();
                this.callOptions = callOptions;
                this.statsTraceCtx = statsTraceContext;
            }

            private synchronized void setListener(ServerStreamListener listener) {
                this.serverStreamListener = listener;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void request(int numMessages) {
                boolean onReady = InProcessStream.this.serverStream.clientRequested(numMessages);
                if (onReady) {
                    InProcessClientStream inProcessClientStream = this;
                    synchronized (inProcessClientStream) {
                        if (!this.closed) {
                            this.syncContext.executeLater(() -> this.serverStreamListener.onReady());
                        }
                    }
                    this.syncContext.drain();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean serverRequested(int numMessages) {
                boolean nowReady;
                boolean previouslyReady;
                InProcessClientStream inProcessClientStream = this;
                synchronized (inProcessClientStream) {
                    if (this.closed) {
                        return false;
                    }
                    previouslyReady = this.serverRequested > 0;
                    this.serverRequested += numMessages;
                    while (this.serverRequested > 0 && !this.serverReceiveQueue.isEmpty()) {
                        --this.serverRequested;
                        StreamListener.MessageProducer producer = this.serverReceiveQueue.poll();
                        this.syncContext.executeLater(() -> this.serverStreamListener.messagesAvailable(producer));
                    }
                    if (this.serverReceiveQueue.isEmpty() && this.serverNotifyHalfClose) {
                        this.serverNotifyHalfClose = false;
                        this.syncContext.executeLater(() -> this.serverStreamListener.halfClosed());
                    }
                    nowReady = this.serverRequested > 0;
                }
                this.syncContext.drain();
                return !previouslyReady && nowReady;
            }

            private void serverClosed(Status serverListenerStatus, Status serverTracerStatus) {
                this.internalCancel(serverListenerStatus, serverTracerStatus);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void writeMessage(InputStream message) {
                InProcessClientStream inProcessClientStream = this;
                synchronized (inProcessClientStream) {
                    if (this.closed) {
                        return;
                    }
                    this.statsTraceCtx.outboundMessage(this.outboundSeqNo);
                    this.statsTraceCtx.outboundMessageSent(this.outboundSeqNo, -1L, -1L);
                    ((InProcessStream)InProcessStream.this).serverStream.statsTraceCtx.inboundMessage(this.outboundSeqNo);
                    ((InProcessStream)InProcessStream.this).serverStream.statsTraceCtx.inboundMessageRead(this.outboundSeqNo, -1L, -1L);
                    ++this.outboundSeqNo;
                    SingleMessageProducer producer = new SingleMessageProducer(message);
                    if (this.serverRequested > 0) {
                        --this.serverRequested;
                        this.syncContext.executeLater(() -> this.serverStreamListener.messagesAvailable(producer));
                    } else {
                        this.serverReceiveQueue.add(producer);
                    }
                }
                this.syncContext.drain();
            }

            @Override
            public void flush() {
            }

            @Override
            public synchronized boolean isReady() {
                if (this.closed) {
                    return false;
                }
                return this.serverRequested > 0;
            }

            @Override
            public void cancel(Status reason) {
                Status serverStatus = InProcessTransport.cleanStatus(reason, InProcessTransport.this.includeCauseWithStatus);
                if (!this.internalCancel(serverStatus, serverStatus)) {
                    return;
                }
                InProcessStream.this.serverStream.clientCancelled(reason);
                InProcessStream.this.streamClosed();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean internalCancel(Status serverListenerStatus, Status serverTracerStatus) {
                InProcessClientStream inProcessClientStream = this;
                synchronized (inProcessClientStream) {
                    StreamListener.MessageProducer producer;
                    if (this.closed) {
                        return false;
                    }
                    this.closed = true;
                    while ((producer = this.serverReceiveQueue.poll()) != null) {
                        InputStream message;
                        while ((message = producer.next()) != null) {
                            try {
                                message.close();
                            }
                            catch (Throwable t) {
                                log.log(Level.WARNING, "Exception closing stream", t);
                            }
                        }
                    }
                    ((InProcessStream)InProcessStream.this).serverStream.statsTraceCtx.streamClosed(serverTracerStatus);
                    this.syncContext.executeLater(() -> this.serverStreamListener.closed(serverListenerStatus));
                }
                this.syncContext.drain();
                return true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void halfClose() {
                InProcessClientStream inProcessClientStream = this;
                synchronized (inProcessClientStream) {
                    if (this.closed) {
                        return;
                    }
                    if (this.serverReceiveQueue.isEmpty()) {
                        this.syncContext.executeLater(() -> this.serverStreamListener.halfClosed());
                    } else {
                        this.serverNotifyHalfClose = true;
                    }
                }
                this.syncContext.drain();
            }

            @Override
            public void setMessageCompression(boolean enable) {
            }

            @Override
            public void setAuthority(String string) {
                InProcessStream.this.authority = string;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void start(ClientStreamListener listener) {
                InProcessStream.this.serverStream.setListener(listener);
                InProcessTransport inProcessTransport = InProcessTransport.this;
                synchronized (inProcessTransport) {
                    this.statsTraceCtx.clientOutboundHeaders();
                    InProcessTransport.this.streams.add(InProcessStream.this);
                    if (GrpcUtil.shouldBeCountedForInUse(this.callOptions)) {
                        InProcessTransport.this.inUseState.updateObjectInUse(InProcessStream.this, true);
                    }
                    InProcessTransport.this.serverTransportListener.streamCreated(InProcessStream.this.serverStream, InProcessStream.this.method.getFullMethodName(), InProcessStream.this.headers);
                }
            }

            @Override
            public Attributes getAttributes() {
                return InProcessTransport.this.attributes;
            }

            @Override
            public void optimizeForDirectExecutor() {
            }

            @Override
            public void setCompressor(Compressor compressor) {
            }

            @Override
            public void setFullStreamDecompression(boolean fullStreamDecompression) {
            }

            @Override
            public void setDecompressorRegistry(DecompressorRegistry decompressorRegistry) {
            }

            @Override
            public void setMaxInboundMessageSize(int maxSize) {
            }

            @Override
            public void setMaxOutboundMessageSize(int maxSize) {
            }

            @Override
            public void setDeadline(Deadline deadline) {
                InProcessStream.this.headers.discardAll(GrpcUtil.TIMEOUT_KEY);
                long effectiveTimeout = Math.max(0L, deadline.timeRemaining(TimeUnit.NANOSECONDS));
                InProcessStream.this.headers.put(GrpcUtil.TIMEOUT_KEY, effectiveTimeout);
            }

            @Override
            public void appendTimeoutInsight(InsightBuilder insight) {
            }
        }

        private class InProcessServerStream
        implements ServerStream {
            final StatsTraceContext statsTraceCtx;
            private ClientStreamListener clientStreamListener;
            private final SynchronizationContext syncContext;
            @GuardedBy(value="this")
            private int clientRequested;
            @GuardedBy(value="this")
            private ArrayDeque<StreamListener.MessageProducer> clientReceiveQueue;
            @GuardedBy(value="this")
            private Status clientNotifyStatus;
            @GuardedBy(value="this")
            private Metadata clientNotifyTrailers;
            @GuardedBy(value="this")
            private boolean closed;
            @GuardedBy(value="this")
            private int outboundSeqNo;

            InProcessServerStream(MethodDescriptor<?, ?> method, Metadata headers) {
                this.syncContext = new SynchronizationContext(InProcessTransport.this.uncaughtExceptionHandler);
                this.clientReceiveQueue = new ArrayDeque();
                this.statsTraceCtx = StatsTraceContext.newServerContext(InProcessTransport.this.serverStreamTracerFactories, method.getFullMethodName(), headers);
            }

            private synchronized void setListener(ClientStreamListener listener) {
                this.clientStreamListener = listener;
            }

            @Override
            public void setListener(ServerStreamListener serverStreamListener) {
                InProcessStream.this.clientStream.setListener(serverStreamListener);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void request(int numMessages) {
                boolean onReady = InProcessStream.this.clientStream.serverRequested(numMessages);
                if (onReady) {
                    InProcessServerStream inProcessServerStream = this;
                    synchronized (inProcessServerStream) {
                        if (!this.closed) {
                            this.syncContext.executeLater(() -> this.clientStreamListener.onReady());
                        }
                    }
                }
                this.syncContext.drain();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean clientRequested(int numMessages) {
                boolean nowReady;
                boolean previouslyReady;
                InProcessServerStream inProcessServerStream = this;
                synchronized (inProcessServerStream) {
                    if (this.closed) {
                        return false;
                    }
                    previouslyReady = this.clientRequested > 0;
                    this.clientRequested += numMessages;
                    while (this.clientRequested > 0 && !this.clientReceiveQueue.isEmpty()) {
                        --this.clientRequested;
                        StreamListener.MessageProducer producer = this.clientReceiveQueue.poll();
                        this.syncContext.executeLater(() -> this.clientStreamListener.messagesAvailable(producer));
                    }
                    if (this.clientReceiveQueue.isEmpty() && this.clientNotifyStatus != null) {
                        this.closed = true;
                        ((InProcessStream)InProcessStream.this).clientStream.statsTraceCtx.clientInboundTrailers(this.clientNotifyTrailers);
                        ((InProcessStream)InProcessStream.this).clientStream.statsTraceCtx.streamClosed(this.clientNotifyStatus);
                        Status notifyStatus = this.clientNotifyStatus;
                        Metadata notifyTrailers = this.clientNotifyTrailers;
                        this.syncContext.executeLater(() -> this.clientStreamListener.closed(notifyStatus, ClientStreamListener.RpcProgress.PROCESSED, notifyTrailers));
                    }
                    nowReady = this.clientRequested > 0;
                }
                this.syncContext.drain();
                return !previouslyReady && nowReady;
            }

            private void clientCancelled(Status status) {
                this.internalCancel(status);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void writeMessage(InputStream message) {
                InProcessServerStream inProcessServerStream = this;
                synchronized (inProcessServerStream) {
                    if (this.closed) {
                        return;
                    }
                    this.statsTraceCtx.outboundMessage(this.outboundSeqNo);
                    this.statsTraceCtx.outboundMessageSent(this.outboundSeqNo, -1L, -1L);
                    ((InProcessStream)InProcessStream.this).clientStream.statsTraceCtx.inboundMessage(this.outboundSeqNo);
                    ((InProcessStream)InProcessStream.this).clientStream.statsTraceCtx.inboundMessageRead(this.outboundSeqNo, -1L, -1L);
                    ++this.outboundSeqNo;
                    SingleMessageProducer producer = new SingleMessageProducer(message);
                    if (this.clientRequested > 0) {
                        --this.clientRequested;
                        this.syncContext.executeLater(() -> this.clientStreamListener.messagesAvailable(producer));
                    } else {
                        this.clientReceiveQueue.add(producer);
                    }
                }
                this.syncContext.drain();
            }

            @Override
            public void flush() {
            }

            @Override
            public synchronized boolean isReady() {
                if (this.closed) {
                    return false;
                }
                return this.clientRequested > 0;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void writeHeaders(Metadata headers, boolean flush) {
                int metadataSize;
                if (InProcessTransport.this.clientMaxInboundMetadataSize != Integer.MAX_VALUE && (metadataSize = InProcessTransport.metadataSize(headers)) > InProcessTransport.this.clientMaxInboundMetadataSize) {
                    Status serverStatus = Status.CANCELLED.withDescription("Client cancelled the RPC");
                    InProcessStream.this.clientStream.serverClosed(serverStatus, serverStatus);
                    Status failedStatus = Status.RESOURCE_EXHAUSTED.withDescription(String.format(Locale.US, "Response header metadata larger than %d: %d", InProcessTransport.this.clientMaxInboundMetadataSize, metadataSize));
                    this.notifyClientClose(failedStatus, new Metadata());
                    return;
                }
                InProcessServerStream inProcessServerStream = this;
                synchronized (inProcessServerStream) {
                    if (this.closed) {
                        return;
                    }
                    ((InProcessStream)InProcessStream.this).clientStream.statsTraceCtx.clientInboundHeaders();
                    this.syncContext.executeLater(() -> this.clientStreamListener.headersRead(headers));
                }
                this.syncContext.drain();
            }

            @Override
            public void close(Status status, Metadata trailers) {
                InProcessStream.this.clientStream.serverClosed(Status.OK, status);
                if (InProcessTransport.this.clientMaxInboundMetadataSize != Integer.MAX_VALUE) {
                    int statusSize = status.getDescription() == null ? 0 : status.getDescription().length();
                    int metadataSize = InProcessTransport.metadataSize(trailers) + statusSize;
                    if (metadataSize > InProcessTransport.this.clientMaxInboundMetadataSize) {
                        status = Status.RESOURCE_EXHAUSTED.withDescription(String.format(Locale.US, "Response header metadata larger than %d: %d", InProcessTransport.this.clientMaxInboundMetadataSize, metadataSize));
                        trailers = new Metadata();
                    }
                }
                this.notifyClientClose(status, trailers);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void notifyClientClose(Status status, Metadata trailers) {
                Status clientStatus = InProcessTransport.cleanStatus(status, InProcessTransport.this.includeCauseWithStatus);
                InProcessServerStream inProcessServerStream = this;
                synchronized (inProcessServerStream) {
                    if (this.closed) {
                        return;
                    }
                    if (this.clientReceiveQueue.isEmpty()) {
                        this.closed = true;
                        ((InProcessStream)InProcessStream.this).clientStream.statsTraceCtx.clientInboundTrailers(trailers);
                        ((InProcessStream)InProcessStream.this).clientStream.statsTraceCtx.streamClosed(clientStatus);
                        this.syncContext.executeLater(() -> this.clientStreamListener.closed(clientStatus, ClientStreamListener.RpcProgress.PROCESSED, trailers));
                    } else {
                        this.clientNotifyStatus = clientStatus;
                        this.clientNotifyTrailers = trailers;
                    }
                }
                this.syncContext.drain();
                InProcessStream.this.streamClosed();
            }

            @Override
            public void cancel(Status status) {
                if (!this.internalCancel(Status.CANCELLED.withDescription("server cancelled stream"))) {
                    return;
                }
                InProcessStream.this.clientStream.serverClosed(status, status);
                InProcessStream.this.streamClosed();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean internalCancel(Status clientStatus) {
                InProcessServerStream inProcessServerStream = this;
                synchronized (inProcessServerStream) {
                    StreamListener.MessageProducer producer;
                    if (this.closed) {
                        return false;
                    }
                    this.closed = true;
                    while ((producer = this.clientReceiveQueue.poll()) != null) {
                        InputStream message;
                        while ((message = producer.next()) != null) {
                            try {
                                message.close();
                            }
                            catch (Throwable t) {
                                log.log(Level.WARNING, "Exception closing stream", t);
                            }
                        }
                    }
                    ((InProcessStream)InProcessStream.this).clientStream.statsTraceCtx.streamClosed(clientStatus);
                    this.syncContext.executeLater(() -> this.clientStreamListener.closed(clientStatus, ClientStreamListener.RpcProgress.PROCESSED, new Metadata()));
                }
                this.syncContext.drain();
                return true;
            }

            @Override
            public void setMessageCompression(boolean enable) {
            }

            @Override
            public void optimizeForDirectExecutor() {
            }

            @Override
            public void setCompressor(Compressor compressor) {
            }

            @Override
            public void setDecompressor(Decompressor decompressor) {
            }

            @Override
            public Attributes getAttributes() {
                return InProcessTransport.this.serverStreamAttributes;
            }

            @Override
            public String getAuthority() {
                return InProcessStream.this.authority;
            }

            @Override
            public StatsTraceContext statsTraceContext() {
                return this.statsTraceCtx;
            }

            @Override
            public int streamId() {
                return -1;
            }
        }
    }
}

