/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1beta2.stub;

import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcRawCallableFactory;
import com.google.api.gax.retrying.ExponentialRetryAlgorithm;
import com.google.api.gax.retrying.ScheduledRetryingExecutor;
import com.google.api.gax.retrying.StreamingRetryAlgorithm;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.Callables;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsExtractor;
import com.google.api.gax.rpc.ServerStreamingCallSettings;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.gax.tracing.SpanName;
import com.google.api.gax.tracing.TracedServerStreamingCallable;
import com.google.cloud.bigquery.storage.v1beta2.BigQueryReadGrpc;
import com.google.cloud.bigquery.storage.v1beta2.BigQueryReadSettings;
import com.google.cloud.bigquery.storage.v1beta2.CreateReadSessionRequest;
import com.google.cloud.bigquery.storage.v1beta2.ReadRowsRequest;
import com.google.cloud.bigquery.storage.v1beta2.ReadRowsResponse;
import com.google.cloud.bigquery.storage.v1beta2.ReadSession;
import com.google.cloud.bigquery.storage.v1beta2.SplitReadStreamRequest;
import com.google.cloud.bigquery.storage.v1beta2.SplitReadStreamResponse;
import com.google.cloud.bigquery.storage.v1beta2.stub.BigQueryReadStubSettings;
import com.google.cloud.bigquery.storage.v1beta2.stub.EnhancedBigQueryReadStubSettings;
import com.google.cloud.bigquery.storage.v1beta2.stub.GrpcBigQueryReadStub;
import com.google.cloud.bigquery.storage.v1beta2.stub.readrows.ApiResultRetryAlgorithm;
import com.google.cloud.bigquery.storage.v1beta2.stub.readrows.ReadRowsRetryingCallable;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class EnhancedBigQueryReadStub
implements BackgroundResource {
    private static final String TRACING_OUTER_CLIENT_NAME = "BigQueryStorage";
    private final GrpcBigQueryReadStub stub;
    private final BigQueryReadStubSettings stubSettings;
    private final BigQueryReadSettings.RetryAttemptListener readRowsRetryAttemptListener;
    private final ClientContext context;

    public static EnhancedBigQueryReadStub create(EnhancedBigQueryReadStubSettings settings) throws IOException {
        return EnhancedBigQueryReadStub.create(settings, null);
    }

    public static EnhancedBigQueryReadStub create(EnhancedBigQueryReadStubSettings settings, BigQueryReadSettings.RetryAttemptListener readRowsRetryAttemptListener) throws IOException {
        BigQueryReadStubSettings.Builder baseSettingsBuilder = (BigQueryReadStubSettings.Builder)((BigQueryReadStubSettings.Builder)((BigQueryReadStubSettings.Builder)((BigQueryReadStubSettings.Builder)((BigQueryReadStubSettings.Builder)((BigQueryReadStubSettings.Builder)BigQueryReadStubSettings.newBuilder().setTransportChannelProvider(settings.getTransportChannelProvider())).setEndpoint(settings.getEndpoint())).setHeaderProvider(settings.getHeaderProvider())).setCredentialsProvider(settings.getCredentialsProvider())).setStreamWatchdogCheckInterval(settings.getStreamWatchdogCheckInterval())).setStreamWatchdogProvider(settings.getStreamWatchdogProvider());
        baseSettingsBuilder.createReadSessionSettings().setRetryableCodes(settings.createReadSessionSettings().getRetryableCodes()).setRetrySettings(settings.createReadSessionSettings().getRetrySettings());
        baseSettingsBuilder.readRowsSettings().setRetryableCodes(settings.readRowsSettings().getRetryableCodes()).setRetrySettings(settings.readRowsSettings().getRetrySettings()).setResumptionStrategy(settings.readRowsSettings().getResumptionStrategy()).setIdleTimeout(settings.readRowsSettings().getIdleTimeout());
        baseSettingsBuilder.splitReadStreamSettings().setRetryableCodes(settings.splitReadStreamSettings().getRetryableCodes()).setRetrySettings(settings.splitReadStreamSettings().getRetrySettings());
        BigQueryReadStubSettings baseSettings = baseSettingsBuilder.build();
        ClientContext clientContext = ClientContext.create(baseSettings);
        GrpcBigQueryReadStub stub = new GrpcBigQueryReadStub(baseSettings, clientContext);
        return new EnhancedBigQueryReadStub(stub, baseSettings, readRowsRetryAttemptListener, clientContext);
    }

    @InternalApi(value="Visible for testing")
    EnhancedBigQueryReadStub(GrpcBigQueryReadStub stub, BigQueryReadStubSettings stubSettings, BigQueryReadSettings.RetryAttemptListener readRowsRetryAttemptListener, ClientContext context) {
        this.stub = stub;
        this.stubSettings = stubSettings;
        this.readRowsRetryAttemptListener = readRowsRetryAttemptListener;
        this.context = context;
    }

    public UnaryCallable<CreateReadSessionRequest, ReadSession> createReadSessionCallable() {
        return this.stub.createReadSessionCallable();
    }

    public ServerStreamingCallable<ReadRowsRequest, ReadRowsResponse> readRowsCallable() {
        ServerStreamingCallable<ReadRowsRequest, ReadRowsResponse> innerCallable = GrpcRawCallableFactory.createServerStreamingCallable(GrpcCallSettings.newBuilder().setMethodDescriptor(BigQueryReadGrpc.getReadRowsMethod()).setParamsExtractor(new RequestParamsExtractor<ReadRowsRequest>(){

            @Override
            public Map<String, String> extract(ReadRowsRequest request) {
                return ImmutableMap.of((Object)"read_stream", (Object)String.valueOf(request.getReadStream()));
            }
        }).build(), this.stubSettings.readRowsSettings().getRetryableCodes());
        ServerStreamingCallSettings<ReadRowsRequest, ReadRowsResponse> callSettings = this.stubSettings.readRowsSettings();
        StreamingRetryAlgorithm retryAlgorithm = new StreamingRetryAlgorithm(new ApiResultRetryAlgorithm(this.readRowsRetryAttemptListener), (TimedRetryAlgorithm)new ExponentialRetryAlgorithm(callSettings.getRetrySettings(), this.context.getClock()));
        ScheduledRetryingExecutor<Void> retryingExecutor = new ScheduledRetryingExecutor<Void>(retryAlgorithm, this.context.getExecutor());
        if (this.context.getStreamWatchdog() != null) {
            innerCallable = Callables.watched(innerCallable, callSettings, this.context);
        }
        ReadRowsRetryingCallable outerCallable = new ReadRowsRetryingCallable(this.context.getDefaultCallContext(), innerCallable, retryingExecutor, callSettings.getResumptionStrategy());
        TracedServerStreamingCallable<ReadRowsRequest, ReadRowsResponse> traced = new TracedServerStreamingCallable<ReadRowsRequest, ReadRowsResponse>(outerCallable, this.context.getTracerFactory(), SpanName.of(TRACING_OUTER_CLIENT_NAME, "ReadRows"));
        return traced.withDefaultCallContext(this.context.getDefaultCallContext());
    }

    public UnaryCallable<SplitReadStreamRequest, SplitReadStreamResponse> splitReadStreamCallable() {
        return this.stub.splitReadStreamCallable();
    }

    @Override
    public void close() {
        this.stub.close();
    }

    @Override
    public void shutdown() {
        this.stub.shutdown();
    }

    @Override
    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    @Override
    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    @Override
    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

