/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1beta1.stub.readrows;

import com.google.api.core.InternalApi;
import com.google.api.gax.retrying.ResultRetryAlgorithm;
import com.google.api.gax.retrying.TimedAttemptSettings;
import com.google.api.gax.rpc.ApiException;
import com.google.cloud.bigquery.storage.util.Errors;
import com.google.cloud.bigquery.storage.v1beta1.BigQueryStorageSettings;
import io.grpc.Metadata;
import io.grpc.Status;
import org.threeten.bp.Duration;

@InternalApi
public class ApiResultRetryAlgorithm<ResponseT>
implements ResultRetryAlgorithm<ResponseT> {
    public static final Duration DEADLINE_SLEEP_DURATION = Duration.ofMillis(1L);
    private final BigQueryStorageSettings.RetryAttemptListener retryAttemptListener;

    public ApiResultRetryAlgorithm() {
        this(null);
    }

    public ApiResultRetryAlgorithm(BigQueryStorageSettings.RetryAttemptListener retryAttemptListener) {
        this.retryAttemptListener = retryAttemptListener;
    }

    @Override
    public TimedAttemptSettings createNextAttempt(Throwable prevThrowable, ResponseT prevResponse, TimedAttemptSettings prevSettings) {
        if (prevThrowable != null) {
            Status status = Status.fromThrowable(prevThrowable);
            Metadata metadata = Status.trailersFromThrowable(prevThrowable);
            Errors.IsRetryableStatusResult result = Errors.isRetryableStatus(status, metadata);
            if (result.isRetryable) {
                Duration retryDelay = result.retryDelay;
                Duration randomizedRetryDelay = result.retryDelay;
                if (retryDelay == null) {
                    retryDelay = prevSettings.getRetryDelay();
                    randomizedRetryDelay = DEADLINE_SLEEP_DURATION;
                }
                if (this.retryAttemptListener != null) {
                    this.retryAttemptListener.onRetryAttempt(status, metadata);
                }
                return TimedAttemptSettings.newBuilder().setGlobalSettings(prevSettings.getGlobalSettings()).setRetryDelay(retryDelay).setRpcTimeout(prevSettings.getRpcTimeout()).setRandomizedRetryDelay(randomizedRetryDelay).setAttemptCount(prevSettings.getAttemptCount() + 1).setFirstAttemptStartTimeNanos(prevSettings.getFirstAttemptStartTimeNanos()).build();
            }
        }
        return null;
    }

    @Override
    public boolean shouldRetry(Throwable prevThrowable, ResponseT prevResponse) {
        if (prevThrowable != null) {
            Status status = Status.fromThrowable(prevThrowable);
            Metadata metadata = Status.trailersFromThrowable(prevThrowable);
            if (Errors.isRetryableStatus((Status)status, (Metadata)metadata).isRetryable) {
                return true;
            }
        }
        return prevThrowable instanceof ApiException && ((ApiException)prevThrowable).isRetryable();
    }
}

